/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.management.impl;

import com.sap.jvm.management.KVMVirtualizationMXBean;
import com.sap.jvm.management.impl.Util;
import com.sap.jvm.management.impl.VirtualizationMBeanProvider;
import java.util.Map;
import javax.management.ObjectName;

public class KVMVirtualization
implements KVMVirtualizationMXBean {
    public static final int TIME_RESOLUTION = 5000;
    private Map<String, String> infoMap;
    private long lastCheck = 0L;
    private String hostTotalCPUTime = null;
    private long hostPagedOutMemory = -1L;
    private long hostPagedInMemory = -1L;
    private long hostUsedVirtualMemory = -1L;
    private long hostFreeVirtualMemory = -1L;
    private long hostMemoryAllocatedToVirtualServers = -1L;
    private long hostNumberOfPhysicalCPUs = -1L;
    private String hostSystemInfo = null;
    private String hostVirtProductInfo = null;
    private String hostVirtualizationVendor = null;
    private String hostName = null;
    private long domUPhysicalMemoryAllocatedToVirtualSystem = -1L;
    private long domUResourceProcessorLimit = -1L;
    private String domUTotalCPUTime = null;
    private long domUId = -1L;
    private String domUUuid = null;

    private synchronized void checkState() {
        long actTime = System.currentTimeMillis();
        if (actTime - this.lastCheck > 5000L) {
            this.lastCheck = actTime;
            this.infoMap = VirtualizationMBeanProvider.getPlatformAttributes();
            this.hostTotalCPUTime = Util.getStringValue("HOST_TotalCPUTime", this.infoMap, null);
            this.hostPagedOutMemory = Util.getLongValue("HOST_PagedOutMemory", this.infoMap, -1L);
            this.hostPagedInMemory = Util.getLongValue("HOST_PagedInMemory", this.infoMap, -1L);
            this.hostUsedVirtualMemory = Util.getLongValue("HOST_UsedVirtualMemoryMB", this.infoMap, -1L);
            this.hostFreeVirtualMemory = Util.getLongValue("HOST_FreeVirtualMemoryMB", this.infoMap, -1L);
            this.hostMemoryAllocatedToVirtualServers = Util.getLongValue("HOST_MemoryAllocatedToVirtualServersMB", this.infoMap, -1L);
            this.hostNumberOfPhysicalCPUs = Util.getLongValue("HOST_NumberOfPhysicalCPUs", this.infoMap, -1L);
            this.hostSystemInfo = Util.getStringValue("HOST_HostSystemInfo", this.infoMap, null);
            this.hostVirtProductInfo = Util.getStringValue("HOST_VirtProductInfo", this.infoMap, null);
            this.hostVirtualizationVendor = Util.getStringValue("HOST_VirtualizationVendor", this.infoMap, null);
            this.hostName = Util.getStringValue("HOST_HostName", this.infoMap, null);
            this.domUPhysicalMemoryAllocatedToVirtualSystem = Util.getLongValue("VM_domU_PhysicalMemoryAllocatedToVirtualSystemMB", this.infoMap, -1L);
            this.domUResourceProcessorLimit = Util.getLongValue("VM_domU_ResourceProcessorLimit", this.infoMap, -1L);
            this.domUTotalCPUTime = Util.getStringValue("VM_domU_TotalCPUTime", this.infoMap, null);
            this.domUId = Util.getLongValue("VM_domU_Id", this.infoMap, -1L);
            this.domUUuid = Util.getStringValue("VM_domU_Uuid", this.infoMap, null);
        }
    }

    @Override
    public String getHostTotalCPUTime() {
        this.checkState();
        return this.hostTotalCPUTime;
    }

    @Override
    public long getHostPagedOutMemory() {
        this.checkState();
        return this.hostPagedOutMemory;
    }

    @Override
    public long getHostPagedInMemory() {
        this.checkState();
        return this.hostPagedInMemory;
    }

    @Override
    public long getHostUsedVirtualMemoryMB() {
        this.checkState();
        return this.hostUsedVirtualMemory;
    }

    @Override
    public long getHostFreeVirtualMemoryMB() {
        this.checkState();
        return this.hostFreeVirtualMemory;
    }

    @Override
    public long getHostMemoryAllocatedToVirtualServersMB() {
        this.checkState();
        return this.hostMemoryAllocatedToVirtualServers;
    }

    @Override
    public long getHostNumberOfPhysicalCPUs() {
        this.checkState();
        return this.hostNumberOfPhysicalCPUs;
    }

    @Override
    public String getHostSystemInfo() {
        this.checkState();
        return this.hostSystemInfo;
    }

    @Override
    public String getHostName() {
        this.checkState();
        return this.hostName;
    }

    @Override
    public String getHostVirtProductInfo() {
        this.checkState();
        return this.hostVirtProductInfo;
    }

    @Override
    public String getHostVirtualizationVendor() {
        this.checkState();
        return this.hostVirtualizationVendor;
    }

    @Override
    public long getGuestDomUPhysicalMemoryAllocatedToVirtualSystemMB() {
        this.checkState();
        return this.domUPhysicalMemoryAllocatedToVirtualSystem;
    }

    @Override
    public long getGuestDomUResourceProcessorLimit() {
        this.checkState();
        return this.domUResourceProcessorLimit;
    }

    @Override
    public String getGuestDomUTotalCPUTime() {
        this.checkState();
        return this.domUTotalCPUTime;
    }

    @Override
    public String getGuestDomUUuid() {
        this.checkState();
        return this.domUUuid;
    }

    @Override
    public long getGuestDomUId() {
        this.checkState();
        return this.domUId;
    }

    @Override
    public String getVirtualizationPlatform() {
        return "KVM";
    }

    @Override
    public ObjectName getObjectName() {
        return sun.management.Util.newObjectName("sap.management:type=Virtualization");
    }
}

