/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.management.impl;

import com.sap.jvm.management.PowerKVMVirtualizationMXBean;
import com.sap.jvm.management.impl.Util;
import com.sap.jvm.management.impl.VirtualizationMBeanProvider;
import java.util.Map;
import javax.management.ObjectName;

public class PowerKVMVirtualization
implements PowerKVMVirtualizationMXBean {
    public static final int TIME_RESOLUTION = 1000;
    private Map<String, String> infoMap;
    private long lastCheck = 0L;
    private String lparType;
    private int lparLcpu;
    private int lparThreads;
    private int lparVcpu;

    private synchronized void checkState() {
        long actTime = System.currentTimeMillis();
        if (actTime - this.lastCheck > 1000L) {
            this.lastCheck = actTime;
            this.infoMap = VirtualizationMBeanProvider.getPlatformAttributes();
            this.lparType = Util.getStringValue("LPAR_type", this.infoMap, "");
            this.lparLcpu = Util.getIntValue("LPAR_lcpu", this.infoMap, -1);
            this.lparThreads = Util.getIntValue("LPAR_threads", this.infoMap, -1);
            this.lparVcpu = Util.getIntValue("LPAR_vcpu", this.infoMap, -1);
        }
    }

    @Override
    public String getVirtualizationPlatform() {
        return "Linux PowerKVM";
    }

    @Override
    public String getLParType() {
        this.checkState();
        return this.lparType;
    }

    @Override
    public int getLParLcpu() {
        this.checkState();
        return this.lparLcpu;
    }

    @Override
    public int getLParThreads() {
        this.checkState();
        return this.lparThreads;
    }

    @Override
    public int getLParVcpu() {
        this.checkState();
        return this.lparVcpu;
    }

    @Override
    public ObjectName getObjectName() {
        return sun.management.Util.newObjectName("sap.management:type=Virtualization");
    }
}

