/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.management.impl;

import com.sap.jvm.management.PowerLinuxVirtualizationMXBean;
import com.sap.jvm.management.impl.Util;
import com.sap.jvm.management.impl.VirtualizationMBeanProvider;
import java.util.Map;
import javax.management.ObjectName;

public class PowerLinuxVirtualization
implements PowerLinuxVirtualizationMXBean {
    public static final int TIME_RESOLUTION = 1000;
    private Map<String, String> infoMap;
    private long lastCheck = 0L;
    private String lparType;
    private String lparMode;
    private float lparEnt;
    private int lparLcpu;
    private int lparThreads;
    private int lparVcpu;
    private int sharedPoolId;
    private int sharedPoolVarProcCapacityWeight;
    private float sharedPoolPhysCpusPool;

    private synchronized void checkState() {
        long actTime = System.currentTimeMillis();
        if (actTime - this.lastCheck > 1000L) {
            this.lastCheck = actTime;
            this.infoMap = VirtualizationMBeanProvider.getPlatformAttributes();
            this.lparType = Util.getStringValue("LPAR_type", this.infoMap, "");
            this.lparMode = Util.getStringValue("LPAR_mode", this.infoMap, "");
            this.lparEnt = Util.getFloatValue("LPAR_ent", this.infoMap, -1.0f);
            this.lparLcpu = Util.getIntValue("LPAR_lcpu", this.infoMap, -1);
            this.lparThreads = Util.getIntValue("LPAR_threads", this.infoMap, -1);
            this.lparVcpu = Util.getIntValue("LPAR_vcpu", this.infoMap, -1);
            this.sharedPoolId = Util.getIntValue("SHAREDPOOL_pool_id", this.infoMap, -1);
            this.sharedPoolVarProcCapacityWeight = Util.getIntValue("SHAREDPOOL_var_proc_capacity_weight", this.infoMap, -1);
            this.sharedPoolPhysCpusPool = Util.getFloatValue("SHAREDPOOL_phys_cpus_pool", this.infoMap, -1.0f);
        }
    }

    @Override
    public String getVirtualizationPlatform() {
        return "Linux PowerVM";
    }

    @Override
    public String getLParType() {
        this.checkState();
        return this.lparType;
    }

    @Override
    public String getLParMode() {
        this.checkState();
        return this.lparMode;
    }

    @Override
    public float getLParEntitlement() {
        this.checkState();
        return this.lparEnt;
    }

    @Override
    public int getLParLcpu() {
        this.checkState();
        return this.lparLcpu;
    }

    @Override
    public int getLParThreads() {
        this.checkState();
        return this.lparThreads;
    }

    @Override
    public int getLParVcpu() {
        this.checkState();
        return this.lparVcpu;
    }

    @Override
    public int getSharedPoolId() {
        this.checkState();
        return this.sharedPoolId;
    }

    @Override
    public int getSharedPoolVarProcCapacityWeight() {
        this.checkState();
        return this.sharedPoolVarProcCapacityWeight;
    }

    @Override
    public float getSharedPoolPhysCpusPool() {
        this.checkState();
        return this.sharedPoolPhysCpusPool;
    }

    @Override
    public ObjectName getObjectName() {
        return sun.management.Util.newObjectName("sap.management:type=Virtualization");
    }
}

