/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.management.impl;

import com.sap.jvm.management.PowerVMVirtualizationMXBean;
import com.sap.jvm.management.impl.Util;
import com.sap.jvm.management.impl.VirtualizationMBeanProvider;
import java.util.Map;
import javax.management.ObjectName;

public class PowerVMVirtualization
implements PowerVMVirtualizationMXBean {
    public static final int TIME_RESOLUTION = 5000;
    private Map<String, String> infoMap;
    private long lastCheck = 0L;
    private String cpuDdescription;
    private int cpuProcessorMHz;
    private String cpuVersion;
    private String lparName;
    private String lparType;
    private String lparMode;
    private String lparSmt;
    private float lparEnt;
    private int lparLcpu;
    private int lparThreads;
    private int lparVcpu;
    private String lparAms;
    private String lparAme;
    private String lparPowerSaving;
    private String wparType;
    private String wparName;
    private int wparId;
    private String wparCpuRset;
    private String wparCpuXrset;
    private String wparCpuLimits;
    private String wparMemLimits;
    private int wparCpuLimit;
    private int wparMemLimit;
    private int sharedPoolId;
    private int sharedPoolVarProcCapacityWeight;
    private int sharedPoolPhysCpusPool;
    private float sharedPoolEntitledPoolCapacity;
    private long ameTrueMemoryBytes;
    private long ameExpandedMemoryBytes;
    private float ameTargetMemexpFactr;
    private float ameCurrentMemexpFactr;
    private long ameCmcsTotalTime;

    private synchronized void checkState() {
        long actTime = System.currentTimeMillis();
        if (actTime - this.lastCheck > 1000L) {
            this.lastCheck = actTime;
            this.infoMap = VirtualizationMBeanProvider.getPlatformAttributes();
            this.cpuDdescription = Util.getStringValue("CPU_description", this.infoMap, "");
            this.cpuProcessorMHz = Util.getIntValue("CPU_processorMHz", this.infoMap, -1);
            this.cpuVersion = Util.getStringValue("CPU_version", this.infoMap, "");
            this.lparName = Util.getStringValue("LPAR_name", this.infoMap, "");
            this.lparType = Util.getStringValue("LPAR_type", this.infoMap, "");
            this.lparMode = Util.getStringValue("LPAR_mode", this.infoMap, "");
            this.lparSmt = Util.getStringValue("LPAR_smt", this.infoMap, "");
            this.lparEnt = Util.getFloatValue("LPAR_ent", this.infoMap, -1.0f);
            this.lparLcpu = Util.getIntValue("LPAR_lcpu", this.infoMap, -1);
            this.lparThreads = Util.getIntValue("LPAR_threads", this.infoMap, -1);
            this.lparVcpu = Util.getIntValue("LPAR_vcpu", this.infoMap, -1);
            this.lparAms = Util.getStringValue("LPAR_ams", this.infoMap, "");
            this.lparAme = Util.getStringValue("LPAR_ame", this.infoMap, "");
            this.lparPowerSaving = Util.getStringValue("LPAR_power_saving", this.infoMap, "");
            this.wparType = Util.getStringValue("WPAR_type", this.infoMap, "");
            this.wparName = Util.getStringValue("WPAR_name", this.infoMap, "");
            this.wparCpuLimits = Util.getStringValue("WPAR_cpu_limits", this.infoMap, "");
            this.wparMemLimits = Util.getStringValue("WPAR_mem_limits", this.infoMap, "");
            this.wparId = Util.getIntValue("WPAR_id", this.infoMap, -1);
            this.wparCpuRset = Util.getStringValue("WPAR_cpu_rset", this.infoMap, "");
            this.wparCpuXrset = Util.getStringValue("WPAR_cpu_xrset", this.infoMap, "");
            this.wparCpuLimit = Util.getIntValue("WPAR_cpu_limit%", this.infoMap, -1);
            this.wparMemLimit = Util.getIntValue("WPAR_mem_limit%", this.infoMap, -1);
            this.sharedPoolId = Util.getIntValue("SHAREDPOOL_pool_id", this.infoMap, -1);
            this.sharedPoolVarProcCapacityWeight = Util.getIntValue("SHAREDPOOL_var_proc_capacity_weight", this.infoMap, -1);
            this.sharedPoolPhysCpusPool = Util.getIntValue("SHAREDPOOL_phys_cpus_pool", this.infoMap, -1);
            this.sharedPoolEntitledPoolCapacity = Util.getFloatValue("SHAREDPOOL_entitled_pool_capacity", this.infoMap, -1.0f);
            this.ameTrueMemoryBytes = Util.getLongValue("AME_true_memory_Bytes", this.infoMap, -1L);
            this.ameExpandedMemoryBytes = Util.getLongValue("AME_expanded_memory_Bytes", this.infoMap, -1L);
            this.ameTargetMemexpFactr = Util.getFloatValue("AME_target_memexp_factr", this.infoMap, -1.0f);
            this.ameCurrentMemexpFactr = Util.getFloatValue("AME_current_memexp_factr", this.infoMap, -1.0f);
            this.ameCmcsTotalTime = Util.getLongValue("AME_cmcs_total_time", this.infoMap, -1L);
        }
    }

    @Override
    public String getVirtualizationPlatform() {
        return "PowerVM";
    }

    @Override
    public String getDescription() {
        this.checkState();
        return this.cpuDdescription;
    }

    @Override
    public int getProcessorMHz() {
        this.checkState();
        return this.cpuProcessorMHz;
    }

    @Override
    public String getVersion() {
        this.checkState();
        return this.cpuVersion;
    }

    @Override
    public String getLParName() {
        this.checkState();
        return this.lparName;
    }

    @Override
    public String getLParType() {
        this.checkState();
        return this.lparType;
    }

    @Override
    public String getLParMode() {
        this.checkState();
        return this.lparMode;
    }

    @Override
    public String getLParSmt() {
        this.checkState();
        return this.lparSmt;
    }

    @Override
    public float getLParEntitlement() {
        this.checkState();
        return this.lparEnt;
    }

    @Override
    public int getLParLcpu() {
        this.checkState();
        return this.lparLcpu;
    }

    @Override
    public int getLParThreads() {
        this.checkState();
        return this.lparThreads;
    }

    @Override
    public int getLParVcpu() {
        this.checkState();
        return this.lparVcpu;
    }

    @Override
    public String getLParAms() {
        this.checkState();
        return this.lparAms;
    }

    @Override
    public String getLParAme() {
        this.checkState();
        return this.lparAme;
    }

    @Override
    public String getLParPowerSaving() {
        this.checkState();
        return this.lparPowerSaving;
    }

    @Override
    public String getWParType() {
        this.checkState();
        return this.wparType;
    }

    @Override
    public String getWParName() {
        this.checkState();
        return this.wparName;
    }

    @Override
    public int getWParId() {
        this.checkState();
        return this.wparId;
    }

    @Override
    public String getWParCpuRset() {
        this.checkState();
        return this.wparCpuRset;
    }

    @Override
    public String getWParCpuXrset() {
        this.checkState();
        return this.wparCpuXrset;
    }

    @Override
    public String getWParCpuLimits() {
        this.checkState();
        return this.wparCpuLimits;
    }

    @Override
    public String getWParMemLimits() {
        this.checkState();
        return this.wparMemLimits;
    }

    @Override
    public int getWParCpuLimit() {
        this.checkState();
        return this.wparCpuLimit;
    }

    @Override
    public int getWParMemLimit() {
        this.checkState();
        return this.wparMemLimit;
    }

    @Override
    public int getSharedPoolId() {
        this.checkState();
        return this.sharedPoolId;
    }

    @Override
    public int getSharedPoolVarProcCapacityWeight() {
        this.checkState();
        return this.sharedPoolVarProcCapacityWeight;
    }

    @Override
    public int getSharedPoolPhysCpusPool() {
        this.checkState();
        return this.sharedPoolPhysCpusPool;
    }

    @Override
    public float getSharedPoolEntitledPoolCapacity() {
        this.checkState();
        return this.sharedPoolEntitledPoolCapacity;
    }

    @Override
    public long getAmeTrueMemoryBytes() {
        this.checkState();
        return this.ameTrueMemoryBytes;
    }

    @Override
    public long getAmeExpandedMemoryBytes() {
        this.checkState();
        return this.ameExpandedMemoryBytes;
    }

    @Override
    public float getAmeTargetMemexpFactr() {
        this.checkState();
        return this.ameTargetMemexpFactr;
    }

    @Override
    public float getAmeCurrentMemexpFactr() {
        this.checkState();
        return this.ameCurrentMemexpFactr;
    }

    @Override
    public long getAmeCmcsTotalTime() {
        this.checkState();
        return this.ameCmcsTotalTime;
    }

    @Override
    public ObjectName getObjectName() {
        return sun.management.Util.newObjectName("sap.management:type=Virtualization");
    }
}

