/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.management.impl;

import com.sap.jvm.management.SystemProblemReportingMXBean;
import javax.management.ObjectName;
import sun.management.Util;

public class SystemProblemReporting
implements SystemProblemReportingMXBean {
    private static final long SHORT_PERIOD = 60000L;
    private static final long MEDIUM_PERIOD = 300000L;
    private static final long LONG_PERIOD = 900000L;

    @Override
    public double[] getFullGcWorkTimeRatio() {
        long now = System.currentTimeMillis();
        double[] result = new double[]{SystemProblemReporting.getFullGcWorkRatio(now - 60000L, now), SystemProblemReporting.getFullGcWorkRatio(now - 300000L, now), SystemProblemReporting.getFullGcWorkRatio(now - 900000L, now)};
        return result;
    }

    @Override
    public double[] getGcWorkTimeRatio() {
        long now = System.currentTimeMillis();
        double[] result = new double[]{SystemProblemReporting.getGcWorkRatio(now - 60000L, now), SystemProblemReporting.getGcWorkRatio(now - 300000L, now), SystemProblemReporting.getGcWorkRatio(now - 900000L, now)};
        return result;
    }

    @Override
    public double[] getSystemLoadAverage() {
        double[] result = new double[3];
        int retrieved = SystemProblemReporting.getSystemLoadAverage0(result, result.length);
        if (retrieved < 0) {
            for (int i = 0; i < result.length; ++i) {
                result[i] = -1.0;
            }
        }
        return result;
    }

    @Override
    public ObjectName getObjectName() {
        return Util.newObjectName("sap.management:type=SystemProblemReporting");
    }

    private static native double getFullGcWorkRatio(long var0, long var2);

    private static native double getGcWorkRatio(long var0, long var2);

    private static native int getSystemLoadAverage0(double[] var0, int var1);
}

