/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.management.impl;

import com.sap.jvm.management.VSphereVirtualizationMXBean;
import com.sap.jvm.management.impl.Util;
import com.sap.jvm.management.impl.VirtualizationMBeanProvider;
import java.util.Map;
import javax.management.ObjectName;

public class VSphereVirtualization
implements VSphereVirtualizationMXBean {
    public static final int TIME_RESOLUTION = 1000;
    private Map<String, String> infoMap;
    private long lastCheck = 0L;
    private long cpuReservationMHz = -1L;
    private long cpuLimitMHz = -1L;
    private long cpuElapsedMs = -1L;
    private long cpuUsedMs = -1L;
    private long cpuShares = -1L;
    private long cpuStolenMs = -1L;
    private long memoryReservationMB = -1L;
    private long memoryLimitMB = -1L;
    private long memoryShares = -1L;
    private long memoryMappedMB = -1L;
    private long memoryActiveMB = -1L;
    private long memoryOverheadMB = -1L;
    private long memoryBalloonedMB = -1L;
    private long memorySwappedMB = -1L;
    private long memorySharedMB = -1L;
    private long memorySharedSavedMB = -1L;
    private long memoryUsedMB = -1L;
    private long memoryTargetSizeMB = -1L;
    private long hostProcessorSpeedMHz = -1L;
    private long hostNumCpuCores = -1L;
    private long hostMemSwappedMB = -1L;
    private long hostMemSharedMB = -1L;
    private long hostMemUsedMB = -1L;
    private long hostMemPhysMB = -1L;
    private long hostMemPhysFreeMB = -1L;
    private long hostMemKernOvhdMB = -1L;
    private long hostMemMappedMB = -1L;
    private long hostMemUnmappedMB = -1L;
    private String resourcePoolPath = "";
    private float cpuUtilization060 = -1.0f;
    private float cpuUtilization300 = -1.0f;
    private float cpuUtilization900 = -1.0f;

    private synchronized void checkState() {
        long actTime = System.currentTimeMillis();
        if (actTime - this.lastCheck > 1000L) {
            this.lastCheck = actTime;
            this.infoMap = VirtualizationMBeanProvider.getPlatformAttributes();
            this.hostProcessorSpeedMHz = Util.getLongValue("HOST_ProcessorSpeedMHz", this.infoMap, -1L);
            this.cpuLimitMHz = Util.getLongValue("CPU_LimitMHz", this.infoMap, -1L);
            this.cpuReservationMHz = Util.getLongValue("CPU_ReservationMHz", this.infoMap, -1L);
            this.cpuShares = Util.getLongValue("CPU_Shares", this.infoMap, -1L);
            this.cpuStolenMs = Util.getLongValue("CPU_StolenMs", this.infoMap, -1L);
            this.cpuUsedMs = Util.getLongValue("CPU_CpuUsedMs", this.infoMap, -1L);
            this.cpuElapsedMs = Util.getLongValue("CPU_ElapsedMs", this.infoMap, -1L);
            this.memoryReservationMB = Util.getLongValue("MEMORY_ReservationMB", this.infoMap, -1L);
            this.memoryLimitMB = Util.getLongValue("MEMORY_LimitMB", this.infoMap, -1L);
            this.memoryShares = Util.getLongValue("MEMORY_Shares", this.infoMap, -1L);
            this.memoryMappedMB = Util.getLongValue("MEMORY_MappedMB", this.infoMap, -1L);
            this.memoryOverheadMB = Util.getLongValue("MEMORY_OverheadMB", this.infoMap, -1L);
            this.memoryBalloonedMB = Util.getLongValue("MEMORY_BalloonedMB", this.infoMap, -1L);
            this.memorySwappedMB = Util.getLongValue("MEMORY_SwappedMB", this.infoMap, -1L);
            this.memorySharedMB = Util.getLongValue("MEMORY_SharedMB", this.infoMap, -1L);
            this.memorySharedSavedMB = Util.getLongValue("MEMORY_SharedSavedMB", this.infoMap, -1L);
            this.memoryUsedMB = Util.getLongValue("MEMORY_SharedSavedMB", this.infoMap, -1L);
            this.memoryTargetSizeMB = Util.getLongValue("MEMORY_SharedSavedMB", this.infoMap, -1L);
            this.memoryActiveMB = Util.getLongValue("MEMORY_ActiveMB", this.infoMap, -1L);
            this.hostNumCpuCores = Util.getLongValue("HOST_NumCpuCores", this.infoMap, -1L);
            this.hostMemSwappedMB = Util.getLongValue("HOST_MemSwappedMB", this.infoMap, -1L);
            this.hostMemSharedMB = Util.getLongValue("HOST_MemSharedMB", this.infoMap, -1L);
            this.hostMemUsedMB = Util.getLongValue("HOST_MemUsedMB", this.infoMap, -1L);
            this.hostMemPhysMB = Util.getLongValue("HOST_MemPhysMB", this.infoMap, -1L);
            this.hostMemPhysFreeMB = Util.getLongValue("HOST_MemPhysFreeMB", this.infoMap, -1L);
            this.hostMemKernOvhdMB = Util.getLongValue("HOST_MemKernOvhdMB", this.infoMap, -1L);
            this.hostMemMappedMB = Util.getLongValue("HOST_MemMappedMB", this.infoMap, -1L);
            this.hostMemUnmappedMB = Util.getLongValue("HOST_MemUnmappedMB", this.infoMap, -1L);
            this.resourcePoolPath = Util.getStringValue("RESOURCE_PoolPath", this.infoMap, "");
            this.cpuUtilization060 = Util.getFloatValue("CPU_utilization_060", this.infoMap, -1.0f);
            this.cpuUtilization300 = Util.getFloatValue("CPU_utilization_300", this.infoMap, -1.0f);
            this.cpuUtilization900 = Util.getFloatValue("CPU_utilization_900", this.infoMap, -1.0f);
        }
    }

    @Override
    public long getHostProcessorSpeedMHz() {
        this.checkState();
        return this.hostProcessorSpeedMHz;
    }

    @Override
    public long getCpuLimitMHz() {
        this.checkState();
        return this.cpuLimitMHz;
    }

    @Override
    public long getCpuReservationMHz() {
        this.checkState();
        return this.cpuReservationMHz;
    }

    @Override
    public long getCpuShares() {
        this.checkState();
        return this.cpuShares;
    }

    @Override
    public long getCpuStolenMs() {
        this.checkState();
        return this.cpuStolenMs;
    }

    @Override
    public long getCpuUsedMs() {
        this.checkState();
        return this.cpuUsedMs;
    }

    @Override
    public long getCpuElapsedMs() {
        this.checkState();
        return this.cpuElapsedMs;
    }

    @Override
    public long getMemoryReservationMB() {
        this.checkState();
        return this.memoryReservationMB;
    }

    @Override
    public long getMemoryLimitMB() {
        this.checkState();
        return this.memoryLimitMB;
    }

    @Override
    public long getMemoryShares() {
        this.checkState();
        return this.memoryShares;
    }

    @Override
    public long getMemoryMappedMB() {
        this.checkState();
        return this.memoryMappedMB;
    }

    @Override
    public long getMemoryActiveMB() {
        this.checkState();
        return this.memoryActiveMB;
    }

    @Override
    public long getMemoryOverheadMB() {
        this.checkState();
        return this.memoryOverheadMB;
    }

    @Override
    public long getMemoryBalloonedMB() {
        this.checkState();
        return this.memoryBalloonedMB;
    }

    @Override
    public long getMemorySwappedMB() {
        this.checkState();
        return this.memorySwappedMB;
    }

    @Override
    public long getMemorySharedMB() {
        this.checkState();
        return this.memorySharedMB;
    }

    @Override
    public long getMemorySharedSavedMB() {
        this.checkState();
        return this.memorySharedSavedMB;
    }

    @Override
    public long getMemoryUsedMB() {
        this.checkState();
        return this.memoryUsedMB;
    }

    @Override
    public long getMemoryTargetSizeMB() {
        this.checkState();
        return this.memoryTargetSizeMB;
    }

    @Override
    public String getVirtualizationPlatform() {
        return "VMware vSphere";
    }

    @Override
    public float getCpuUtilization060() {
        this.checkState();
        return this.cpuUtilization060;
    }

    @Override
    public float getCpuUtilization300() {
        this.checkState();
        return this.cpuUtilization300;
    }

    @Override
    public float getCpuUtilization900() {
        this.checkState();
        return this.cpuUtilization900;
    }

    @Override
    public long getHostNumCpuCores() {
        this.checkState();
        return this.hostNumCpuCores;
    }

    @Override
    public long getHostMemSwappedMB() {
        this.checkState();
        return this.hostMemSwappedMB;
    }

    @Override
    public long getHostMemSharedMB() {
        this.checkState();
        return this.hostMemSharedMB;
    }

    @Override
    public long getHostMemUsedMB() {
        this.checkState();
        return this.hostMemUsedMB;
    }

    @Override
    public long getHostMemPhysMB() {
        this.checkState();
        return this.hostMemPhysMB;
    }

    @Override
    public long getHostMemPhysFreeMB() {
        this.checkState();
        return this.hostMemPhysFreeMB;
    }

    @Override
    public long getHostMemKernOvhdMB() {
        this.checkState();
        return this.hostMemKernOvhdMB;
    }

    @Override
    public long getHostMemMappedMB() {
        this.checkState();
        return this.hostMemMappedMB;
    }

    @Override
    public long getHostMemUnmappedMB() {
        this.checkState();
        return this.hostMemUnmappedMB;
    }

    @Override
    public String getResourcePoolPath() {
        this.checkState();
        return this.resourcePoolPath;
    }

    @Override
    public ObjectName getObjectName() {
        return sun.management.Util.newObjectName("sap.management:type=Virtualization");
    }
}

