/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.management.impl;

import com.sap.jvm.management.HPVMVirtualizationMXBean;
import com.sap.jvm.management.KVMVirtualizationMXBean;
import com.sap.jvm.management.PowerFullPartitionVirtualizationMXBean;
import com.sap.jvm.management.PowerKVMVirtualizationMXBean;
import com.sap.jvm.management.PowerLinuxVirtualizationMXBean;
import com.sap.jvm.management.PowerVMVirtualizationMXBean;
import com.sap.jvm.management.SolarisZonesVirtualizationMXBean;
import com.sap.jvm.management.VSphereVirtualizationMXBean;
import com.sap.jvm.management.VirtualizationMXBean;
import com.sap.jvm.management.XenVirtualizationMXBean;
import com.sap.jvm.management.impl.HPVMVirtualization;
import com.sap.jvm.management.impl.KVMVirtualization;
import com.sap.jvm.management.impl.PowerFullPartitionVirtualization;
import com.sap.jvm.management.impl.PowerKVMVirtualization;
import com.sap.jvm.management.impl.PowerLinuxVirtualization;
import com.sap.jvm.management.impl.PowerVMVirtualization;
import com.sap.jvm.management.impl.SolarisZonesVirtualization;
import com.sap.jvm.management.impl.VSphereVirtualization;
import com.sap.jvm.management.impl.XenVirtualization;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import sun.management.Util;

public final class VirtualizationMBeanProvider {
    public static final String NO_OR_UNKNOWN_VIRTUAL_COMPUTING_PLATFORM = "No or unknown virtual computing platform";
    public static final String VIRTUALIZATION_PLATFORM_POWER_VM = "PowerVM";
    public static final String VIRTUALIZATION_PLATFORM_XEN = "Xen";
    public static final String VIRTUALIZATION_PLATFORM_KVM = "KVM";
    public static final String VIRTUALIZATION_PLATFORM_VMWARE = "VMware vSphere";
    public static final String VIRTUALIZATION_PLATFORM_SOLARIS_ZONES = "Solaris Zones";
    public static final String VIRTUALIZATION_PLATFORM_HP = "HP-UX Virtualization";
    public static final String VIRTUALIZATION_PLATFORM_HPVM = "Integrity Virtual Machine";
    public static final String VIRTUALIZATION_PLATFORM_HPVPARs = "Integrity Virtual Partition";
    public static final String VIRTUALIZATION_PLATFORM_LINUX_POWER_VM = "Linux PowerVM";
    public static final String VIRTUALIZATION_PLATFORM_LINUX_POWER_KVM = "Linux PowerKVM";
    public static final String VIRTUALIZATION_PLATFORM_LINUX_POWER_FULL_PARTITION = "Linux Power full partition mode";
    public static final String VIRTUALIZATION_PLATFORM = "VirtualizationPlatform";
    static Map<String, Class<?>> _interfaces = new HashMap();
    static HashMap<String, Class<? extends VirtualizationMXBean>> _implementations;
    private static VirtualizationMXBean _implementation;
    private static Class<?> _interface;

    public static VirtualizationMXBean getImplementation() {
        if (_implementation == null) {
            VirtualizationMBeanProvider.init();
        }
        return _implementation;
    }

    public static Class<?> getMbeanInterface() {
        if (_interface == null) {
            VirtualizationMBeanProvider.init();
        }
        return _interface;
    }

    public static synchronized Map<String, String> getPlatformAttributes() {
        HashMap<String, String> _infoMap = new HashMap<String, String>();
        try {
            byte[] rawData = AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

                @Override
                public byte[] run() {
                    return VirtualizationMBeanProvider.getVirtualizationInfo();
                }
            });
            if (rawData != null) {
                DataInputStream stream = new DataInputStream(new ByteArrayInputStream(rawData));
                int numInfos = stream.readInt();
                for (int i = 0; i < numInfos; i += 2) {
                    String key = stream.readUTF();
                    String value = stream.readUTF();
                    _infoMap.put(key, value);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return _infoMap;
    }

    private static void init() {
        String platform = VirtualizationMBeanProvider.getPlatformAttributes().get(VIRTUALIZATION_PLATFORM);
        if (platform != null) {
            _interface = _interfaces.get(platform);
            Class<? extends VirtualizationMXBean> implClass = _implementations.get(platform);
            if (implClass != null && _interface != null) {
                try {
                    _implementation = implClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    _interface = null;
                    _implementation = null;
                }
            }
        }
        if (_interface == null || _implementation == null) {
            _interface = VirtualizationMXBean.class;
            _implementation = new VirtualizationMXBean(){

                @Override
                public String getVirtualizationPlatform() {
                    return VirtualizationMBeanProvider.NO_OR_UNKNOWN_VIRTUAL_COMPUTING_PLATFORM;
                }

                @Override
                public ObjectName getObjectName() {
                    return Util.newObjectName("sap.management:type=Virtualization");
                }
            };
        }
    }

    private VirtualizationMBeanProvider() {
    }

    private static native byte[] getVirtualizationInfo();

    static {
        _interfaces.put(VIRTUALIZATION_PLATFORM_VMWARE, VSphereVirtualizationMXBean.class);
        _interfaces.put(VIRTUALIZATION_PLATFORM_POWER_VM, PowerVMVirtualizationMXBean.class);
        _interfaces.put(VIRTUALIZATION_PLATFORM_XEN, XenVirtualizationMXBean.class);
        _interfaces.put(VIRTUALIZATION_PLATFORM_KVM, KVMVirtualizationMXBean.class);
        _interfaces.put(VIRTUALIZATION_PLATFORM_SOLARIS_ZONES, SolarisZonesVirtualizationMXBean.class);
        _interfaces.put(VIRTUALIZATION_PLATFORM_HP, HPVMVirtualizationMXBean.class);
        _interfaces.put(VIRTUALIZATION_PLATFORM_LINUX_POWER_VM, PowerLinuxVirtualizationMXBean.class);
        _interfaces.put(VIRTUALIZATION_PLATFORM_LINUX_POWER_KVM, PowerKVMVirtualizationMXBean.class);
        _interfaces.put(VIRTUALIZATION_PLATFORM_LINUX_POWER_FULL_PARTITION, PowerFullPartitionVirtualizationMXBean.class);
        _implementations = new HashMap();
        _implementations.put(VIRTUALIZATION_PLATFORM_VMWARE, VSphereVirtualization.class);
        _implementations.put(VIRTUALIZATION_PLATFORM_POWER_VM, PowerVMVirtualization.class);
        _implementations.put(VIRTUALIZATION_PLATFORM_XEN, XenVirtualization.class);
        _implementations.put(VIRTUALIZATION_PLATFORM_KVM, KVMVirtualization.class);
        _implementations.put(VIRTUALIZATION_PLATFORM_SOLARIS_ZONES, SolarisZonesVirtualization.class);
        _implementations.put(VIRTUALIZATION_PLATFORM_HP, HPVMVirtualization.class);
        _implementations.put(VIRTUALIZATION_PLATFORM_LINUX_POWER_VM, PowerLinuxVirtualization.class);
        _implementations.put(VIRTUALIZATION_PLATFORM_LINUX_POWER_KVM, PowerKVMVirtualization.class);
        _implementations.put(VIRTUALIZATION_PLATFORM_LINUX_POWER_FULL_PARTITION, PowerFullPartitionVirtualization.class);
        _implementation = null;
        _interface = null;
    }
}

