/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.monitor;

import java.security.AccessController;
import java.security.BasicPermission;
import java.security.Permission;

public class MonitoringPermission
extends BasicPermission {
    private static final long serialVersionUID = 2030200712916057393L;
    public static final boolean IS_PERMISSION_CHECK_REQUIRED;
    public static final MonitoringPermission READ_PERMISSION;
    public static final MonitoringPermission WRITE_PERMISSION;
    public static final MonitoringPermission EXECUTE_PERMISSION;

    public static final void checkPermission(MonitoringPermission perm) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(perm);
        } else if (IS_PERMISSION_CHECK_REQUIRED) {
            AccessController.checkPermission(perm);
        }
    }

    public MonitoringPermission(String name) {
        super(name);
        if (name == null) {
            throw new NullPointerException("name can't be null");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name can't be empty");
        }
    }

    @Override
    public boolean implies(Permission permission) {
        return this.equals(permission);
    }

    static {
        boolean doChecks = true;
        if (System.getSecurityManager() == null) {
            try {
                String performChecksProp = AccessController.doPrivileged(() -> System.getProperty("com.sap.jvm.PerformPermissionChecks", "false"));
                if (performChecksProp != null) {
                    doChecks = Boolean.parseBoolean(performChecksProp);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        IS_PERMISSION_CHECK_REQUIRED = doChecks;
        READ_PERMISSION = new MonitoringPermission("read");
        WRITE_PERMISSION = new MonitoringPermission("write");
        EXECUTE_PERMISSION = new MonitoringPermission("execute");
    }
}

