/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.monitor;

import com.sap.jvm.APIFactory;
import com.sap.jvm.Capabilities;
import com.sap.jvm.tracing.Trace;
import java.io.UnsupportedEncodingException;
import java.net.URL;

public class TypeInfo {
    private static StackTraceElement[] firstStackTrace;

    public TypeInfo() {
        if (firstStackTrace == null) {
            firstStackTrace = new Throwable().getStackTrace();
            return;
        }
        String newline = System.getProperty("line.separator");
        StringBuilder message = new StringBuilder("Type info object already created by:");
        message.append(newline);
        for (StackTraceElement element : firstStackTrace) {
            message.append(element.toString());
            message.append(newline);
        }
        throw new IllegalStateException(message.toString());
    }

    public static final long getId(Class<?> clazz) {
        return APIFactory.getClassId(clazz);
    }

    public static final long getId(ClassLoader loader) {
        return APIFactory.getClassLoaderId(loader);
    }

    public final boolean setClassLoaderInfo(ClassLoader loader, String name, URL[] urls, ClassLoader[] otherParents) {
        if (!Capabilities.hasVmMonitoring()) {
            return true;
        }
        try {
            byte[] utf8Name = null;
            if (name != null && name.length() > 0) {
                utf8Name = name.getBytes("UTF-8");
            }
            Object utf8URLs = null;
            if (urls != null && urls.length > 0) {
                utf8URLs = new byte[urls.length][];
                for (int i = 0; i < urls.length; ++i) {
                    utf8URLs[i] = urls[i].toString().getBytes("UTF-8");
                }
            }
            return APIFactory.setClassLoaderInfo(loader, utf8Name, utf8URLs, otherParents, null);
        }
        catch (UnsupportedEncodingException e) {
            Trace.get(TypeInfo.class).error(e);
            return false;
        }
    }

    public final void setClassLoaderDisabled(ClassLoader loader) {
        if (!Capabilities.hasVmMonitoring()) {
            return;
        }
        APIFactory.setClassLoaderDisabled(loader);
    }
}

