/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.monitor.cluster;

public enum ClusterType {
    CLUSTER_TYPE_UNKNOWN("Unknown cluster type"),
    CLUSTER_TYPE_PROCESS("Process cluster type"),
    CLUSTER_TYPE_INSTANCE("Instance cluster type");

    private final String description;

    private ClusterType(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public static int getConfigurationIndex(ClusterType type) {
        if (type == null) {
            throw new IllegalArgumentException("The parameter \"type\" is null.");
        }
        switch (type) {
            case CLUSTER_TYPE_UNKNOWN: {
                return 0;
            }
            case CLUSTER_TYPE_PROCESS: {
                return 1;
            }
            case CLUSTER_TYPE_INSTANCE: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Invalid type" + (Object)((Object)type));
    }

    public static ClusterType getTypeForIndex(int index) {
        switch (index) {
            case 0: {
                return CLUSTER_TYPE_UNKNOWN;
            }
            case 1: {
                return CLUSTER_TYPE_PROCESS;
            }
            case 2: {
                return CLUSTER_TYPE_INSTANCE;
            }
        }
        return null;
    }
}

