/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.monitor.thread;

import com.sap.jvm.monitor.MonitoringPermission;
import java.lang.reflect.Field;

public final class ThreadLocalsRemover {
    private static ThreadLocalsRemover theInstance;
    private static boolean getInstanceCalled;
    private Field threadLocalsField;
    private Field inheritableThreadLocalsField;

    private ThreadLocalsRemover() throws UnsupportedOperationException, SecurityException {
        try {
            this.threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            this.inheritableThreadLocalsField = Thread.class.getDeclaredField("inheritableThreadLocals");
        }
        catch (NoSuchFieldException e) {
            throw new UnsupportedOperationException("This VM does not support access to thread locals", e);
        }
        this.threadLocalsField.setAccessible(true);
        this.inheritableThreadLocalsField.setAccessible(true);
    }

    @Deprecated
    public static synchronized ThreadLocalsRemover getInstanceOnce() throws UnsupportedOperationException, SecurityException {
        if (getInstanceCalled) {
            throw new SecurityException("Only the first caller of this method is allowed to get the instance");
        }
        getInstanceCalled = true;
        return ThreadLocalsRemover.getInstance();
    }

    public static synchronized ThreadLocalsRemover getInstance() throws UnsupportedOperationException, SecurityException {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        if (theInstance == null) {
            theInstance = new ThreadLocalsRemover();
        }
        return theInstance;
    }

    public void removeAllThreadLocals() {
        Thread thread = Thread.currentThread();
        try {
            this.threadLocalsField.set(thread, null);
            this.inheritableThreadLocalsField.set(thread, null);
        }
        catch (IllegalArgumentException e) {
            throw new InternalError("Unexpected IllegalArgumentException accessing thread locals");
        }
        catch (IllegalAccessException e) {
            throw new InternalError("Unexpected IllegalAccessException accessing thread locals");
        }
    }
}

