/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.monitor.vm;

public enum MonitorOperation {
    DUMP_HEAP("dumpheap", "dump_heap", 3),
    GET_STACK_TRACE("threaddump", "thread_dump", 3),
    GET_SYSTEM_PROPERTIES("properties", "get_system_properties", 1),
    HAS_OPERATION("hasoperation", "has_operation", 1),
    GET_CLASS_STATISTIC("classstatistic", "print_class_statistic", 2),
    GET_CODE_BLOBS("codeblobs", "print_codeblobs", 3),
    GET_HS_ERROR_INFO("errorinfo", "print_hs_error_info", 1),
    GET_DLL_INFO("dllinfo", "print_dll_info", 1),
    GET_SYMBOL_INFO("symbolinfo", "print_symbol_info", 2),
    GET_GC_HISTORY("gchistory", "print_gc_history", 1),
    GET_FLIGHT_RECORDER("flightrecorder", "print_flight_recorder", 2),
    RETRIEVE_COMPLETE_GC_HISTORY("gchistoryfile", "retrieve_gc_history", 0),
    DEOPTIMIZE_METHOD("deoptimize", "deoptimize_method", 1),
    DEOPTIMIZE_ALL("deoptimizeall", "deoptimize_all", 0),
    FORCE_OSR_COMPILE("forceosrcompile", "force_osr_compile", 2),
    FORCE_COMPILE("forcecompile", "force_compile", 2),
    GET_METASPACE_STAT("metaspacestat", "print_metaspace_statistics", 2),
    GET_METASPACE_MAP("metaspacemap", "print_metaspace_map", 2),
    GET_MALLOCSTAT("mallocstat", "print_malloc_statistics", 1),
    GET_MALLOCSTAT_INTERNALS("mallocstat_int", "print_malloc_statistics_internals", 1),
    GET_CCS_INTERNALS("ccs_internals", "print_ccs_internals", 1),
    MALLOCSTAT_STARTCAP("mallocstatstart", "mallocstat_startcap", 0),
    MALLOCSTAT_STOPCAP("mallocstatstop", "mallocstat_stopcap", 0),
    MALLOCSTAT_RESET("mallocstatreset", "mallocstat_reset", 0),
    GET_SIGNAL_HANDLERS("prtsighdl", "print_signal_handlers", 1),
    GET_SYSTEM_INFORMATION("systeminfo", "print_system_info", 2),
    GET_MEMHIST("memhist", "vitals", 1),
    GET_JIT_INFO("jitinfo", "jitinfo", 3),
    GET_CLASS_DATA_GRAPH_INFO("clsdatagraph", "print_class_data_graph", 2);

    private final String operationID;
    private final String operationFunc;
    private final int numArguments;

    private MonitorOperation(String operationID, String operationFunc, int numArguments) {
        this.operationID = operationID;
        this.operationFunc = operationFunc;
        this.numArguments = numArguments;
    }

    public final String getOperationID() {
        return this.operationID;
    }

    public final String getOperationFunction() {
        return this.operationFunc;
    }

    public int getNumArguments() {
        return this.numArguments;
    }

    public static MonitorOperation getByOperationID(String operationID) {
        for (MonitorOperation op : MonitorOperation.values()) {
            if (!op.getOperationID().equals(operationID)) continue;
            return op;
        }
        return null;
    }
}

