/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.monitor.vm;

public enum OutOfMemoryErrorReason {
    JAVA_HEAP_SPACE("Java heap space"),
    PERMANENT_GENERATION_SPACE("PermGen space"),
    GC_OVERHEAD_LIMIT("GC overhead limit exceeded"),
    METASPACE_SPACE("Metaspace");

    private String description;

    private OutOfMemoryErrorReason(String desc) {
        this.description = desc;
    }

    public String getDescription() {
        return this.description;
    }

    public static OutOfMemoryErrorReason get(int index) {
        switch (index) {
            case 0: {
                return JAVA_HEAP_SPACE;
            }
            case 1: {
                return PERMANENT_GENERATION_SPACE;
            }
            case 2: {
                return GC_OVERHEAD_LIMIT;
            }
            case 3: {
                return METASPACE_SPACE;
            }
        }
        throw new IllegalArgumentException("Unknown index: " + index);
    }
}

