/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.monitor.vm;

import java.io.Serializable;

public final class PortRange
implements Serializable {
    private static final long serialVersionUID = -171151370434793203L;
    public static final PortRange UNDEFINED_PORT_RANGE = new PortRange(-1, -1, true);
    private static final int MAX_PORT_NUMBER = 65534;
    private final int fromPort;
    private final int toPort;

    public PortRange(int port) {
        this(port, port, false);
    }

    public PortRange(int fromPort, int toPort) {
        this(fromPort, toPort, false);
    }

    public PortRange(String portRange) {
        int p2;
        int p1;
        if (portRange == null) {
            throw new IllegalArgumentException("Input argument to PortRange must not be null.");
        }
        try {
            int index = portRange.lastIndexOf("-");
            if (index > 0) {
                p1 = Integer.parseInt(portRange.substring(0, index).trim());
                p2 = Integer.parseInt(portRange.substring(index + 1, portRange.length()).trim());
            } else {
                p1 = Integer.parseInt(portRange.trim());
                p2 = 65534;
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Port range option \"" + portRange + "\" seems to be invalid.", e);
        }
        if (p1 < p2) {
            this.fromPort = p1;
            this.toPort = p2;
        } else {
            this.fromPort = p2;
            this.toPort = p1;
        }
        if (this.fromPort < 0) {
            throw new IllegalArgumentException("FromPort(" + this.fromPort + ") must not be lower than 0.");
        }
        if (this.toPort > 65534) {
            throw new IllegalArgumentException("ToPort(" + this.toPort + ") must not be greater than " + 65534 + ".");
        }
    }

    private PortRange(int fromPort, int toPort, boolean allowNegativeValues) {
        if (!allowNegativeValues && fromPort <= 0) {
            throw new IllegalArgumentException("The port range [" + fromPort + ":" + toPort + "] includes values <= 0.");
        }
        if (toPort < fromPort) {
            throw new IllegalArgumentException("The upper bound of the port range [" + fromPort + ":" + toPort + "] is lower than the lower bound.");
        }
        this.fromPort = fromPort;
        this.toPort = toPort;
    }

    public int getFromPort() {
        return this.fromPort;
    }

    public int getToPort() {
        return this.toPort;
    }
}

