/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.monitor.vm;

public enum SuspendPolicy {
    SUSPEND_NONE("Suspend no threads when starting debugging", 0),
    SUSPEND_ALL("Suspend all threads when starting debugging", 1);

    private final String description;
    private final int index;

    private SuspendPolicy(String description, int index) {
        this.description = description;
        this.index = index;
    }

    public String getDescription() {
        return this.description;
    }

    public int getIndex() {
        return this.index;
    }

    public static SuspendPolicy getByIndex(int index) {
        switch (index) {
            case 0: {
                return SUSPEND_NONE;
            }
            case 1: {
                return SUSPEND_ALL;
            }
        }
        throw new IllegalArgumentException("Invalid suspend policy index: " + index);
    }
}

