/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.monitor.vm;

import com.sap.jvm.APIFactory;
import com.sap.jvm.monitor.vm.ThreadAnnotationKey;
import java.util.ArrayList;

public class ThreadAnnotation {
    private ThreadAnnotation() {
    }

    public static String getAnnotation(ThreadAnnotationKey key) {
        if (key == null) {
            throw new IllegalArgumentException("The parameter \"key\" is null.");
        }
        return APIFactory.getThreadAnnotation(Thread.currentThread(), key.getSlot());
    }

    public static Annotation[] getAnnotations() {
        ArrayList<AnnotationImpl> annotationList = new ArrayList<AnnotationImpl>();
        int currentNrOfSlots = ThreadAnnotationKey.getCurrentNrOfSlots();
        Thread currentThread = Thread.currentThread();
        for (int i = 0; i <= currentNrOfSlots; ++i) {
            String value = APIFactory.getThreadAnnotation(currentThread, i);
            if (value == null) continue;
            annotationList.add(new AnnotationImpl(ThreadAnnotationKey.getKey(i), value));
        }
        Annotation[] retValue = new Annotation[annotationList.size()];
        return annotationList.toArray(retValue);
    }

    public static String getAnnotation(ThreadAnnotationKey key, Thread thread) {
        if (key == null) {
            throw new IllegalArgumentException("The parameter \"key\" is null.");
        }
        if (thread == null) {
            throw new IllegalArgumentException("The parameter \"thread\" is null.");
        }
        return APIFactory.getThreadAnnotation(thread, key.getSlot());
    }

    public static void setAnnotation(ThreadAnnotationKey key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("The parameter \"key\" is null.");
        }
        APIFactory.setThreadAnnotation(Thread.currentThread(), key.getSlot(), value);
    }

    public static void setAnnotations(Annotation[] bindings) {
        if (bindings == null) {
            throw new IllegalArgumentException("The parameter \"bindings\" is null.");
        }
        Annotation currentBinding = null;
        for (int i = 0; i < bindings.length; ++i) {
            currentBinding = bindings[i];
            if (currentBinding == null || currentBinding.getKey() == null) continue;
            APIFactory.setThreadAnnotation(Thread.currentThread(), bindings[i].getKey().getSlot(), bindings[i].getValue());
        }
    }

    public static void clearAnnotations() {
        APIFactory.clearThreadAnnotations(Thread.currentThread());
    }

    private static class AnnotationImpl
    implements Annotation {
        ThreadAnnotationKey key;
        String value;

        public AnnotationImpl(ThreadAnnotationKey key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public ThreadAnnotationKey getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static interface Annotation {
        public ThreadAnnotationKey getKey();

        public String getValue();
    }
}

