/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.monitor.vm;

import com.sap.jvm.APIFactory;

public class ThreadAnnotationKey {
    public static final String USER_KEY = "user";
    public static final String SESSION_KEY = "session";
    public static final String REQUEST_KEY = "request";
    public static final String APPLICATION_KEY = "application";
    public static final String IS_APPLICATION_THREAD_KEY = "isapplicationthread";
    public static final String TENANT_KEY = "tenant";
    public static final String USER_KEY_DESCRIPTION = "The login name of the user";
    public static final String SESSION_KEY_DESCRIPTION = "The identifier describing uniquely a session.";
    public static final String REQUEST_KEY_DESCRIPTION = "The identifier describing uniquely a request.";
    public static final String APPLICATION_KEY_DESCRIPTION = "The name of the application";
    public static final String IS_APPLICATION_THREAD_KEY_DESCRIPTION = "Flag indicating whether the thread is an application thread or a system thread";
    public static final String TENANT_KEY_DESCRIPTION = "The identifier describing uniquely a tenant.";
    public static final ThreadAnnotationKey USER;
    public static final ThreadAnnotationKey SESSION;
    public static final ThreadAnnotationKey REQUEST;
    public static final ThreadAnnotationKey APPLICATION;
    public static final ThreadAnnotationKey IS_APPLICATION_THREAD;
    public static final ThreadAnnotationKey TENANT;
    private static final int USER_SLOT = 0;
    private static final int SESSION_SLOT = 1;
    private static final int REQUEST_SLOT = 2;
    private static final int APPLICATION_SLOT = 3;
    private static final int IS_APPLICATION_SLOT = 4;
    private static final int TENANT_SLOT = 5;
    private static final int NUMBER_OF_PREDEFINED_KEYS = 6;
    private static final int MAX_SLOTS;
    private static int currentSlot;
    private static String[] keys;
    private static String[] descriptions;
    private String key;
    private String description;
    private int slot;

    private ThreadAnnotationKey(String key, String description, int slot) {
        this.key = key;
        this.description = description;
        this.slot = slot;
        ThreadAnnotationKey.keys[slot] = key;
        ThreadAnnotationKey.descriptions[slot] = description;
        APIFactory.setThreadAnnotationKey(slot, key, description);
    }

    static ThreadAnnotationKey getKey(int slot) {
        if (slot == 0) {
            return USER;
        }
        if (slot == 1) {
            return SESSION;
        }
        if (slot == 2) {
            return REQUEST;
        }
        if (slot == 3) {
            return APPLICATION;
        }
        if (slot == 4) {
            return IS_APPLICATION_THREAD;
        }
        if (slot == 5) {
            return TENANT;
        }
        return new ThreadAnnotationKey(keys[slot], descriptions[slot], slot);
    }

    public static ThreadAnnotationKey get(String key) {
        return ThreadAnnotationKey.get(key, null);
    }

    public static synchronized ThreadAnnotationKey get(String key, String description) {
        if (key == null) {
            throw new IllegalArgumentException("The parameter \"key\" is null.");
        }
        if (key.equals(USER_KEY)) {
            return USER;
        }
        if (key.equals(SESSION_KEY)) {
            return SESSION;
        }
        if (key.equals(REQUEST_KEY)) {
            return REQUEST;
        }
        if (key.equals(APPLICATION_KEY)) {
            return APPLICATION;
        }
        if (key.equals(IS_APPLICATION_THREAD_KEY)) {
            return IS_APPLICATION_THREAD;
        }
        if (key.equals(TENANT_KEY)) {
            return TENANT;
        }
        for (int i = 6; i <= currentSlot; ++i) {
            if (!keys[i].equals(key)) continue;
            return new ThreadAnnotationKey(key, descriptions[i], i);
        }
        int slot = ThreadAnnotationKey.getNextFreeSlot();
        if (slot == -1) {
            return null;
        }
        return new ThreadAnnotationKey(key, description, slot);
    }

    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    int getSlot() {
        return this.slot;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ThreadAnnotationKey) {
            ThreadAnnotationKey tmp = (ThreadAnnotationKey)obj;
            return tmp.getKey().equals(this.key);
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    static synchronized int getCurrentNrOfSlots() {
        return currentSlot;
    }

    private static synchronized int getNextFreeSlot() {
        if (currentSlot >= MAX_SLOTS - 1) {
            return -1;
        }
        return ++currentSlot;
    }

    static {
        currentSlot = 5;
        MAX_SLOTS = APIFactory.getMaxThreadAnnotations();
        keys = new String[MAX_SLOTS];
        descriptions = new String[MAX_SLOTS];
        USER = new ThreadAnnotationKey(USER_KEY, USER_KEY_DESCRIPTION, 0);
        REQUEST = new ThreadAnnotationKey(REQUEST_KEY, REQUEST_KEY_DESCRIPTION, 2);
        SESSION = new ThreadAnnotationKey(SESSION_KEY, SESSION_KEY_DESCRIPTION, 1);
        APPLICATION = new ThreadAnnotationKey(APPLICATION_KEY, APPLICATION_KEY_DESCRIPTION, 3);
        IS_APPLICATION_THREAD = new ThreadAnnotationKey(IS_APPLICATION_THREAD_KEY, IS_APPLICATION_THREAD_KEY_DESCRIPTION, 4);
        TENANT = new ThreadAnnotationKey(TENANT_KEY, TENANT_KEY_DESCRIPTION, 5);
    }
}

