/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.monitor.vm;

import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.monitor.vm.MonitorOperation;
import com.sap.jvm.monitor.vm.PortRange;
import com.sap.jvm.monitor.vm.SuspendPolicy;
import com.sap.jvm.monitor.vm.VmDebugInfo;
import com.sap.jvm.monitor.vm.VmMemoryInfo;
import com.sap.jvm.monitor.vm.VmProfilingInfo;
import com.sap.jvm.monitor.vm.VmSnapshot;
import com.sap.jvm.monitor.vm.VmStartInfo;
import com.sap.jvm.monitor.vm.VmStateInfo;
import com.sap.jvm.monitor.vm.VmTimeInfo;
import com.sap.jvm.monitor.vm.VmTraceFlagsSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public interface Vm {
    public int getVmIndex();

    public String encode();

    public boolean isValid();

    public VmSnapshot getVmSnapshot() throws InvalidVmException;

    public VmMemoryInfo getMemoryInfo() throws InvalidVmException;

    public VmTimeInfo getTimeInfo() throws InvalidVmException;

    public VmStateInfo getStateInfo() throws InvalidVmException;

    public VmStartInfo getStartInfo() throws InvalidVmException;

    public VmDebugInfo getDebugInfo() throws InvalidVmException;

    public VmProfilingInfo getProfilingInfo() throws InvalidVmException;

    public VmTraceFlagsSet getTraceFlags() throws InvalidVmException;

    public void setTraceFlags(VmTraceFlagsSet var1) throws InvalidVmException;

    public void setDefaultDebugPortRange(PortRange var1) throws InvalidVmException;

    public void setDefaultProfilingPortRange(PortRange var1) throws InvalidVmException;

    public void exit(int var1) throws InvalidVmException;

    public void printStackDump() throws IOException;

    public void printStackDump(String var1) throws IOException;

    public ArrayList<String> getStackDump() throws IOException;

    public void dumpHeap() throws IOException;

    public void dumpHeap(String var1) throws IOException;

    public void forceGc() throws InvalidVmException;

    public void forceMaxGc() throws InvalidVmException;

    public void dumpGcHistory() throws IOException;

    public List<String> getGcHistory() throws IOException;

    public byte[] retrieveCompleteGcHistory() throws InvalidVmException;

    public void dumpClassStatistic() throws IOException;

    public void dumpDetailedClassStatistic() throws IOException;

    public List<String> getClassStatistic() throws IOException;

    public List<String> getDetailedClassStatistic() throws IOException;

    public void dumpDllInformation() throws IOException;

    public List<String> getDllInformation() throws IOException;

    public void dumpCodeblobs(String var1, boolean var2) throws IOException;

    public List<String> getCodeblobs(String var1, boolean var2) throws IOException;

    public void dumpHsErrorInfo() throws IOException;

    public List<String> getHsErrorInfo() throws IOException;

    public void dumpSymbolInfo() throws IOException;

    public List<String> getSymbolInfo() throws IOException;

    public List<String> getSymbolInfo(int var1) throws IOException;

    public void dumpSafepointState() throws InvalidVmException;

    public List<String> getFlightrecorder(int var1) throws IOException;

    public void startDebug(SuspendPolicy var1) throws InvalidVmException;

    public void startLocalDebug(SuspendPolicy var1) throws InvalidVmException;

    public void stopDebug() throws InvalidVmException;

    public void startProfiling() throws InvalidVmException;

    public void stopProfiling() throws InvalidVmException;

    public boolean supportsOperation(MonitorOperation var1) throws InvalidVmException;

    public List<String> performOperation(MonitorOperation var1, String ... var2) throws IOException;

    public boolean attachServerIsStarted() throws InvalidVmException;

    public void startAttachServer() throws InvalidVmException;
}

