/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.monitor.vm;

import com.sap.jvm.APIFactory;
import com.sap.jvm.monitor.vm.PortRange;
import com.sap.jvm.monitor.vm.SuspendPolicy;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.ClassFilter;
import com.sap.jvm.util.ClassFilterParseException;
import java.util.List;

public class VmDebug {
    private static final VmDebugInterface debugImpl = APIFactory.getVmDebugImpl();

    public static void setDefaultDebugPortRange(PortRange range) {
        debugImpl.setDefaultDebugPortRange(range);
    }

    public static boolean attachDebugger(SuspendPolicy suspendPolicy) {
        return debugImpl.attachDebugger(suspendPolicy);
    }

    public static boolean attachDebugger(int port, SuspendPolicy suspendPolicy) {
        return debugImpl.attachDebugger(port, suspendPolicy);
    }

    public static boolean attachDebugger(PortRange range, SuspendPolicy suspendPolicy) {
        return debugImpl.attachDebugger(range, suspendPolicy);
    }

    public static boolean attachRestrictedDebugger() {
        return debugImpl.attachRestrictedDebugger(SuspendPolicy.SUSPEND_NONE, null);
    }

    public static boolean attachRestrictedDebugger(SuspendPolicy suspendPolicy, List<String> packageList) {
        return debugImpl.attachRestrictedDebugger(suspendPolicy, VmDebug.convertListToClassFilter(packageList));
    }

    public static boolean attachRestrictedDebugger(int port, SuspendPolicy suspendPolicy, List<String> packageList) {
        return debugImpl.attachRestrictedDebugger(port, suspendPolicy, VmDebug.convertListToClassFilter(packageList));
    }

    public static boolean attachRestrictedDebugger(PortRange range, SuspendPolicy suspendPolicy, List<String> packageList) {
        return debugImpl.attachRestrictedDebugger(range, suspendPolicy, VmDebug.convertListToClassFilter(packageList));
    }

    public static boolean attachRestrictedDebugger(SuspendPolicy suspendPolicy, ClassFilter classFilter) {
        return debugImpl.attachRestrictedDebugger(suspendPolicy, classFilter);
    }

    public static boolean attachRestrictedDebugger(int port, SuspendPolicy suspendPolicy, ClassFilter classFilter) {
        return debugImpl.attachRestrictedDebugger(port, suspendPolicy, classFilter);
    }

    public static boolean attachRestrictedDebugger(PortRange range, SuspendPolicy suspendPolicy, ClassFilter classFilter) {
        return debugImpl.attachRestrictedDebugger(range, suspendPolicy, classFilter);
    }

    public static boolean attachLocalDebugger(SuspendPolicy suspendPolicy) {
        return debugImpl.attachLocalDebugger(suspendPolicy);
    }

    public static boolean attachLocalDebugger(int port, SuspendPolicy suspendPolicy) {
        return debugImpl.attachLocalDebugger(port, suspendPolicy);
    }

    public static boolean attachLocalDebugger(PortRange range, SuspendPolicy suspendPolicy) {
        return debugImpl.attachLocalDebugger(range, suspendPolicy);
    }

    public static boolean detachDebugger() {
        return debugImpl.detachDebugger();
    }

    public static boolean addRestrictedDebugThread() {
        return debugImpl.addRestrictedDebugThread();
    }

    public static boolean removeRestrictedDebugThread() {
        return debugImpl.removeRestrictedDebugThread();
    }

    public static boolean isThreadRestricted() {
        return debugImpl.isThreadRestricted();
    }

    public static boolean isThreadRestricted(long threadId) {
        return debugImpl.isThreadRestricted(threadId);
    }

    public static boolean isThreadRestricted(Thread thread) {
        return debugImpl.isThreadRestricted(thread);
    }

    private static ClassFilter convertListToClassFilter(List<String> packageList) {
        if (packageList == null || packageList.size() == 0) {
            return null;
        }
        StringBuffer classFilter = new StringBuffer(1024);
        String sep = "";
        for (String packageName : packageList) {
            classFilter.append(sep);
            sep = "&";
            classFilter.append("(!" + packageName + ")");
        }
        try {
            return new ClassFilter(classFilter.toString());
        }
        catch (ClassFilterParseException e) {
            Trace.get(VmDebug.class).error((Throwable)e, "Cannot convert package list to class filter");
            return null;
        }
    }

    public static interface VmDebugInterface {
        public void setDefaultDebugPortRange(PortRange var1);

        public boolean attachDebugger(SuspendPolicy var1);

        public boolean attachDebugger(int var1, SuspendPolicy var2);

        public boolean attachDebugger(PortRange var1, SuspendPolicy var2);

        public boolean attachRestrictedDebugger(SuspendPolicy var1, ClassFilter var2);

        public boolean attachRestrictedDebugger(int var1, SuspendPolicy var2, ClassFilter var3);

        public boolean attachRestrictedDebugger(PortRange var1, SuspendPolicy var2, ClassFilter var3);

        public boolean attachLocalDebugger(SuspendPolicy var1);

        public boolean attachLocalDebugger(int var1, SuspendPolicy var2);

        public boolean attachLocalDebugger(PortRange var1, SuspendPolicy var2);

        public boolean detachDebugger();

        public boolean addRestrictedDebugThread();

        public boolean removeRestrictedDebugThread();

        public boolean isThreadRestricted();

        public boolean isThreadRestricted(long var1);

        public boolean isThreadRestricted(Thread var1);
    }
}

