/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.monitor.vm;

import com.sap.jvm.APIFactory;
import com.sap.jvm.monitor.thread.Deadlock;
import com.sap.jvm.monitor.vm.ExtendedVmSnapshot;
import com.sap.jvm.monitor.vm.GcProblemReportingMBean;
import com.sap.jvm.monitor.vm.MonitorInfo;
import com.sap.jvm.monitor.vm.SystemProblemReportingMBean;
import com.sap.jvm.monitor.vm.ThreadAnnotation;
import com.sap.jvm.monitor.vm.ThreadAnnotationKey;
import com.sap.jvm.monitor.vm.ThreadAppInfo;
import com.sap.jvm.monitor.vm.ThreadIoInfo;
import com.sap.jvm.monitor.vm.ThreadMemoryInfo;
import com.sap.jvm.monitor.vm.ThreadSnapshot;
import com.sap.jvm.monitor.vm.ThreadStateInfo;
import com.sap.jvm.monitor.vm.ThreadTimeInfo;
import com.sap.jvm.monitor.vm.VmDebugInfo;
import com.sap.jvm.monitor.vm.VmFactory;
import com.sap.jvm.monitor.vm.VmMemoryInfo;
import com.sap.jvm.monitor.vm.VmProfilingInfo;
import com.sap.jvm.monitor.vm.VmStartInfo;
import com.sap.jvm.monitor.vm.VmStateInfo;
import com.sap.jvm.monitor.vm.VmTimeInfo;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class VmInfo {
    private static VmFactory.VmFactoryInterface theVmFactory = APIFactory.getVmFactory();

    public static String encode() {
        return theVmFactory.encodeVmHandle();
    }

    public static ExtendedVmSnapshot getVmSnapshot() {
        return theVmFactory.getVmSnapshot();
    }

    public static VmMemoryInfo getMemoryInfo() {
        return theVmFactory.getVmMemoryInfo();
    }

    public static VmTimeInfo getTimeInfo() {
        return theVmFactory.getVmTimeInfo();
    }

    public static VmStateInfo getStateInfo() {
        return theVmFactory.getVmStateInfo();
    }

    public static VmStartInfo getStartInfo() {
        return theVmFactory.getVmStartInfo();
    }

    public static VmDebugInfo getDebugInfo() {
        return theVmFactory.getVmDebugInfo();
    }

    public static VmProfilingInfo getProfilingInfo() {
        return theVmFactory.getVmProfilingInfo();
    }

    public static long[] getAllThreadIds() {
        return theVmFactory.getAllThreadIds();
    }

    public static Thread getThread(long threadId) {
        return theVmFactory.getThread(threadId);
    }

    public static ThreadSnapshot[] getAllThreadSnapshot() {
        return theVmFactory.getAllThreadSnapshots();
    }

    public static ThreadSnapshot getThreadSnapshot(Thread thread) {
        return theVmFactory.getThreadSnapshot(thread);
    }

    public static ThreadSnapshot getThreadSnapshot(long threadId) {
        return theVmFactory.getThreadSnapshot(threadId);
    }

    public static ThreadTimeInfo getThreadTimeInfo(Thread thread) {
        return theVmFactory.getThreadTimeInfo(thread);
    }

    public static ThreadTimeInfo getThreadTimeInfo(long threadId) {
        return theVmFactory.getThreadTimeInfo(threadId);
    }

    public static ThreadMemoryInfo getThreadMemoryInfo(Thread thread) {
        return theVmFactory.getThreadMemoryInfo(thread);
    }

    public static ThreadMemoryInfo getThreadMemoryInfo(long threadId) {
        return theVmFactory.getThreadMemoryInfo(threadId);
    }

    public static ThreadStateInfo getThreadStateInfo(Thread thread) {
        return theVmFactory.getThreadStateInfo(thread);
    }

    public static ThreadStateInfo getThreadStateInfo(long threadId) {
        return theVmFactory.getThreadStateInfo(threadId);
    }

    public static ThreadAppInfo getThreadAppInfo(Thread thread) {
        return theVmFactory.getThreadAppInfo(thread);
    }

    public static ThreadAppInfo getThreadAppInfo(long threadId) {
        return theVmFactory.getThreadAppInfo(threadId);
    }

    public static ThreadIoInfo getThreadIoInfo(Thread thread) {
        return theVmFactory.getThreadIoInfo(thread);
    }

    public static ThreadIoInfo getThreadIoInfo(long threadId) {
        return theVmFactory.getThreadIoInfo(threadId);
    }

    public static long[] getCurrentThreadNetworkTraffic() {
        return theVmFactory.getCurrentThreadNetworkTraffic();
    }

    public static void resetThreadStackDumpCounters() {
        theVmFactory.resetThreadStackDumpCounters();
    }

    public static short getThreadTag() {
        return theVmFactory.getThreadTag();
    }

    public static short getThreadTag(Thread thread) {
        return theVmFactory.getThreadTag(thread);
    }

    public static short getThreadTag(long threadId) {
        return theVmFactory.getThreadTag(threadId);
    }

    public static void setThreadTag(short tag) {
        theVmFactory.setThreadTag(tag);
    }

    public static void setThreadTag(Thread thread, short tag) {
        theVmFactory.setThreadTag(thread, tag);
    }

    public static void setThreadTag(long threadId, short tag) {
        theVmFactory.setThreadTag(threadId, tag);
    }

    public static Deadlock[] findDeadlocks() {
        return theVmFactory.findDeadlocks();
    }

    public static MonitorInfo[] getMonitorInfo() {
        return theVmFactory.getMonitorInfo();
    }

    @Deprecated
    public static String getUser() {
        return ThreadAnnotation.getAnnotation(ThreadAnnotationKey.USER);
    }

    @Deprecated
    public static String getUser(Thread thread) {
        if (thread == null) {
            throw new NullPointerException("Thread parameter is null.");
        }
        return ThreadAnnotation.getAnnotation(ThreadAnnotationKey.USER, thread);
    }

    @Deprecated
    public static String getUser(long threadId) {
        Thread thread = VmInfo.getThread(threadId);
        return thread == null ? null : VmInfo.getUser(thread);
    }

    @Deprecated
    public static void setUser(String user) {
        ThreadAnnotation.setAnnotation(ThreadAnnotationKey.USER, user);
    }

    @Deprecated
    public static void setSessionId(String sessionId) {
        ThreadAnnotation.setAnnotation(ThreadAnnotationKey.SESSION, sessionId);
    }

    @Deprecated
    public static void setRequestId(String requestId) {
        ThreadAnnotation.setAnnotation(ThreadAnnotationKey.REQUEST, requestId);
    }

    @Deprecated
    public static void setApplicationName(String appName) {
        ThreadAnnotation.setAnnotation(ThreadAnnotationKey.APPLICATION, appName);
    }

    @Deprecated
    public static void setComponentName(String compName) {
    }

    @Deprecated
    public static GcProblemReportingMBean getGcProblemReportingMBean() {
        try {
            return MBeanServerInvocationHandler.newProxyInstance(ManagementFactory.getPlatformMBeanServer(), new ObjectName("sap.management:type=GcProblemReporting"), GcProblemReportingMBean.class, false);
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    @Deprecated
    public static SystemProblemReportingMBean getSystemProblemReportingMBean() {
        try {
            return MBeanServerInvocationHandler.newProxyInstance(ManagementFactory.getPlatformMBeanServer(), new ObjectName("sap.management:type=SystemProblemReporting"), SystemProblemReportingMBean.class, false);
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }
}

