/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.monitor.vm;

import com.sap.jvm.APIFactory;
import com.sap.jvm.monitor.vm.VmTraceFlag;
import com.sap.jvm.monitor.vm.VmTraceFlagsSet;
import com.sap.jvm.monitor.vm.VmTraceMessageClass;
import java.io.IOException;

public class VmTrace {
    private static VmTraceInterface theVmTrace = APIFactory.getVmTraceImpl();
    public static final String DEFAULT_HEAP_DUMP_FILENAME = "java_pid@PID_@count.hprof";

    public static VmTraceFlagsSet getTraceFlags() {
        return theVmTrace.getTraceFlags();
    }

    public static boolean getTraceFlag(VmTraceFlag flag) {
        return theVmTrace.getTraceFlag(flag);
    }

    public static void setTraceFlags(VmTraceFlagsSet flags) {
        theVmTrace.setTraceFlags(flags);
    }

    public static void setTraceFlag(VmTraceFlag flag) {
        theVmTrace.setTraceFlag(flag);
    }

    public static void clearTraceFlag(VmTraceFlag flag) {
        theVmTrace.clearTraceFlag(flag);
    }

    public static void setTraceFile(String filename) throws IOException {
        theVmTrace.setTraceFile(filename);
    }

    public static void setTraceFile(String filename, int fileCount, int fileMaxSize) throws IOException {
        theVmTrace.setTraceFile(filename, fileCount, fileMaxSize);
    }

    public static void printStackDump() {
        VmTrace.printStackDump(null);
    }

    public static void printStackDump(String info) {
        theVmTrace.printStackDump(info);
    }

    public static void printStackTrace(Thread t) {
        VmTrace.printStackTrace(t, null);
    }

    public static void printStackTrace(Thread t, String info) {
        theVmTrace.printStackTrace(t, info);
    }

    public static void printStackTrace(long threadId) {
        VmTrace.printStackTrace(threadId, null);
    }

    public static void printStackTrace(long threadId, String info) {
        theVmTrace.printStackTrace(threadId, info);
    }

    public static String getStackTrace(Thread thread) {
        return theVmTrace.getStackTrace(thread);
    }

    public static String getStackTrace(long threadId) {
        return theVmTrace.getStackTrace(threadId);
    }

    public static void printStackDumpAndHeapDump() {
        VmTrace.printStackDumpAndHeapDump(null, null);
    }

    public static void printStackDumpAndHeapDump(String stackInfo, String heapInfo) {
        theVmTrace.printStackDumpAndHeapDump(stackInfo, heapInfo);
    }

    public static void dumpHeap(String filename, boolean doFullGc) {
        VmTrace.dumpHeap(filename, doFullGc, null);
    }

    public static void dumpHeap(String filename, boolean doFullGc, String info) {
        theVmTrace.dumpHeap(filename, doFullGc, info);
    }

    public static void dumpHeapIncludingAllocationStatistic(String filename, boolean doFullGc, String info) {
        theVmTrace.dumpHeapIncludingAllocationStatistic(filename, doFullGc, info);
    }

    public static String getHeapDumpInformation(String filename) {
        return theVmTrace.getHeapDumpInformation(filename);
    }

    public static void forceGc() {
        theVmTrace.forceGc();
    }

    public static void forceMaxGc() {
        theVmTrace.forceMaxGc();
    }

    public static void dumpGcHistory() {
        theVmTrace.dumpGcHistory();
    }

    public static void dumpClassStatistic() {
        theVmTrace.dumpClassStatistic();
    }

    public static void dumpDetailedClassStatistic() {
        theVmTrace.dumpDetailedClassStatistic();
    }

    public static void dumpDllInformation() {
        theVmTrace.dumpDllInformation();
    }

    public static void trace(VmTraceMessageClass cls, VmTraceFlag flag, String text) {
        theVmTrace.trace(cls, flag, text);
    }

    public static interface VmTraceInterface {
        public VmTraceFlagsSet getTraceFlags();

        public boolean getTraceFlag(VmTraceFlag var1);

        public void setTraceFlags(VmTraceFlagsSet var1);

        public void setTraceFlag(VmTraceFlag var1);

        public void clearTraceFlag(VmTraceFlag var1);

        public void setTraceFile(String var1) throws IOException;

        public void setTraceFile(String var1, int var2, int var3) throws IOException;

        public void printStackDump(String var1);

        public void printStackTrace(Thread var1, String var2);

        public void printStackTrace(long var1, String var3);

        public String getStackTrace(Thread var1);

        public String getStackTrace(long var1);

        public void printStackDumpAndHeapDump(String var1, String var2);

        public void dumpHeap(String var1, boolean var2, String var3);

        public void dumpHeapIncludingAllocationStatistic(String var1, boolean var2, String var3);

        public String getHeapDumpInformation(String var1);

        public void forceGc();

        public void forceMaxGc();

        public void dumpGcHistory();

        public void dumpClassStatistic();

        public void dumpDetailedClassStatistic();

        public void dumpDllInformation();

        public void trace(VmTraceMessageClass var1, VmTraceFlag var2, String var3);
    }
}

