/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.monitor.vm;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public enum VmTraceFlag {
    TRACE_METHODS(1, "Methods", "Traces every method call."),
    TRACE_EXCEPTIONS(14, "Exceptions", "Traces java exception handling."),
    TRACE_CLASSLOADING(18, "ClassLoading", "Traces class loading."),
    TRACE_CLASSLOADING_STACKS(19, "ClassLoadingStacks", "Traces class loading with stacks (needs cass loading trace)."),
    TRACE_CLASSUNLOADING(23, "ClassUnloading", "Traces class unloading."),
    TRACE_CONTROLS(32, "Controls", "Traces basic operations done by the VM controls."),
    TRACE_CONTROLS_INTERNALS(33, "ControlsInternals", "Traces internals of the VM controls."),
    TRACE_DEBUG_ON_DEMAND(34, "DebugOnDemand", "Traces the debug on demand functionality."),
    TRACE_DEBUG_MODIFICATIONS(35, "DebugModifications", "Traces modifications done to programs and program flow during debugging."),
    TRACE_FILE_IO(39, "FileIoBasic", "Traces basic file IO (open/close)."),
    TRACE_FILE_IO_READ_WRITE(40, "FileIoReadWrite", "Traces file IO read and write."),
    TRACE_FILE_IO_READ_WRITE_DATA(41, "FileIoReadWriteData", "Trace file IO read and write and dumps the data read and written."),
    TRACE_NET(43, "NetworkIoBasic", "Traces basic network operations (bind, accept, listen, ...)."),
    TRACE_NET_SEND_RECV(44, "NetworkIoSendReceive", "Traces send and receive network operations."),
    TRACE_NET_SEND_RECV_DATA(45, "NetworkIoSendReceiveData", "Traces send and receive network operations and dumping the data send or received."),
    TRACE_NET_HOST_NAME_LOOKUP(46, "NetworkIoHostNameLookup", "Traces host name lookup operations."),
    TRACE_NET_REVERSE_HOST_NAME_LOOKUP(47, "NetworkIoReverseHostNameLookup", "Traces reverse host name lookup operations."),
    TRACE_NET_REVERSE_HOST_NAME_LOOKUP_TIME(48, "NetworkIoReverseHostNameLookupTime", "Traces the duration of reverse host name lookup operations."),
    TRACE_JDWP(49, "Jdwp", "Traces JDWP packets exchanged between the JDPA library and the debugger."),
    TRACE_JDWP_INTERNALS(50, "JdwpInternals", "Traces JDWP internals."),
    TRACE_CLASS_STATISTICS(56, "ClassStatistic", "Traces class statistics after full GCs."),
    TRACE_CMS_PLAB_REFILL_SAMPLING(58, "CMSPLABRefillSampling", "Traces the sampled time spent while refilling the PLABs during each young generation GC."),
    TRACE_CMS_FREE_LIST_SPACE_CENSUS(59, "CMSFreeListSpaceCensus", "Traces the CMS free list space census at each young generation garbage collection."),
    TRACE_CONC_MARK_SWEEP_GC(60, "ConcMarkSweepGC", "Traces the concurrent mark sweep garbage collector"),
    TRACE_CONC_MARK_SWEEP_GC_INTERNALS(61, "ConcMarkSweepGCInternals", "Traces internals of the concurrent mark sweep garbage collector"),
    TRACE_GARBAGE_FIRST_GC(62, "GarbageFirstGC", "Traces the garbage first garbage collector"),
    TRACE_GARBAGE_FIRST_GC_INTERNALS(63, "GarbageFirstGCInternals", "Traces internals of the garbage first garbage collector"),
    TRACE_PROFILING(64, "Profiling", "Traces profiling."),
    TRACE_PROFILING_INTERNALS(65, "ProfilingInternals", "Traces profiling internals."),
    TRACE_MPT_BASICS(70, "ProfilingMPTBasics", "Traces basics of the method parameter trace"),
    TRACE_MPT_VALUES(71, "ProfilingMPTValues", "Traces the values wirtten by the method parameter trace"),
    TRACE_MPT_INTERNALS(72, "ProfilingMPTInternals", "Traces the internals of the method parameter trace"),
    TRACE_MPT_MODIFIERS(73, "ProfilingMPTModifiers", "Traces the modifiers of the method parameter trace"),
    TRACE_SYNC_BASICS(74, "ProfilingSyncBasics", "Traces basics of the synchronization trace"),
    TRACE_IO_BASICS(75, "ProfilingIOBasics", "Traces basics of the profiling I/O trace"),
    TRACE_NETIO_BASICS(76, "ProfilingNetBasics", "Traces basics of the profiling network trace"),
    TRACE_CHUNKED_PROFILING_FILE(80, "ChunkedProfilingFile", "Traces operations of chunked profiling files"),
    TRACE_VMC_ALLOCATION_LOCAL_MISC(129, "AllocLocalMisc", "Traces allocations referrering to local misc."),
    TRACE_VMC_ALLOCATION_SHARED_DATA(132, "AllocSharedData", "Traces allocations referring to shared data."),
    TRACE_VMC_ALLOCATION_SHARED_MISC(134, "AllocSharedMisc", "Traces allocations referring to shared misc data."),
    TRACE_VMC_ALLOCATION_SHARED_BOOTSTRAP(135, "AllocSharedBootstrap", "Traces bootstrap allocations."),
    TRACE_VMC_ALLOCATION_ANY(150, "AllocAny", "Traces any allocation."),
    TRACE_GC_ONE_LINE_EXPERIMENTAL(151, "GCOneLineExperimental", "internal GC trace, do not use"),
    TRACE_GC_STATISTICS_LEVEL_1(152, "GCStatisticLevel1", "Traces GCs (basics)"),
    TRACE_GC_STATISTICS_LEVEL_2(153, "GCStatisticLevel2", "Traces GCS (detailed)"),
    TRACE_GC_STATISTICS_LEVEL_3(154, "GCStatisticLevel3", "Traces Gcs (detailed + basic event information)"),
    TRACE_GC_STATISTICS_LEVEL_4(155, "GCStatisticLevel4", "Traces GCs (detailed + detailed event information)"),
    TRACE_GC_STATISTICS_LEVEL_5(156, "GCStatisticLevel5", "Traces GCs (detailed + basic reference handling information)"),
    TRACE_EXCEPTIONS_WITH_BYTE_CODE(157, "ExceptionsWithByteCode", "Traces exceptions with byte code excerpt for top frames"),
    TRACE_METHODS_WITH_PARAMETERS(158, "MethodsWithParameters", "Traces method calls and prints their parameters"),
    TRACE_EXTENDED_STACK_TRACE(159, "ExtStackTrace", "Traces handling of extendes stack traces"),
    TRACE_DETAILED_CLASS_STATISTICS(160, "DetailedClassStatistic", "Traces detailed class statistics after full GCs."),
    TRACE_GC_STATISTICS_LEVEL_6(161, "GCStatisticLevel6", "Traces GCs (detailed + detailed reference handling information)"),
    TRACE_HEAP_MANAGER(162, "HeapManager", "Traces information about the heap manager"),
    TRACE_HEAP_MANAGER_INTERNALS(163, "HeapManagerInternals", "Traces internals about the heap manager"),
    TRACE_OS_MISC(164, "OsMisc", "Traces miscellaneous OS internals"),
    TRACE_OS_MMAP(165, "OsMmap", "Obsolete: Traces miscellaneous OS internals (mmap/mprotects etc)"),
    TRACE_OS_SIGNALS(166, "OsSignals", "Traces miscellaneous OS internals (signal handling)"),
    TRACE_PROFILING_STACK_TRACE(167, "ProfilingStackTrace", "Traces stack trace handling in profiling"),
    TRACE_PROFILING_STACK_TRACE_INTERNALS(168, "ProfilingStackTraceInternals", "Traces internals of stack trace handling in profiling"),
    TRACE_BYTE_CODE_UTILS(169, "ByteCodeUtils", "Traces byte code utils (e.g. used for extended exception messages)"),
    TRACE_BYTE_CODE_UTILS_INTERNALS(170, "ByteCodeUtilsInternals", "Traces byte code utils (e.g. used for extended exception messages)"),
    TRACE_PROFILING_TIME_BASED_SAMPLING(171, "ProfilingTimeBasedSampling", "Traces time based sampling in profiling"),
    TRACE_PROFILING_TIME_BASED_SAMPLING_INTERNALS(172, "ProfilingTimeBasedSamplingInternals", "Traces internals of time based sampling in profiling"),
    TRACE_VM_INIT(174, "VmInit", "Traces internals of VM initialization"),
    TRACE_SHARED_SYNCHRONIZATION(175, "SharedSynchronization", "Traces shared synchronization operations"),
    TRACE_OS_DLL_LOAD(176, "OsDllLoad", "Traces resolution/loads of shared objects"),
    TRACE_JAVA_ZIP_OPEN_CLOSE(177, "JavaZipOpenClose", "Traces open/close operations of zip files from Java (warning: incomplete since sapjvm 9)"),
    TRACE_JAVA_ZIP_GET_ENTRY(178, "JavaZipGetEntry", "Traces getEntry operations of zip files from Java (warning: incomplete since sapjvm 9)"),
    TRACE_JVMTI(179, "JVMTI", "Traces JVMTI operations"),
    TRACE_JDK_INTERNALS(180, "JdkInternals", "Traces JDK internals"),
    TRACE_MONITORING_INTERNAL(182, "MonitoringInternals", "Traces internals about the SAPJVM monitoring"),
    TRACE_HEARTBEAT(183, "HeartBeat", "Traces heart beat events"),
    TRACE_RAINY_DAY_FUND(184, "RainyDayFund", "Traces the memory rainy day fund"),
    TRACE_JVMTI_STACK_TRACE_RETRIEVAL(185, "JVMTIStackTraceRetrieval", "Traces the rfetrieval of stack traces by JVMTI"),
    TRACE_SPAWN(187, "Spawn", "Traces spawning of child processes"),
    TRACE_SPAWN_INTERNALS(188, "SpawnInternals", "Traces internals about spawning of child processes"),
    TRACE_SPAWN_ARGV(189, "SpawnArguments", "Traces arguments for spawned child processes"),
    TRACE_SPAWN_ENV(190, "SpawnEnvironment", "Traces environment vector for spawned child processes"),
    TRACE_JAVA_HEAP_ALLOCATION(191, "JavaHeapAllocation", "Traces details about java heap allocation"),
    TRACE_JAVA_HEAP_ALLOCATION_INTERNALS(192, "JavaHeapAllocationInternals", "Traces more details about java heap allocation"),
    TRACE_CLASS_FILTER_INTERNALS(193, "ClassFilterInternals", "Traces the internals of the class filters"),
    TRACE_GC_OVERHEAD_LIMITS(194, "GCOverheadLimits", "Traces the decisions concerning the GC overhead limits"),
    TRACE_JDWP_STACK_TRACKER(195, "JdwpStackTracker", "Traces the stack tracker extensions of JDWP"),
    TRACE_PAR_NEW_GC_INTERNALS(196, "ParNewGcInternals", "Traces internals of the par new garbage collector"),
    TRACE_PROFILING_MAPPING(197, "ProfilingMapping", "Traces the mapping handling in the profiling infrastructure"),
    TRACE_GC_PROMOTION_FAILURE_INTERNALS(198, "GcPromotionFailureInternals", "Traces internals of promotion failure events during garbage collection"),
    TRACE_VIRTUAL_MEMORY(199, "VirtualMemory", "Traces virtual memory allocations (mmap, shm, etc)"),
    TRACE_CONTROL_AREA(200, "ControlArea", "Traces control area internals"),
    TRACE_COMPILER(201, "Compiler", "Traces JIT internals"),
    TRACE_LEGACY(202, "Legacy", "Traces legacy stuff like SBL, shared session store etc."),
    TRACE_VM_MISC(203, "VmMisc", "Traces misc. VM information"),
    TRACE_MCT_INTERNALS(204, "ProfilingMethodCoverageDetails", "Traces details of the method coverage trace");

    private final int number;
    private final String name;
    private final String description;
    private static Set<VmTraceFlag> flagsSorted;
    private static Map<Integer, VmTraceFlag> flagsByNumber;
    private static Map<String, VmTraceFlag> flagsByName;

    private VmTraceFlag(int number, String name, String description) {
        this.number = number;
        this.name = name;
        this.description = description;
    }

    @Deprecated
    public final int getFlagnumber() {
        return this.number;
    }

    public final int getNumber() {
        return this.number;
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Set<VmTraceFlag> getFlags() {
        if (flagsSorted != null) return flagsSorted;
        Class<VmTraceFlag> clazz = VmTraceFlag.class;
        synchronized (VmTraceFlag.class) {
            if (flagsSorted != null) return flagsSorted;
            TreeSet<VmTraceFlag> tmp = new TreeSet<VmTraceFlag>((flag1, flag2) -> flag1.name.compareTo(flag2.name));
            for (VmTraceFlag flag : VmTraceFlag.values()) {
                tmp.add(flag);
            }
            flagsSorted = tmp;
            // ** MonitorExit[var0] (shouldn't be in output)
            return flagsSorted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<Integer, VmTraceFlag> flagsByNumber() {
        if (flagsByNumber != null) return flagsByNumber;
        Class<VmTraceFlag> clazz = VmTraceFlag.class;
        synchronized (VmTraceFlag.class) {
            if (flagsByNumber != null) return flagsByNumber;
            HashMap<Integer, VmTraceFlag> tmp = new HashMap<Integer, VmTraceFlag>();
            for (VmTraceFlag flag : VmTraceFlag.values()) {
                tmp.put(flag.getNumber(), flag);
            }
            flagsByNumber = tmp;
            // ** MonitorExit[var0] (shouldn't be in output)
            return flagsByNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, VmTraceFlag> flagsByName() {
        if (flagsByName != null) return flagsByName;
        Class<VmTraceFlag> clazz = VmTraceFlag.class;
        synchronized (VmTraceFlag.class) {
            if (flagsByName != null) return flagsByName;
            HashMap<String, VmTraceFlag> tmp = new HashMap<String, VmTraceFlag>();
            for (VmTraceFlag flag : VmTraceFlag.values()) {
                tmp.put(flag.getName().toLowerCase(), flag);
            }
            flagsByName = tmp;
            // ** MonitorExit[var0] (shouldn't be in output)
            return flagsByName;
        }
    }

    @Deprecated
    public static VmTraceFlag getFlagByFlagnumber(int flagnumber) {
        return VmTraceFlag.getFlagByNumber(flagnumber);
    }

    public static VmTraceFlag getFlagByNumber(int number) {
        return VmTraceFlag.flagsByNumber().containsKey(number) ? flagsByNumber.get(number) : null;
    }

    public static VmTraceFlag getFlagByName(String name) {
        String nameLower = name.toLowerCase();
        return VmTraceFlag.flagsByName().containsKey(nameLower) ? flagsByName.get(nameLower) : null;
    }
}

