/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling;

import com.sap.jvm.profiling.CommandHandler;
import com.sap.jvm.profiling.Connection;
import com.sap.jvm.profiling.DebuggingConnection;
import com.sap.jvm.profiling.OfflineProfilingSession;
import com.sap.jvm.profiling.OnlineProfilingSession;
import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.alert.command.AlertCommandFactory;
import com.sap.jvm.profiling.control.command.ControlCommandFactory;
import com.sap.jvm.profiling.core.command.CommandFactory;
import com.sap.jvm.profiling.core.command.CoreCommandFactory;
import com.sap.jvm.profiling.core.filter.FilterFactory;
import com.sap.jvm.profiling.exception.command.ExceptionCommandFactory;
import com.sap.jvm.profiling.impl.CommandHandlerImpl;
import com.sap.jvm.profiling.impl.DebuggingConnectionImpl;
import com.sap.jvm.profiling.impl.SocketConnectionImpl;
import com.sap.jvm.profiling.impl.alert.command.AlertCommandFactoryImpl;
import com.sap.jvm.profiling.impl.control.command.ControlCommandFactoryImpl;
import com.sap.jvm.profiling.impl.core.command.CommandFactoryImpl;
import com.sap.jvm.profiling.impl.core.command.CoreCommandFactoryImpl;
import com.sap.jvm.profiling.impl.core.filter.FilterFactoryImpl;
import com.sap.jvm.profiling.impl.exception.command.ExceptionCommandFactoryImpl;
import com.sap.jvm.profiling.impl.io.command.IOCommandFactoryImpl;
import com.sap.jvm.profiling.impl.jit.command.JitCommandFactoryImpl;
import com.sap.jvm.profiling.impl.memory.command.GcHistoryFileCommandFactoryImpl;
import com.sap.jvm.profiling.impl.memory.command.MemoryCommandFactoryImpl;
import com.sap.jvm.profiling.impl.method.command.MethodCommandFactoryImpl;
import com.sap.jvm.profiling.impl.monitoring.command.MonitoringCommandFactoryImpl;
import com.sap.jvm.profiling.impl.net.command.NetworkCommandFactoryImpl;
import com.sap.jvm.profiling.impl.session.InputStreamProfilingSessionImpl;
import com.sap.jvm.profiling.impl.session.OfflineProfilingSessionImpl;
import com.sap.jvm.profiling.impl.session.OnlineProfilingSessionImpl;
import com.sap.jvm.profiling.impl.summary.command.SummaryCommandFactoryImpl;
import com.sap.jvm.profiling.impl.sync.command.SynchronizationCommandFactoryImpl;
import com.sap.jvm.profiling.impl.thread.command.ThreadCommandFactoryImpl;
import com.sap.jvm.profiling.impl.util.ProfilingFileInputStream;
import com.sap.jvm.profiling.io.command.IOCommandFactory;
import com.sap.jvm.profiling.jit.command.JitCommandFactory;
import com.sap.jvm.profiling.memory.command.GcHistoryFileCommandFactory;
import com.sap.jvm.profiling.memory.command.MemoryCommandFactory;
import com.sap.jvm.profiling.method.command.MethodCommandFactory;
import com.sap.jvm.profiling.monitoring.command.MonitoringCommandFactory;
import com.sap.jvm.profiling.net.command.NetworkCommandFactory;
import com.sap.jvm.profiling.summary.command.SummaryCommandFactory;
import com.sap.jvm.profiling.sync.command.SynchronizationCommandFactory;
import com.sap.jvm.profiling.thread.command.ThreadCommandFactory;
import com.sap.jvm.util.misc.SocketAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ProfilingFactory {
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 6;
    public static final int MICRO_VERSION = 0;

    public static OfflineProfilingSession createSession(String filename) throws IOException {
        return new OfflineProfilingSessionImpl(filename);
    }

    public static OnlineProfilingSession createSession(Connection connection) throws IOException {
        return new OnlineProfilingSessionImpl(connection);
    }

    public static OfflineProfilingSession createSession() throws IOException {
        return new OfflineProfilingSessionImpl();
    }

    public static ProfilingSession createSession(InputStream is) throws IOException {
        return new InputStreamProfilingSessionImpl(is);
    }

    public static CommandHandler createCommandHandler(OutputStream outputStream) {
        return new CommandHandlerImpl(outputStream);
    }

    public static CommandHandler createCommandHandler(Connection connection) {
        return new CommandHandlerImpl(connection);
    }

    public static CommandFactory createCommandFactory() {
        return new CommandFactoryImpl();
    }

    public static JitCommandFactory createJitCommandFactory() {
        return new JitCommandFactoryImpl();
    }

    public static MemoryCommandFactory createMemoryCommandFactory() {
        return new MemoryCommandFactoryImpl();
    }

    public static IOCommandFactory createIOCommandFactory() {
        return new IOCommandFactoryImpl();
    }

    public static SummaryCommandFactory createSummaryCommandFactory() {
        return new SummaryCommandFactoryImpl();
    }

    public static MethodCommandFactory createMethodCommandFactory() {
        return new MethodCommandFactoryImpl();
    }

    public static ThreadCommandFactory createThreadCommandFactory() {
        return new ThreadCommandFactoryImpl();
    }

    public static SynchronizationCommandFactory createSynchronizationCommandFactory() {
        return new SynchronizationCommandFactoryImpl();
    }

    public static NetworkCommandFactory createNetworkCommandFactory() {
        return new NetworkCommandFactoryImpl();
    }

    public static ExceptionCommandFactory createExceptionCommandFactory() {
        return new ExceptionCommandFactoryImpl();
    }

    public static AlertCommandFactory createAlertCommandFactory() {
        return new AlertCommandFactoryImpl();
    }

    public static CoreCommandFactory createCoreCommandFactory() {
        return new CoreCommandFactoryImpl();
    }

    public static ControlCommandFactory createControlCommandFactory() {
        return new ControlCommandFactoryImpl();
    }

    public static FilterFactory createFilterFactory() {
        return new FilterFactoryImpl();
    }

    public static MonitoringCommandFactory createMonitoringCommandFactory() {
        return new MonitoringCommandFactoryImpl();
    }

    public static GcHistoryFileCommandFactory createGcHistoryFileCommandFactory() {
        return new GcHistoryFileCommandFactoryImpl();
    }

    public static SocketAdapter createSocket(int pid, String hostname, int port) throws IOException {
        if (port < 0) {
            return SocketConnectionImpl.createFileSocketConnection(pid, null);
        }
        return SocketConnectionImpl.createJvmmondSocketConnection(hostname, pid, port);
    }

    public static SocketAdapter createFileSocket(int pid, String socketIdentifier) throws IOException {
        return SocketConnectionImpl.createFileSocketConnection(pid, socketIdentifier);
    }

    public static Connection createSocketConnection(SocketAdapter socket, String backupFileName) throws IOException {
        return new SocketConnectionImpl(socket, backupFileName);
    }

    public static DebuggingConnection createDebuggingConnection(String hostname, int port, boolean withDebugging) throws IOException {
        return new DebuggingConnectionImpl(hostname, port, withDebugging, null);
    }

    public static DebuggingConnection createDebuggingConnection(String hostname, int port, boolean withDebugging, String backupFileName) throws IOException {
        return new DebuggingConnectionImpl(hostname, port, withDebugging, backupFileName);
    }

    public static DebuggingConnection createDebuggingConnection(InputStream in, OutputStream out, boolean withDebugging) throws IOException {
        return new DebuggingConnectionImpl(in, out, withDebugging, null);
    }

    public static DebuggingConnection createDebuggingConnection(InputStream in, OutputStream out, boolean withDebugging, String backupFileName) throws IOException {
        return new DebuggingConnectionImpl(in, out, withDebugging, backupFileName);
    }

    public static boolean checkProfilingFile(String path) {
        try {
            return ProfilingFileInputStream.isProfilingContent(path);
        }
        catch (Exception e) {
            return false;
        }
    }
}

