/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling;

import com.sap.jvm.tracing.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Properties;

public class RCPUtil {
    public static final String PROFILER_VERSION = "24";
    public static final String WP_MARKER = ".profiler24";
    public static final String WP_SWITCH_KEY = "WP_SWITCH_KEY";
    public static final String WP_HISTORY = "WP_HISTORY_";
    public static final String WP_LOCATION_KEY = "WP_LOCATION";
    public static final String SAPJVM_LABEL = "SAPJVM Profiler Workspace";
    public static final String SYSPROP_STARTUP_KEY = "prf.startup.file";

    public static boolean markWorkspaceForSwitch() {
        File wpMarkerFile = new File(System.getProperty("user.home"), WP_MARKER);
        Properties props = new Properties();
        try {
            String entry;
            if (!wpMarkerFile.exists()) {
                wpMarkerFile.createNewFile();
            } else {
                props.load(new FileInputStream(wpMarkerFile));
            }
            props.put(WP_SWITCH_KEY, String.valueOf(true));
            LinkedHashSet<String> history = new LinkedHashSet<String>();
            int idx = 0;
            while ((entry = props.getProperty(WP_HISTORY + idx++)) != null) {
                history.add(entry);
            }
            history.remove(props.getProperty(WP_LOCATION_KEY));
            idx = 0;
            props.put(WP_HISTORY + idx++, props.getProperty(WP_LOCATION_KEY));
            for (String e : history) {
                props.put(WP_HISTORY + idx++, e);
                if (idx != 5) continue;
                break;
            }
            props.store(new FileOutputStream(wpMarkerFile), SAPJVM_LABEL);
            return true;
        }
        catch (IOException e) {
            Trace.error(e);
            return false;
        }
    }
}

