/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.IpAddress;
import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.MonitorObject;
import com.sap.jvm.profiling.core.type.PackageName;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.thread.ThreadDump;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;

public class SimpleProfilingWriter
implements ResourceWriter {
    private ByteArrayOutputStream packetStream;
    private final DataOutputStream packetStreamWriter;
    private final DeflaterOutputStream dos;
    private int packetType;
    private long nextClassId;
    private long nextMethodId;
    private int nextStackTraceId;
    private long nextThreadDumpId;
    private final HashMap<String, Long> classNameToId;
    private final Map<Long, String> missingFileNameClassIds;
    private final boolean postponeClassesMode;
    private final HashMap<String, Long> methodsToId;
    private final HashMap<StackTrace, Integer> stackTraces;
    private final HashMap<Long, MonitorObject> monitorObjects;
    private final long objectClassId;

    public static void main(String[] args) throws Exception {
        SimpleProfilingWriter writer = new SimpleProfilingWriter(new FileOutputStream("E:\\tmp64\\test.prf"), 1, 8, 0, false);
        int nrOfMethods = args.length > 0 ? Integer.parseInt(args[0]) : 10000;
        String name = SimpleProfilingWriter.getRandomString(65520);
        String signature = "(" + SimpleProfilingWriter.getRandomString(65520) + ")";
        writer.ensureMethod("smallKlass", name, signature, null, false);
        signature = signature + "void";
        writer.ensureMethod("smallKlass", name, signature, null, false);
        for (int i = 0; i < nrOfMethods; ++i) {
            int packetParts = (int)(Math.random() * 5.0 + 1.0);
            String pkg = "";
            for (int j = 0; j < packetParts; ++j) {
                pkg = pkg + SimpleProfilingWriter.getRandomString((int)(Math.random() * 20.0 + 1.0));
                pkg = pkg + ".";
            }
            String clazz = pkg + SimpleProfilingWriter.getRandomString(20 + (int)(Math.random() * 20.0));
            name = SimpleProfilingWriter.getRandomString(10);
            signature = "(" + SimpleProfilingWriter.getRandomString(80) + ")";
            writer.ensureMethod(clazz, name, signature, null, false);
            writer.startPacket((short)509);
            writer.writeMethod(clazz, name, signature);
            writer.finalizePacket();
        }
        writer.close();
    }

    private static String getRandomString(int len) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            result.append((char)(Math.random() * 26.0 + 97.0));
        }
        return result.toString();
    }

    public SimpleProfilingWriter(OutputStream os, int major, int minor, int micro, boolean classesPostponeMode) throws IOException {
        os.write(3);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream tdos = new DataOutputStream(bos);
        tdos.writeInt(-1091581234);
        tdos.writeChar(13);
        tdos.writeChar((char)major);
        tdos.writeChar((char)minor);
        tdos.writeChar((char)micro);
        tdos.close();
        os.write(bos.toByteArray());
        this.dos = new DeflaterOutputStream(os);
        this.packetStream = new ByteArrayOutputStream();
        this.packetStreamWriter = new DataOutputStream(this.packetStream);
        this.packetType = -1;
        this.nextMethodId = this.nextClassId = 100000L;
        this.classNameToId = new HashMap();
        this.missingFileNameClassIds = new HashMap<Long, String>();
        this.postponeClassesMode = classesPostponeMode;
        this.methodsToId = new HashMap();
        this.stackTraces = new HashMap(100);
        this.monitorObjects = new HashMap(100);
        this.startPacket((short)404);
        this.writeInt64(0L);
        this.writeInt32(0);
        this.writeUTF("<bootstrap>");
        this.writeUint16('\u0000');
        this.writeInt8(0);
        this.finalizePacket();
        this.objectClassId = this.ensureClass("java.lang.Object", "Object.java");
    }

    public void startPacket(short type) {
        assert (this.packetType == -1);
        this.packetType = type;
    }

    public long ensureClass(String className, String fileName) throws IOException {
        Long id = this.classNameToId.get(className);
        if (id == null) {
            id = this.nextClassId;
            ++this.nextClassId;
            this.classNameToId.put(className, id);
            if (fileName != null || !this.postponeClassesMode) {
                this.writeClass(id, className, fileName);
            } else {
                this.missingFileNameClassIds.put(id, className);
            }
        } else if (this.postponeClassesMode && fileName != null && this.missingFileNameClassIds.containsKey(id)) {
            this.writeClass(id, className, fileName);
            this.missingFileNameClassIds.remove(id);
        }
        return id;
    }

    private void writeClass(long id, String className, String fileName) throws IOException {
        this.startPacket((short)400);
        this.writeInt64(id);
        this.writeInt64(0L);
        this.writeInt64(this.objectClassId);
        this.writeUint16(0);
        this.writeUint16(0);
        this.writeUint16(0);
        this.writeUTF(className.replace('.', '/'));
        this.writeInt32(0);
        this.writeInt32(24);
        if (fileName != null) {
            this.writeUTF(fileName);
        }
        this.finalizePacket();
    }

    public void writeClass(String className) throws IOException {
        long id = this.classNameToId.get(className);
        this.writeInt64(id);
    }

    public long ensureMethod(String className, String methodName, String signature, String fileName, boolean isNative) throws IOException {
        this.ensureClass(className, fileName);
        String key = className + "." + methodName + signature;
        Long id = this.methodsToId.get(key);
        if (id == null) {
            id = this.nextMethodId;
            ++this.nextMethodId;
            this.methodsToId.put(key, id);
            this.startPacket((short)408);
            this.writeInt64(id);
            this.writeInt64(this.classNameToId.get(className));
            this.writeUTF(methodName);
            this.writeUTF(signature);
            int options = 0x200000;
            if (isNative) {
                options |= 0x100;
            }
            this.writeInt32(options);
            this.finalizePacket();
        }
        return id;
    }

    public void writeMethod(String className, String methodName, String signature) throws IOException {
        String key = className + "." + methodName + signature;
        Long id = this.methodsToId.get(key);
        this.writeInt64(id);
    }

    public MonitorObject ensureMonitorObject(long id, String clazz) throws IOException {
        MonitorObject monitor = this.monitorObjects.get(id);
        if (monitor == null) {
            long clazzId = this.ensureClass(clazz, null);
            monitor = new MonitorObject(id, clazzId);
            this.monitorObjects.put(id, monitor);
        }
        return monitor;
    }

    public void writeSocketAddress(IpAddress addr, String hostname) throws IOException {
        this.startPacket(addr.isIPv4() ? (short)415 : 416);
        this.writeUTF(hostname != null ? hostname : "");
        addr.write(this);
        this.finalizePacket();
    }

    public int writeStackTrace(SimpleStackFrame[] stackTrace) throws IOException {
        HashMap<String, String> fileNames = new HashMap<String, String>();
        for (SimpleStackFrame frame : stackTrace) {
            if (frame.fileName == null) continue;
            fileNames.put(frame.className, frame.fileName);
        }
        long[] methodIds = new long[stackTrace.length];
        for (int i = 0; i < stackTrace.length; ++i) {
            String className = stackTrace[i].className;
            String fileName = (String)fileNames.get(className);
            if (fileName == null) {
                int index = className.lastIndexOf(46) + 1;
                fileName = className.substring(index) + ".java";
            }
            methodIds[i] = this.ensureMethod(className, stackTrace[i].methodName, stackTrace[i].signature, fileName, stackTrace[i].isNative);
        }
        int id = this.getStackTraceId(methodIds);
        this.startPacket((short)409);
        this.writeInt32(id);
        this.writeInt32(stackTrace.length);
        this.writeInt32(0);
        this.writeInt32(0);
        for (int i = 0; i < stackTrace.length; ++i) {
            this.writeInt64(methodIds[i]);
            this.writeInt16(stackTrace[i].lineNumber);
        }
        this.finalizePacket();
        return id;
    }

    private int getStackTraceId(long[] methodIds) {
        StackTrace key = new StackTrace(methodIds);
        Integer id = this.stackTraces.get(key);
        if (id == null) {
            id = ++this.nextStackTraceId;
            this.stackTraces.put(key, id);
        }
        return id;
    }

    public void writeThreadDump(ThreadDump threadDump) throws IOException {
        this.startPacket((short)764);
        this.writeInt64(threadDump.getTimeStamp());
        threadDump.write(this);
        this.finalizePacket();
    }

    public void writeThreadDumpsStart(int num, long timestamp) throws IOException {
        for (Map.Entry<Long, String> missingClasses : this.missingFileNameClassIds.entrySet()) {
            long id = missingClasses.getKey();
            String className = missingClasses.getValue();
            this.writeClass(id, className, null);
        }
        this.missingFileNameClassIds.clear();
        this.startPacket((short)1069);
        this.writeInt64(this.nextThreadDumpId++);
        this.writeInt64(timestamp);
        this.writeBoolean(true);
        this.writeInt32(num);
        this.writeInt64(0L);
        this.writeInt64(0L);
        this.finalizePacket();
    }

    public void writeThreadDumpsEnd(long timestamp) throws IOException {
        this.startPacket((short)765);
        this.finalizePacket();
        this.startPacket((short)1070);
        this.writeInt64(this.nextThreadDumpId++);
        this.writeInt64(timestamp);
        this.writeBoolean(true);
        this.finalizePacket();
    }

    public void close() throws IOException {
        this.dos.close();
        this.packetStreamWriter.close();
    }

    public void finalizePacket() throws IOException {
        assert (this.packetType != -1);
        this.packetStream.flush();
        byte[] data = this.packetStream.toByteArray();
        this.packetStream.reset();
        int off = 0;
        int len = data.length;
        int maxLen = 65530;
        int maxPacketLen = maxLen + 4;
        while (len - off > maxLen) {
            this.dos.write(new byte[]{(byte)(0x80 | this.packetType >> 8), (byte)(this.packetType & 0xFF), (byte)(maxPacketLen >> 8), (byte)(maxPacketLen & 0xFF)});
            this.dos.write(data, off, maxLen);
            off += maxLen;
        }
        int left = len - off;
        this.dos.write(new byte[]{(byte)(this.packetType >> 8), (byte)(this.packetType & 0xFF), (byte)(left + 4 >> 8), (byte)(left + 4 & 0xFF)});
        this.dos.write(data, off, left);
        this.dos.flush();
        this.packetType = -1;
    }

    @Override
    public void writeInt32(int value) throws IOException {
        this.packetStreamWriter.writeInt(value);
    }

    @Override
    public void writeInt16(short value) throws IOException {
        this.packetStreamWriter.writeShort(value);
    }

    public void writeUint16(int value) throws IOException {
        this.packetStreamWriter.writeChar(value);
    }

    @Override
    public void writeUint16(char value) throws IOException {
        this.writeUint16((int)value);
    }

    @Override
    public void writeInt8(int value) throws IOException {
        this.packetStreamWriter.writeByte(value);
    }

    @Override
    public void writeInt64(long value) throws IOException {
        this.packetStreamWriter.writeLong(value);
    }

    @Override
    public void writeString(String value) throws IOException {
        this.packetStreamWriter.writeBytes(value);
    }

    @Override
    public void writeStringSafe(String value) throws IOException {
        if (value != null) {
            this.writeString(value);
        } else {
            this.writeString("");
        }
    }

    @Override
    public void writeBigString(String value) throws IOException {
        throw new RuntimeException("Should not be called");
    }

    public void writeUTF(String value) throws IOException {
        this.packetStreamWriter.writeUTF(value);
    }

    @Override
    public void writeUTF(byte[] bytes, int offset, int length) throws IOException {
        char len = (char)length;
        if (len != length) {
            throw new UTFDataFormatException("UTF string too long: " + length + " bytes");
        }
        this.writeUint16(len);
        this.writeBytes(bytes, offset, length);
    }

    @Override
    public void writeUTF(byte[] bytes) throws IOException {
        this.writeUTF(bytes, 0, bytes.length);
    }

    @Override
    public void writeBytes(byte[] bytes) throws IOException {
        this.packetStreamWriter.write(bytes);
    }

    @Override
    public void writeBytes(byte[] bytes, int offset, int length) throws IOException {
        this.packetStreamWriter.write(bytes, offset, length);
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        this.writeInt8(value ? 1 : 0);
    }

    @Override
    public void writeFloat(float value) throws IOException {
        this.packetStreamWriter.writeFloat(value);
    }

    @Override
    public void writeDouble(double value) throws IOException {
        this.packetStreamWriter.writeDouble(value);
    }

    @Override
    public void writeVersion(int version) throws IOException {
        this.writeInt32(version);
    }

    @Override
    public void writeCompressedInt32(int value) throws IOException {
        if (value >= 0 && value <= Short.MAX_VALUE) {
            this.writeInt16((short)value);
        } else {
            this.writeUint16('\uffff');
            this.writeInt32(value);
        }
    }

    @Override
    public ProfilingSession getSession() {
        return null;
    }

    @Override
    public void writeUTF(UTF8String value) throws IOException {
        this.writeUTF(value.getBytes());
    }

    @Override
    public void writeClassLoaderObject(ClassLoaderObject classLoaderObject) throws IOException {
        this.writeInt64(classLoaderObject == null ? 0L : (long)classLoaderObject.getIndex());
    }

    @Override
    public void writeClassObject(ClassObject classObject) throws IOException {
        throw new InternalError();
    }

    @Override
    public void writeMethodObject(MethodObject methodObject) throws IOException {
        throw new InternalError();
    }

    @Override
    public void writeMethodLocation(MethodLocation location) throws IOException {
        throw new InternalError();
    }

    @Override
    public void writePackageName(PackageName name) throws IOException {
        throw new InternalError();
    }

    @Override
    public void writeThreadFilter(ThreadFilter threadFilter) throws IOException {
        throw new InternalError();
    }

    @Override
    public void writeNewThreadFilter(ThreadFilter threadFilter) throws IOException {
        throw new InternalError();
    }

    static class StackTrace {
        final long[] methodIds;

        public StackTrace(long[] methodIds) {
            this.methodIds = methodIds;
        }

        public int hashCode() {
            return Arrays.hashCode(this.methodIds);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StackTrace other = (StackTrace)obj;
            return Arrays.equals(this.methodIds, other.methodIds);
        }

        public long[] getMethodIds() {
            return this.methodIds;
        }
    }

    public static class SimpleStackFrame {
        private final String className;
        private final String methodName;
        private final String signature;
        private final short lineNumber;
        private final String fileName;
        private final boolean isNative;

        public SimpleStackFrame(String className, String methodName, String signature, short lineNumber, String fileName, boolean isNative) {
            this.className = className;
            this.methodName = methodName;
            this.signature = signature;
            this.lineNumber = lineNumber;
            this.fileName = fileName;
            this.isNative = isNative;
        }
    }
}

