/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.api;

import com.sap.jvm.profiling.api.MethodParameterSpec;
import com.sap.jvm.profiling.api.ProfilingCapabilities;
import com.sap.jvm.profiling.api.ProfilingTraceSpec;
import java.util.ArrayList;
import java.util.List;

public final class AllocationTraceSpec
extends ProfilingTraceSpec {
    public static final boolean DEFAULT_ADAPTIVE = false;
    private boolean adaptive = false;
    private List<MethodParameterSpec> parameters = null;

    public AllocationTraceSpec() {
        this.theImpl = theProfilingCore.createAllocationTraceSpecImpl(this);
    }

    public boolean getAdaptive() {
        return this.adaptive;
    }

    public void setAdaptive(boolean adaptive) {
        this.adaptive = adaptive;
    }

    public List<MethodParameterSpec> getMethodParameters() {
        return this.parameters;
    }

    public void setMethodParameters(List<MethodParameterSpec> parameters) {
        this.parameters = parameters;
    }

    @Override
    public ProfilingCapabilities[] getNeededCapabilities() {
        ArrayList<ProfilingCapabilities> capList = new ArrayList<ProfilingCapabilities>();
        if (this.adaptive) {
            capList.add(ProfilingCapabilities.AdaptiveAllocationTrace);
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            capList.add(ProfilingCapabilities.AllocationTraceWithMethodParameters);
            if (this.hasAnnotationFilters()) {
                capList.add(ProfilingCapabilities.MethodParameterTraceWithThreadAnnotationFilter);
            }
        }
        if (!this.adaptive && (this.parameters == null || this.parameters.isEmpty())) {
            capList.add(ProfilingCapabilities.AllocationTrace);
        }
        ProfilingCapabilities[] retValue = new ProfilingCapabilities[capList.size()];
        return capList.toArray(retValue);
    }
}

