/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.api;

import com.sap.jvm.profiling.api.IncludeType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class MethodParameterSpec {
    private final String name;
    private final String description;
    private final String method;
    private final int index;
    private final IncludeType includeType;
    private final ArrayList<String> modifiers;

    public MethodParameterSpec(String name, String description, String method, int index, IncludeType includeType, List<String> modifiers) {
        assert (index >= 0);
        this.name = name;
        this.description = description;
        this.method = method;
        this.index = index;
        this.includeType = includeType;
        this.modifiers = new ArrayList<String>(modifiers);
    }

    public MethodParameterSpec(String name, String description, String method, int index, IncludeType includeType, String ... modifiers) {
        assert (index >= 0);
        this.name = name;
        this.description = description;
        this.method = method;
        this.index = index;
        this.includeType = includeType;
        this.modifiers = new ArrayList<String>(Arrays.asList(modifiers));
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMethod() {
        return this.method;
    }

    public int getIndex() {
        return this.index;
    }

    public IncludeType getIncludeType() {
        return this.includeType;
    }

    public List<String> getModifiers() {
        return new ArrayList<String>(this.modifiers);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodParameterSpec)) {
            return false;
        }
        MethodParameterSpec compare = (MethodParameterSpec)obj;
        return compare.name.equals(this.name) && compare.method.equals(this.method) && compare.index == this.index && compare.includeType == this.includeType && compare.modifiers.equals(this.modifiers);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Method Parameter[").append("name=").append(this.getName()).append(",description=").append(this.getDescription()).append(",method=").append(this.getMethod()).append(",index=").append(this.getIndex()).append(",includeType=").append((Object)this.getIncludeType()).append(",modifiers=(");
        Iterator<String> it = this.modifiers.iterator();
        while (it.hasNext()) {
            builder.append(it.next());
            if (!it.hasNext()) continue;
            builder.append(",");
        }
        builder.append(")]");
        return builder.toString();
    }
}

