/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.api;

import com.sap.jvm.APIServiceLoader;
import com.sap.jvm.monitor.MonitoringPermission;
import com.sap.jvm.monitor.vm.VmInfo;
import com.sap.jvm.profiling.api.ProfilingCapabilities;
import com.sap.jvm.profiling.api.ProfilingCoreInterface;
import com.sap.jvm.profiling.api.ProfilingRun;
import com.sap.jvm.profiling.api.ProfilingVMInterface;
import com.sap.jvm.profiling.api.ProfilingVersion;
import java.io.OutputStream;

public final class VmProfiling {
    private static final ProfilingVMInterface theProfilingVMInterface = APIServiceLoader.load(ProfilingVMInterface.class).findFirst().orElse(null);
    private static ProfilingCoreInterface theProfilingCore = APIServiceLoader.load(ProfilingCoreInterface.class).findFirst().orElse(null);

    public static ProfilingRun create(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("The \"filename\" parameter is null.");
        }
        return theProfilingCore.newProfilingRun(filename);
    }

    public static boolean isSupported(ProfilingCapabilities capability) {
        if (capability == ProfilingCapabilities.MethodParameterTraceWithThreadAnnotationFilter) {
            return false;
        }
        return capability != ProfilingCapabilities.MethodCoverageTraceWithThreadAnnotationFilter;
    }

    public static OutputStream startProfiling(String filePrefix) {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        if (filePrefix == null) {
            throw new IllegalArgumentException("The parameter \"filePrefix\" is null.");
        }
        return theProfilingVMInterface.getOutputStream(filePrefix);
    }

    public static boolean isProfilingStarted() {
        return VmInfo.getProfilingInfo().getNrOfActiveProfilingRuns() != 0;
    }

    public static void stopAllProfilingRuns() {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        theProfilingVMInterface.stopAllProfilingRuns();
    }

    public static synchronized ProfilingVersion getVersion() {
        return theProfilingVMInterface.getVersion();
    }
}

