/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.core;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.SimpleProfilingPrintStream;
import com.sap.jvm.profiling.core.event.SystemInfo;
import com.sap.jvm.profiling.core.type.ClassObjectManager;
import com.sap.jvm.profiling.core.type.MethodLocationManager;
import com.sap.jvm.profiling.core.type.MethodObjectManager;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.util.FormatUtils;
import java.io.PrintStream;
import java.util.Date;

public class DetailedProfilingPrintStream
extends SimpleProfilingPrintStream {
    private final int indent;
    private final int maxFrames;
    private final long startTimeStamp;
    private final StackFrames stack;
    private final ClassObjectManager classManager;
    private final MethodObjectManager methodManager;
    private final MethodLocationManager methodLocationManager;
    private final SystemInfo systemInfo;

    public DetailedProfilingPrintStream(PrintStream stream, int indent, int maxFrames, ProfilingSession session) {
        super(stream);
        this.indent = indent;
        this.maxFrames = maxFrames;
        this.startTimeStamp = session.getSystemInfo() == null ? 0L : session.getSystemInfo().getTimeStamp();
        this.stack = session.getStackTraceManager().getStackFramesObject(true);
        this.classManager = session.getClassObjectManager();
        this.methodManager = session.getMethodObjectManager();
        this.methodLocationManager = session.getMethodLocationManager();
        this.systemInfo = session.getSystemInfo();
    }

    @Override
    protected void printClassIndex(int classIndex, int pos) {
        this.printClassObject(this.classManager.getClassObject(classIndex), pos);
    }

    @Override
    protected void printMethodIndex(int methodIndex, int pos) {
        this.printMethodObject(this.methodManager.getMethodObject(methodIndex), pos);
    }

    @Override
    protected void printMethodLocationIndex(int locationIndex, int pos) {
        this.printMethodLocation(this.methodLocationManager.getLocation(locationIndex), pos);
    }

    @Override
    protected void printBytes(long nrOfBytes) {
        this.print(DataFormatter.getNrOfBytesText(nrOfBytes));
        this.format(" (%,d bytes)", nrOfBytes);
    }

    @Override
    protected void printDuration(long nanoseconds) {
        this.print(FormatUtils.formattedDuration(nanoseconds));
    }

    @Override
    protected void printStackTrace(int stackTraceIndex, int pos) {
        this.print("index " + stackTraceIndex);
        if (this.maxFrames > 0) {
            this.stack.fillIn(stackTraceIndex);
            int oldIndent = this.getIndent();
            int nrOfFrames = this.stack.getNrOfFrames();
            int max = Math.min(nrOfFrames, this.maxFrames);
            this.setIndent(pos);
            for (int i = 0; i < max; ++i) {
                this.println();
                this.print(this.stack.getMethodLocation(nrOfFrames - i - 1).toString());
            }
            this.setIndent(oldIndent);
        }
    }

    @Override
    protected void printThread(int threadIndex, int pos) {
        this.print("Thread index " + threadIndex);
    }

    @Override
    protected void printTimeStampAfterStart(long nanoseconds) {
        this.print(FormatUtils.getElapseNanoSeconds(nanoseconds - this.startTimeStamp, 1000000L));
    }

    @Override
    protected void printDate(long time) {
        long elapsed;
        if (this.systemInfo != null && (elapsed = time - this.systemInfo.getStartTimeMillis()) >= 0L) {
            this.print(new Date(time).toString() + " (" + DataFormatter.getNumberText(elapsed) + DataFormatter.UNIT_SEP + "ms)");
            return;
        }
        super.printDate(time);
    }

    @Override
    public void printlnPacketHeader(ProfilingPacket packet) {
        this.setIndent(0);
        this.println(packet.getPacketName());
        this.setIndent(this.indent);
    }

    @Override
    public void printlnResponseHeader(Response response) {
        this.setIndent(0);
        this.println(response.getPacketName());
        this.setIndent(this.indent);
        this.println("id      : " + response.getId());
        this.println("success : " + response.isSuccess());
        this.println("Time    : " + new Date(response.getTime()));
        if (!response.isSuccess()) {
            this.println("error  : " + response.getErrorMessage());
        }
        super.setIndent(this.indent);
    }
}

