/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.core;

import com.sap.jvm.profiling.i18n.I18n;

public enum ProfilingTraceType {
    ALL_TRACES(0, I18n._s("All Analyses")),
    ALLOCATION_TRACE(1, I18n._s("Allocation Analysis")),
    PERFORMANCE_HOTSPOT_TRACE(2, I18n._s("Performance Hotspot Analysis")),
    METHOD_PARAMETER_TRACE(3, I18n._s("Method Parameter Analysis")),
    THREAD_HOTSPOT_TRACE(4, I18n._s("Thread Hotspot Analysis")),
    GC_TRACE(5, I18n._s("GC Analysis")),
    IO_TRACE(6, I18n._s("File I/O Analysis")),
    METHOD_TRACE(7, I18n._s("Method Analysis")),
    SYNCHRONIZATION_TRACE(8, I18n._s("Synchronization Analysis")),
    NETWORK_TRACE(9, I18n._s("Network I/O Analysis")),
    HPROF_DUMP(10, I18n._s("Heap Dump Analysis")),
    CLASS_STATISTIC_TRACE(11, I18n._s("Class Statistic Analysis")),
    THREAD_DUMP_TRACE(12, I18n._s("Thread Dump Analysis")),
    GC_HISTORY_FILE_DUMP(13, I18n._s("Request GC History File"));

    private final int index;
    private final String description;

    public static ProfilingTraceType get(int index) {
        switch (index) {
            case 0: {
                return ALL_TRACES;
            }
            case 1: {
                return ALLOCATION_TRACE;
            }
            case 2: {
                return PERFORMANCE_HOTSPOT_TRACE;
            }
            case 3: {
                return METHOD_PARAMETER_TRACE;
            }
            case 4: {
                return THREAD_HOTSPOT_TRACE;
            }
            case 5: {
                return GC_TRACE;
            }
            case 6: {
                return IO_TRACE;
            }
            case 7: {
                return METHOD_TRACE;
            }
            case 8: {
                return SYNCHRONIZATION_TRACE;
            }
            case 9: {
                return NETWORK_TRACE;
            }
            case 10: {
                return HPROF_DUMP;
            }
            case 11: {
                return CLASS_STATISTIC_TRACE;
            }
            case 12: {
                return THREAD_DUMP_TRACE;
            }
            case 13: {
                return GC_HISTORY_FILE_DUMP;
            }
        }
        return null;
    }

    private ProfilingTraceType(int index, String description) {
        this.index = index;
        this.description = description;
    }

    public int getIndex() {
        return this.index;
    }

    public String asKey() {
        return "profilingTraceType-" + this.name();
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        switch (this.index) {
            case 0: {
                return "all traces";
            }
            case 1: {
                return "allocation trace";
            }
            case 2: {
                return "performance trace";
            }
            case 3: {
                return "method parameter trace";
            }
            case 4: {
                return "thread hotspot trace";
            }
            case 5: {
                return "gc statistic trace";
            }
            case 6: {
                return "io trace";
            }
            case 7: {
                return "method trace";
            }
            case 8: {
                return "synchronization trace";
            }
            case 9: {
                return "network trace";
            }
            case 10: {
                return "hprof dump";
            }
            case 11: {
                return "class statistic trace";
            }
            case 12: {
                return "thread dump trace";
            }
            case 13: {
                return "gc history file dump";
            }
        }
        return null;
    }
}

