/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.core;

public final class ProfilingVersion {
    private static final int[][] SUPPORTED_VERSIONS = new int[][]{{1, 4, 11}, {1, 5, 2}};
    private final int vmMajor;
    private final int vmMinor;
    private final int vmMicro;
    private final boolean isInSupportedList;

    public ProfilingVersion(int majorVersion, int minorVersion, int microVersion) {
        this.vmMajor = majorVersion;
        this.vmMinor = minorVersion;
        this.vmMicro = microVersion;
        this.isInSupportedList = this.checkSupportedVms();
    }

    public int getMajorVersion() {
        return this.vmMajor;
    }

    public int getMinorVersion() {
        return this.vmMinor;
    }

    public int getMicroVersion() {
        return this.vmMicro;
    }

    public boolean isCompatible(int frontendMajor, int frontendMinor, int frontendMicro) {
        if (this.vmMajor == 0 && this.vmMinor == 0 && this.vmMicro == 0) {
            return false;
        }
        if (this.vmMajor > frontendMajor) {
            return false;
        }
        if (this.vmMicro == 0) {
            return true;
        }
        if (this.vmMinor > frontendMinor) {
            return true;
        }
        return this.isInSupportedList;
    }

    public boolean isAtLeast(int majorVersion, int minorVersion) {
        if (this.vmMajor > majorVersion) {
            return true;
        }
        if (this.vmMajor < majorVersion) {
            return false;
        }
        return this.vmMinor >= minorVersion;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ProfilingVersion)) {
            return false;
        }
        ProfilingVersion tmpVersion = (ProfilingVersion)obj;
        return tmpVersion.vmMajor == this.vmMajor && tmpVersion.vmMinor == this.vmMinor && tmpVersion.vmMicro == this.vmMicro;
    }

    public int hashCode() {
        return this.vmMajor ^ this.vmMinor ^ this.vmMicro;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append("major=");
        builder.append(this.vmMajor);
        builder.append(", minor=");
        builder.append(this.vmMinor);
        builder.append(", micro=");
        builder.append(this.vmMicro);
        builder.append("]");
        return builder.toString();
    }

    private boolean checkSupportedVms() {
        for (int i = 0; i < SUPPORTED_VERSIONS.length; ++i) {
            if (this.vmMajor != SUPPORTED_VERSIONS[i][0] || this.vmMinor != SUPPORTED_VERSIONS[i][1] || this.vmMicro != SUPPORTED_VERSIONS[i][2]) continue;
            return true;
        }
        return false;
    }
}

