/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.core;

import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.util.FormatUtils;
import com.sap.jvm.util.misc.SignatureHelper;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Formatter;
import java.util.regex.Pattern;

public class SimpleProfilingPrintStream
implements ProfilingPrintStream,
Appendable {
    private BufferedWriter writer;
    private Formatter formatter;
    private int linePos;
    private static final Pattern pattern = Pattern.compile(Pattern.quote("%*"));
    private int indent;
    private String ls;
    private boolean usePrintCompilationFormatForMethods;

    public SimpleProfilingPrintStream(OutputStream stream) {
        try {
            this.writer = new BufferedWriter(new OutputStreamWriter(stream, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("NO UTF-8?", e);
        }
        this.formatter = new Formatter(this.writer);
        this.ls = System.getProperty("line.separator");
    }

    public void usePrintCompilationFormatForMethods() {
        this.usePrintCompilationFormatForMethods = true;
    }

    protected int getIndent() {
        return this.indent;
    }

    protected void setIndent(int indent) {
        this.indent = indent;
    }

    @Override
    public void format(String format, Object ... params) {
        this.addIndent();
        this.formatOur(format, params);
    }

    @Override
    public void formatln(String format, Object ... params) {
        this.addIndent();
        this.formatOur(format, params);
        this.print(null, true);
        this.linePos = 0;
    }

    @Override
    public void print(String msg) {
        this.addIndent();
        this.print(msg, false);
    }

    @Override
    public void println(String msg) {
        this.addIndent();
        this.print(msg, true);
        this.linePos = 0;
    }

    @Override
    public void println() {
        this.addIndent();
        this.print(null, true);
        this.linePos = 0;
    }

    private void print(String msg, boolean newline) {
        try {
            if (msg != null) {
                this.writer.write(msg);
            }
            if (newline) {
                this.writer.write(this.ls);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void printlnResponseHeader(Response response) {
        this.println(response.getPacketName());
        this.println("id     : " + response.getId());
        this.println("success: " + response.isSuccess());
        this.println("Time   : " + new Date(response.getTime()));
        if (!response.isSuccess()) {
            this.println("error  : " + response.getErrorMessage());
        }
        this.linePos = 0;
    }

    @Override
    public void printlnPacketHeader(ProfilingPacket packet) {
        this.println(packet.getPacketName());
    }

    protected void printBytes(long nrOfBytes) {
        this.print(DataFormatter.getNrOfBytesText(nrOfBytes));
    }

    protected void printDuration(long nanoseconds) {
        this.print(FormatUtils.formattedDuration(nanoseconds));
    }

    protected void printRawTimeStamp(long nanoseconds) {
        this.print(FormatUtils.formattedTimeStamp(nanoseconds));
    }

    protected void printTimeStampAfterStart(long nanoseconds) {
        this.print(nanoseconds + " ns after start");
    }

    protected void printClassObject(ClassObject clazz, int pos) {
        if (clazz == null) {
            this.print("<none>");
        } else {
            this.print(clazz.getFullName());
        }
    }

    protected void printClassLoader(ClassLoaderObject loader, int pos) {
        if (loader.isBootstrapClassLoader()) {
            this.print("<bootstrap>");
        } else if (!loader.getName().isEmpty()) {
            this.print("'" + loader.getName() + "' (id " + loader.getId() + ")");
        } else {
            this.print("@" + loader.getClassObject() + " (id " + loader.getId() + ")");
        }
    }

    protected void printClassIndex(int classIndex, int pos) {
        this.print("Class index: " + classIndex);
    }

    protected void printMethodObject(MethodObject method, int pos) {
        if (method == null) {
            this.print("<none>");
        } else if (this.usePrintCompilationFormatForMethods) {
            this.print(method.getMethodClass().getFullName() + "::" + method.getName() + SignatureHelper.toInternalSignature("(" + method.getSignature() + ")" + method.getReturnType()));
        } else {
            this.print(method.getFullName());
        }
    }

    protected void printMethodIndex(int methodIndex, int pos) {
        this.print("Method index: " + methodIndex);
    }

    protected void printMethodLocation(MethodLocation location, int pos) {
        if (location == null) {
            this.print("<none>");
        } else {
            this.print(location.toString());
        }
    }

    protected void printMethodLocationIndex(int locationIndex, int pos) {
        this.print("Method location index: " + locationIndex);
    }

    protected void printStackTrace(int stackTraceIndex, int pos) {
        this.print("index " + stackTraceIndex);
    }

    protected void printDate(long time) {
        this.print(new Date(time).toString());
    }

    protected void printThread(int threadIndex, int pos) {
        this.print("index " + threadIndex);
    }

    private void formatOur(String format, Object[] params) {
        if (format.indexOf(42) < 0) {
            this.formatter.format(format, params);
            return;
        }
        String[] parts = pattern.split(format);
        if (parts.length <= 1) {
            this.formatter.format(format, params);
            return;
        }
        int start = 0;
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (part.length() == 0) continue;
            StringBuilder newPart = new StringBuilder();
            int first = 0;
            if (i > 0) {
                switch (parts[i].charAt(0)) {
                    case 'A': {
                        this.printDate(((Number)params[start]).longValue());
                        break;
                    }
                    case 'B': {
                        this.printBytes(((Number)params[start]).longValue());
                        break;
                    }
                    case 'C': {
                        this.printClassObject((ClassObject)params[start], this.linePos);
                        break;
                    }
                    case 'c': {
                        this.printClassIndex((Integer)params[start], this.linePos);
                        break;
                    }
                    case 'd': {
                        this.printClassLoader((ClassLoaderObject)params[start], this.linePos);
                        break;
                    }
                    case 'D': {
                        this.printDuration(((Number)params[start]).longValue());
                        break;
                    }
                    case 'M': {
                        this.printMethodObject((MethodObject)params[start], this.linePos);
                        break;
                    }
                    case 'm': {
                        this.printMethodIndex((Integer)params[start], this.linePos);
                        break;
                    }
                    case 'L': {
                        this.printMethodLocation((MethodLocation)params[start], this.linePos);
                        break;
                    }
                    case 'l': {
                        this.printMethodLocationIndex((Integer)params[start], this.linePos);
                        break;
                    }
                    case 'S': {
                        this.printStackTrace(((Number)params[start]).intValue(), this.linePos);
                        break;
                    }
                    case 'T': {
                        if (params[start] instanceof Character) {
                            this.printThread(((Character)params[start]).charValue(), this.linePos);
                            break;
                        }
                        this.printThread(((Number)params[start]).intValue(), this.linePos);
                        break;
                    }
                    case 't': {
                        this.printTimeStampAfterStart(((Number)params[start]).longValue());
                        break;
                    }
                    case 'r': {
                        this.printRawTimeStamp(((Number)params[start]).longValue());
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                first = 1;
            }
            int curr = ++start;
            for (int j = first; j < part.length(); ++j) {
                if (part.charAt(j) == '%') {
                    if (part.charAt(j + 1) == '%') {
                        newPart.append("%%");
                        ++j;
                        continue;
                    }
                    ++curr;
                    newPart.append('%');
                    continue;
                }
                newPart.append(part.charAt(j));
            }
            Object[] newParams = new Object[curr - start];
            System.arraycopy(params, start, newParams, 0, newParams.length);
            this.formatter.format(newPart.toString(), newParams);
            start = curr;
        }
        assert (start == params.length);
    }

    @Override
    public Appendable append(char c) throws IOException {
        ++this.linePos;
        this.writer.append(c);
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        this.linePos += end - start;
        this.writer.append(csq, start, end);
        return this;
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        this.linePos += csq.length();
        this.writer.append(csq);
        return this;
    }

    private void addIndent() {
        if (this.linePos == 0) {
            for (int i = 0; i < this.indent; ++i) {
                try {
                    this.writer.append(' ');
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.linePos += this.indent;
        }
    }

    public BufferedWriter getWriter() {
        this.flush();
        return this.writer;
    }

    public void setWriter(BufferedWriter writer) {
        this.flush();
        this.writer = writer;
        this.formatter = new Formatter(writer);
    }

    public void close() {
        this.flush();
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

