/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.core;

import com.sap.jvm.profiling.core.ThreadAnnotation;
import com.sap.jvm.profiling.core.ThreadInfo;
import com.sap.jvm.profiling.core.type.UTF8Creator;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.util.misc.UTF8Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;

public final class ThreadFilter {
    public static final String NO_FILTER = "**";
    private static final Pattern orPattern = Pattern.compile("[|][|]");
    private static final Pattern equalsPattern = Pattern.compile("=");
    private boolean filterById;
    private boolean filterByName;
    private boolean filterByAnnotation;
    private HashSet<Long> threads = new HashSet();
    private HashSet<UTF8String> names = new HashSet();
    private HashMap<UTF8String, HashSet<UTF8String>> annotations = new HashMap();
    private long[] lastChangeCounts = new long[512];
    private boolean[] threadApplied = new boolean[512];

    public ThreadFilter() {
        this.updateFilterFlags();
    }

    public ThreadFilter(String filter) {
        this();
        this.parse(filter);
    }

    public static boolean isFiltering(String pattern) {
        return pattern.length() > 0 && !NO_FILTER.equals(pattern) && !"*".equals(pattern);
    }

    private static boolean isTrivialFilter(String pattern) {
        return pattern != null && (NO_FILTER.equals(pattern) || "*".equals(pattern));
    }

    public boolean isFiltering() {
        return this.filterById || this.filterByName || this.filterByAnnotation;
    }

    public String asString() {
        if (!this.isFiltering()) {
            return NO_FILTER;
        }
        StringBuilder buffer = new StringBuilder();
        this.appendThreadIds(buffer);
        if (!(this.threads.isEmpty() || this.names.isEmpty() && this.annotations.isEmpty())) {
            buffer.append(" && ");
        }
        this.appendThreadNames(buffer);
        if (!this.names.isEmpty() && !this.annotations.isEmpty()) {
            buffer.append(" && ");
        }
        this.appendThreadAnnotations(buffer);
        return buffer.toString();
    }

    public String getUserFilter() {
        HashSet<String> userValues = this.getAnnotations().get("user");
        if (userValues != null && !userValues.isEmpty()) {
            return userValues.iterator().next();
        }
        return null;
    }

    public Map<String, HashSet<String>> getAnnotations() {
        HashMap<String, HashSet<String>> result = new HashMap<String, HashSet<String>>();
        for (Map.Entry<UTF8String, HashSet<UTF8String>> entry : this.annotations.entrySet()) {
            HashSet<String> values = new HashSet<String>();
            for (UTF8String value : entry.getValue()) {
                values.add(value.toString());
            }
            result.put(entry.getKey().toString(), values);
        }
        return result;
    }

    public Long[] getThreadIds() {
        return this.threads.toArray(new Long[this.threads.size()]);
    }

    public String[] getThreadNames() {
        String[] result = new String[this.names.size()];
        int idx = 0;
        for (UTF8String name : this.names) {
            result[idx] = name.toString();
            ++idx;
        }
        return result;
    }

    public ThreadFilter copy() {
        ThreadFilter result = new ThreadFilter();
        result.threads = new HashSet<Long>(this.threads);
        result.names = new HashSet<UTF8String>(this.names);
        result.annotations = new HashMap();
        for (Map.Entry<UTF8String, HashSet<UTF8String>> entry : this.annotations.entrySet()) {
            HashSet newSet = new HashSet(entry.getValue());
            result.annotations.put(entry.getKey(), newSet);
        }
        result.updateFilterFlags();
        return result;
    }

    public void narrow(ThreadFilter threadFilter) {
        HashSet<UTF8String> tmpNames;
        HashSet<Long> tmpThreads = threadFilter.threads;
        if (tmpThreads.size() > 0) {
            this.removeThreads();
            Iterator iterator = tmpThreads.iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                this.filterThread(id);
            }
        }
        if ((tmpNames = threadFilter.names).size() > 0) {
            this.removeNames();
            for (UTF8String name : tmpNames) {
                this.filterName(name);
            }
        }
        HashMap<UTF8String, HashSet<UTF8String>> tmpAnnotations = threadFilter.annotations;
        for (Map.Entry entry : tmpAnnotations.entrySet()) {
            this.removeAnnotations(((UTF8String)entry.getKey()).toString());
            for (UTF8String value : (HashSet)entry.getValue()) {
                this.filterAnnotation(((UTF8String)entry.getKey()).toString(), value.toString());
            }
        }
        this.updateFilterFlags();
    }

    public void removeThreads() {
        this.threads = new HashSet();
        this.updateFilterFlags();
    }

    public void removeNames() {
        this.names = new HashSet();
        this.updateFilterFlags();
    }

    public void filterThread(long threadId) {
        this.threads.add(threadId);
        this.updateFilterFlags();
    }

    public void filterName(UTF8String threadName) {
        this.names.add(threadName);
        this.updateFilterFlags();
    }

    public void filterNames(UTF8String[] threadNames) {
        for (UTF8String name : threadNames) {
            this.names.add(name);
        }
        this.updateFilterFlags();
    }

    public void filterThread(long[] threadId) {
        if (threadId == null) {
            return;
        }
        for (int i = 0; i < threadId.length; ++i) {
            this.threads.add(threadId[i]);
        }
        this.updateFilterFlags();
    }

    public void filterUser(String user) {
        this.filterAnnotation("user", user);
    }

    public void filterUsers(String[] users) {
        this.filterAnnotation("user", users);
    }

    public void filterApplication(String application) {
        this.filterAnnotation("application", application);
    }

    public void filterApplications(String[] applications) {
        this.filterAnnotation("application", applications);
    }

    public void filterSession(String session) {
        this.filterAnnotation("session", session);
    }

    public void filterSessions(String[] sessions) {
        this.filterAnnotation("session", sessions);
    }

    public void filterRequest(String request) {
        this.filterAnnotation("request", request);
    }

    public void filterRequests(String[] requests) {
        this.filterAnnotation("request", requests);
    }

    public void filterTenant(String tenant) {
        this.filterAnnotation("tenant", tenant);
    }

    public void filterTenants(String[] tenants) {
        this.filterAnnotation("tenant", tenants);
    }

    public void filterAnnotation(String key, String annotationValue) {
        if (ThreadFilter.isTrivialFilter(annotationValue)) {
            return;
        }
        this.filterAnnotation(key, new String[]{annotationValue});
        this.updateFilterFlags();
    }

    public void filterAnnotation(String key, String[] annotationValues) {
        UTF8String utfKey = UTF8Creator.create(key);
        HashSet<UTF8String> filteredAnnotations = this.annotations.get(utfKey);
        if (filteredAnnotations == null) {
            HashSet<UTF8String> values = new HashSet<UTF8String>();
            for (String value : annotationValues) {
                values.add(UTF8Creator.create(value));
            }
            filteredAnnotations = new HashSet();
            this.annotations.put(utfKey, values);
        }
        boolean hasAdded = false;
        for (int i = 0; i < annotationValues.length; ++i) {
            if (ThreadFilter.isTrivialFilter(annotationValues[i])) continue;
            filteredAnnotations.add(UTF8Creator.create(annotationValues[i]));
            hasAdded = true;
        }
        if (!hasAdded) {
            this.annotations.remove(utfKey);
        }
        this.updateFilterFlags();
    }

    public void removeAnnotations(String key) {
        this.annotations.remove(UTF8Creator.create(key));
        this.updateFilterFlags();
    }

    private boolean appliesImpl(ThreadInfo threadInfo) {
        if (this.filterById && !this.threads.contains(threadInfo.getThreadId())) {
            return false;
        }
        if (this.filterByName && !this.names.contains(threadInfo.getNameUTF())) {
            return false;
        }
        if (this.filterByAnnotation) {
            for (ThreadAnnotation annotation : threadInfo.getAnnotations()) {
                HashSet<UTF8String> values = this.annotations.get(annotation.getKey());
                if (values == null || values.contains(annotation.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean applies(ThreadInfo threadInfo) {
        char index = (char)('\u0001' + threadInfo.getIndex());
        if (index < this.lastChangeCounts.length) {
            long lastChangeCount = this.lastChangeCounts[index];
            long newChangeCount = threadInfo.getNameOrAnnotationChangeCount();
            if (lastChangeCount != newChangeCount) {
                this.lastChangeCounts[index] = newChangeCount;
                this.threadApplied[index] = this.appliesImpl(threadInfo);
            }
            return this.threadApplied[index];
        }
        assert (this.lastChangeCounts.length == this.threadApplied.length);
        int newSize = Math.max(index + '\u0001', this.lastChangeCounts.length * 2);
        long[] newLastChangeCounts = new long[newSize];
        System.arraycopy(this.lastChangeCounts, 0, newLastChangeCounts, 0, this.lastChangeCounts.length);
        this.lastChangeCounts = newLastChangeCounts;
        boolean[] newThreadApplied = new boolean[newSize];
        System.arraycopy(this.threadApplied, 0, newThreadApplied, 0, this.threadApplied.length);
        this.threadApplied = newThreadApplied;
        return this.applies(threadInfo);
    }

    public int hashCode() {
        return this.threads.hashCode() ^ this.names.hashCode() ^ this.annotations.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ThreadFilter)) {
            return false;
        }
        ThreadFilter tmpFilter = (ThreadFilter)obj;
        if (!this.threads.equals(tmpFilter.threads)) {
            return false;
        }
        if (!this.names.equals(tmpFilter.names)) {
            return false;
        }
        return this.annotations.equals(tmpFilter.annotations);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Filter threads: ");
        builder.append(this.threads.toString());
        builder.append(", names: ");
        builder.append(this.names.toString());
        builder.append(", annotations: ");
        int nrOfAnnotations = this.annotations.size();
        if (nrOfAnnotations == 0) {
            builder.append("none");
        } else {
            for (Map.Entry<UTF8String, HashSet<UTF8String>> entry : this.annotations.entrySet()) {
                builder.append("[");
                builder.append(entry.getKey());
                builder.append(": ");
                Iterator<UTF8String> itValues = entry.getValue().iterator();
                while (itValues.hasNext()) {
                    builder.append(itValues.next());
                    if (!itValues.hasNext()) continue;
                    builder.append(",");
                }
                builder.append("]");
            }
        }
        return builder.toString();
    }

    private void appendThreadIds(StringBuilder buffer) {
        if (this.threads.isEmpty()) {
            return;
        }
        boolean firstEntry = true;
        if (this.threads.size() > 1) {
            buffer.append("(");
        }
        for (Long nextTid : this.threads) {
            if (!firstEntry) {
                buffer.append(" || ");
            }
            buffer.append("tid=").append(nextTid);
            firstEntry = false;
        }
        if (this.threads.size() > 1) {
            buffer.append(")");
        }
    }

    private void appendThreadNames(StringBuilder buffer) {
        if (this.names.isEmpty()) {
            return;
        }
        boolean firstEntry = true;
        if (this.names.size() > 1) {
            buffer.append("(");
        }
        for (UTF8String nextThreadName : this.names) {
            if (!firstEntry) {
                buffer.append(" || ");
            }
            buffer.append("tname=").append(UTF8Util.asString(nextThreadName.getBytes()));
            firstEntry = false;
        }
        if (this.names.size() > 1) {
            buffer.append(")");
        }
    }

    private void appendThreadAnnotations(StringBuilder buffer) {
        if (this.annotations.isEmpty()) {
            return;
        }
        boolean firstEntry = true;
        for (Map.Entry<UTF8String, HashSet<UTF8String>> nextEntry : this.annotations.entrySet()) {
            if (!firstEntry) {
                buffer.append(" && ");
            }
            if (nextEntry.getValue().size() > 1) {
                buffer.append("(");
            }
            boolean firstValue = true;
            for (UTF8String nextValue : nextEntry.getValue()) {
                if (!firstValue) {
                    buffer.append(" || ");
                }
                buffer.append(nextEntry.getKey()).append("=").append(nextValue);
                firstValue = false;
            }
            if (nextEntry.getValue().size() > 1) {
                buffer.append(")");
            }
            firstEntry = false;
        }
    }

    private void updateFilterFlags() {
        this.filterById = this.threads.size() > 0;
        this.filterByName = this.names.size() > 0;
        this.filterByAnnotation = this.annotations.size() > 0;
    }

    private void parse(String filter) {
        if (filter.equals("*") || filter.equals(NO_FILTER)) {
            return;
        }
        String[] filterParts = filter.split("&&");
        for (int i = 0; i < filterParts.length; ++i) {
            FilterPartType type = this.getFilterPartType(filterParts[i]);
            if (type == FilterPartType.THREAD_ID) {
                this.parseThreadIds(filterParts[i]);
            } else if (type == FilterPartType.THREAD_NAME) {
                this.parseThreadNames(filterParts[i]);
            }
            this.parseThreadAnnotations(filterParts[i]);
        }
    }

    private FilterPartType getFilterPartType(String filterPart) {
        if (filterPart.contains("tid")) {
            return FilterPartType.THREAD_ID;
        }
        if (filterPart.contains("tname")) {
            return FilterPartType.THREAD_NAME;
        }
        return FilterPartType.THREAD_ANNOTATION;
    }

    private void parseThreadIds(String filterPart) {
        String tmpFilterPart = filterPart.trim();
        if (tmpFilterPart.charAt(0) == '(') {
            tmpFilterPart = tmpFilterPart.substring(1, tmpFilterPart.length() - 2);
        }
        String[] tidParts = orPattern.split(tmpFilterPart);
        for (int i = 0; i < tidParts.length; ++i) {
            String current = tidParts[i].trim();
            assert (current.startsWith("tid="));
            String tidString = current.substring(4).trim();
            long threadId = Long.valueOf(tidString);
            this.threads.add(threadId);
        }
        this.updateFilterFlags();
    }

    private void parseThreadNames(String filterPart) {
        String tmpFilterPart = filterPart.trim();
        if (tmpFilterPart.charAt(0) == '(') {
            tmpFilterPart = tmpFilterPart.substring(1, tmpFilterPart.length() - 2);
        }
        String[] tnameParts = orPattern.split(tmpFilterPart);
        for (int i = 0; i < tnameParts.length; ++i) {
            String current = tnameParts[i].trim();
            assert (current.startsWith("tname="));
            String tnameString = current.substring(4).trim();
            this.names.add(UTF8Creator.create(tnameString));
        }
        this.updateFilterFlags();
    }

    private void parseThreadAnnotations(String filterPart) {
        String tmpFilterPart = filterPart.trim();
        if (tmpFilterPart.charAt(0) == '(') {
            tmpFilterPart = tmpFilterPart.substring(1, tmpFilterPart.length() - 2);
        }
        String[] tannotationParts = orPattern.split(tmpFilterPart);
        for (int i = 0; i < tannotationParts.length; ++i) {
            String current = tannotationParts[i].trim();
            String[] currentParts = equalsPattern.split(current, 2);
            assert (currentParts.length == 2);
            UTF8String key = UTF8Creator.create(currentParts[0].trim());
            String value = currentParts[1].trim();
            HashSet<UTF8String> values = this.annotations.get(key);
            if (values == null) {
                values = new HashSet();
                this.annotations.put(key, values);
            }
            values.add(UTF8Creator.create(value));
        }
        this.updateFilterFlags();
    }

    static enum FilterPartType {
        THREAD_ID,
        THREAD_NAME,
        THREAD_ANNOTATION;

    }
}

