/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.core.command;

public enum ProfilingSessionType {
    TYPE_PROFILING_CONTROL_COMMAND_LINE(0, "Profiling Control started by command line arguments"),
    TYPE_PROFILING_CONTROL_GC_HISTORY(1, "Profiling Control of GC history file"),
    TYPE_PROFILING_CONTROL_MONITORING_HISTORY(2, "Profiling Control of Monitoring file"),
    TYPE_PROFILING_CONTROL_JVMPROF(3, "Profiling Control of JvmProf"),
    TYPE_PROFILING_CONTROL_DEBUGGING(4, "Profiling Control of an attached SAP JVM Profiler via debugging"),
    TYPE_PROFILING_CONTROL_PROFILINGSERVER(5, "Profiling Control of an attached SAP JVM Profiler via Profiling Server"),
    TYPE_PROFILING_CONTROL_FILE(6, "Profiling Control of a profiling session created within the same SAP JVM"),
    TYPE_SILENCE_COMPILER(7, "unknown");

    private final int id;
    private final String description;

    private ProfilingSessionType(int id, String description) {
        this.id = id;
        this.description = description;
    }

    public int getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public static ProfilingSessionType getProfilingTraceType(int id) throws IndexOutOfBoundsException {
        ProfilingSessionType[] values = ProfilingSessionType.values();
        if (id >= 0 && id < values.length - 1) {
            return values[id];
        }
        throw new IndexOutOfBoundsException("invalid enum id " + id + " passed");
    }
}

