/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.core.event;

import com.sap.jvm.profiling.impl.alert.event.StorableAlertImpl;

public class StorableAlertSummary {
    private final int type;
    private final int count;
    private final double firstOccurance;
    private final double lastOccurance;
    private final String lastInfo;

    public StorableAlertSummary(int type, int count, double firstOccurance, double lastOccurance, String lastInfo) {
        this.type = type;
        this.count = count;
        this.firstOccurance = firstOccurance;
        this.lastOccurance = lastOccurance;
        this.lastInfo = lastInfo;
    }

    public int getType() {
        return this.type;
    }

    public int getCount() {
        return this.count;
    }

    public int getSeverity() {
        return StorableAlertImpl.getSeverityForType(this.type);
    }

    public String getDescription() {
        return StorableAlertImpl.getDescriptionForType(this.type);
    }

    public String getToolTip() {
        return StorableAlertImpl.getToolTipForType(this.type);
    }

    public double getFirstOccuranceTime() {
        return this.firstOccurance;
    }

    public double getLastOccuranceTime() {
        return this.lastOccurance;
    }

    public String getLastOccuranceInfo() {
        return this.lastInfo;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StorableAlertSummary) {
            StorableAlertSummary other = (StorableAlertSummary)obj;
            return this.type == other.type && this.count == other.count && this.firstOccurance == other.firstOccurance && this.lastOccurance == other.lastOccurance && this.lastInfo.equals(other.lastInfo);
        }
        return false;
    }

    public int hashCode() {
        return this.type ^ this.count * 31 ^ Double.valueOf(this.firstOccurance).hashCode() ^ Double.valueOf(this.lastOccurance).hashCode() ^ this.lastInfo.hashCode();
    }
}

