/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.core.type;

import com.sap.jvm.profiling.SessionAssociated;
import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.NonArrayClassObject;
import com.sap.jvm.profiling.core.type.UTF8String;

public interface MethodObject
extends SessionAssociated {
    public long getId();

    public int getIndex();

    public NonArrayClassObject getMethodClass();

    public MethodLocation asMethodLocation();

    public String getName();

    public UTF8String getNameUTF();

    public String getFullName();

    public String getFullNameWithoutReturnType();

    public String getSignature();

    public UTF8String getSignatureUTF();

    public String getReturnType();

    public UTF8String getReturnTypeUTF();

    public boolean isNative();

    public boolean isPublic();

    public boolean isProtected();

    public boolean isPrivate();

    public boolean isPackagePrivate();

    public boolean hasUnknownVisibility();

    public boolean isAbstract();

    public boolean isStatic();

    public boolean isStaticallyCallable();

    public boolean isOverwriting();

    public boolean isSynthetic();

    public boolean isSynchronized();

    public boolean isStrict();

    public boolean isFinal();

    public boolean isEmpty();

    public boolean isVanillaConstructor();

    public boolean hasLoops();

    public boolean hasJsrs();

    public boolean hasMonitors();

    public boolean isAccessor();

    public boolean isDelegator();

    public boolean isBoundJRubyMethod();

    public UTF8String[] getBoundJRubyMethods();

    public boolean isNoStack();

    public boolean isInlinedAway();

    public int compareTo(MethodObject var1);

    public int compareToIgnoreCase(MethodObject var1);

    public int compareByIndex(MethodObject var1);

    public boolean isProfilingMethod();

    public int getDefinitionLine();

    public int getDefinitionColumn();
}

