/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.core.type;

import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.EOFException;
import java.io.IOException;
import java.util.Comparator;

public final class MonitorObject
implements Comparable<MonitorObject> {
    private final long objectId;
    private final ClassObject clazz;
    private final long clazzId;
    private static final Comparator<MonitorObject> comparator = new Comparator<MonitorObject>(){

        @Override
        public int compare(MonitorObject o1, MonitorObject o2) {
            return o1.compareTo(o2);
        }
    };

    public MonitorObject(long objectId, ClassObject clazz) {
        this.objectId = objectId;
        this.clazz = clazz;
        this.clazzId = clazz != null ? (long)clazz.getIndex() : 0L;
    }

    public MonitorObject(long objectId, long clazzId) {
        this.objectId = objectId;
        this.clazz = null;
        this.clazzId = clazzId;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public ClassObject getClassObject() {
        return this.clazz;
    }

    public long getClazzId() {
        return this.clazzId;
    }

    public String toString() {
        return "object monitor with id " + this.objectId + " of type " + this.clazz.toString();
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt64(this.objectId);
        writer.writeClassObject(this.clazz);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
        result = 31 * result + (int)(this.objectId ^ this.objectId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MonitorObject) {
            MonitorObject other = (MonitorObject)obj;
            if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
                return false;
            }
            return this.objectId == other.objectId;
        }
        return false;
    }

    public static MonitorObject read(ResourceReader reader) throws EOFException {
        long objectId = reader.readInt64();
        ClassObject clazz = reader.readClassObject();
        return new MonitorObject(objectId, clazz);
    }

    @Override
    public int compareTo(MonitorObject o) {
        int i2;
        if (this.objectId < o.objectId) {
            return -1;
        }
        if (this.objectId > o.objectId) {
            return 1;
        }
        if (this.clazz == null) {
            if (o.clazz == null) {
                return 0;
            }
            return -1;
        }
        if (o.clazz == null) {
            return 1;
        }
        int i1 = this.clazz.getIndex();
        return i1 < (i2 = o.clazz.getIndex()) ? -1 : (i1 > i2 ? 1 : 0);
    }

    public static Comparator<MonitorObject> getComparator() {
        return comparator;
    }
}

