/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.core.type;

import com.sap.jvm.profiling.i18n.I18n;

public enum MonitorObjectUsage {
    UNKNOWN(0, I18n._ts(I18n.TextType.XMSG, "Unknown"), I18n._ts(I18n.TextType.XMSG, "unknown"), "unknown"),
    WAITING(1, I18n._ts(I18n.TextType.XMSG, "Entry for an object the thread is waiting for"), I18n._ts(I18n.TextType.XMSG, "waiting for"), "waiting"),
    BLOCKED(2, I18n._ts(I18n.TextType.XMSG, "Entry for an object the thread is trying to get the lock"), I18n._ts(I18n.TextType.XMSG, "blocked on"), "blocked"),
    LOCKED(3, I18n._ts(I18n.TextType.XMSG, "Entry for an object the thread has locked"), I18n._ts(I18n.TextType.XMSG, "locked"), "locked");

    private final String description;
    private final String usageText;
    private final String tag;
    private final int value;

    private MonitorObjectUsage(int value, String description, String usageText, String tag) {
        this.value = value;
        this.description = description;
        this.usageText = usageText;
        this.tag = tag;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUsageText() {
        return this.usageText;
    }

    public String getTag() {
        return this.tag;
    }

    public static MonitorObjectUsage getMonitorUsage(int value) {
        MonitorObjectUsage[] usages = MonitorObjectUsage.values();
        if (value >= 0 && value < usages.length && usages[value].value == value) {
            return usages[value];
        }
        for (int i = 0; i < usages.length; ++i) {
            if (usages[i].value != value) continue;
            return usages[i];
        }
        throw new IllegalArgumentException("Unknown monitor object usage: " + value);
    }
}

