/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.i18n;

import com.sap.jvm.profiling.i18n.DurationFormat;
import com.sap.jvm.profiling.i18n.DurationFormatter;
import com.sap.jvm.profiling.i18n.I18n;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DataFormatter {
    public static final String UNIT_SEP = I18n.sanitize("\u2009");
    public static final String UNIT_SEP_THIN = I18n.sanitize("\u200a");
    private static final long k = 1024L;
    private static final long M = 0x100000L;
    private static final long G = 0x40000000L;
    private static final long T = 0x10000000000L;
    private static final long P = 0x4000000000000L;
    private static final long[] bytesScale = new long[]{1L, 1024L, 0x100000L, 0x40000000L, 0x10000000000L, 0x4000000000000L};
    private static final long[] normalScale = new long[]{1L, 1000L, 1000000L, 1000000000L, 1000000000000L, 1000000000000000L};
    private static final String bStr = UNIT_SEP + I18n._ss("Unit|bytes", "B");
    private static final String kStr = UNIT_SEP + I18n._ss("Unit|kilo bytes", "KB");
    private static final String mStr = UNIT_SEP + I18n._ss("Unit|mega bytes", "MB");
    private static final String gStr = UNIT_SEP + I18n._ss("Unit|giga bytes", "GB");
    private static final String tStr = UNIT_SEP + I18n._ss("Unit|tera bytes", "TB");
    private static final String pStr = UNIT_SEP + I18n._ss("Unit|peta bytes", "PB");
    private static final String bPsStr = UNIT_SEP + I18n._ss("Unit|bytes per second", "B/s");
    private static final String kPsStr = UNIT_SEP + I18n._ss("Unit|kilo bytes per second", "KB/s");
    private static final String mPsStr = UNIT_SEP + I18n._ss("Unit|mega bytes per second", "MB/s");
    private static final String gPsStr = UNIT_SEP + I18n._ss("Unit|giga bytes per second", "GB/s");
    private static final String tPsStr = UNIT_SEP + I18n._ss("Unit|tera bytes per second", "TB/s");
    private static final String pPsStr = UNIT_SEP + I18n._ss("Unit|peta bytes per second", "PB/s");
    private static final String[] bytesUnit = new String[]{bStr, kStr, mStr, gStr, tStr, pStr};
    private static final String[] bytesPerSecondUnit = new String[]{bPsStr, kPsStr, mPsStr, gPsStr, tPsStr, pPsStr};
    private static final String[] hzUnit = new String[]{"Hz", "kHz", "MHz", "GHz", "THz", "PHz"};
    private static NumberFormat integerFormat;
    private static NumberFormat twoFractionDigits;
    private static NumberFormat oneFractionDigit;
    private static NumberFormat nFractionDigits;
    private static DateFormat timeStampFormat;
    private static DateFormat timeStampTime;
    private static DateFormat timeStampTimeNoSeconds;
    private static DateFormat timeStampDate;
    private static DateFormat longFormat;
    private static SimpleDateFormat millisFormat;
    private static DurationFormatter adaptive;
    private static DurationFormatter hhmmss;
    private static DurationFormatter microsFull;
    private static FieldPosition fieldSeconds;
    private static TimeZone lastTimeZone;
    private static Object timeZoneLock;

    private static void initFormatters(Locale loc) {
        integerFormat = NumberFormat.getIntegerInstance(loc);
        twoFractionDigits = NumberFormat.getNumberInstance(loc);
        twoFractionDigits.setMaximumFractionDigits(2);
        twoFractionDigits.setMinimumFractionDigits(2);
        oneFractionDigit = NumberFormat.getNumberInstance(loc);
        oneFractionDigit.setMaximumFractionDigits(1);
        oneFractionDigit.setMinimumFractionDigits(1);
        nFractionDigits = NumberFormat.getNumberInstance(loc);
        timeStampFormat = DateFormat.getDateTimeInstance(3, 3, loc);
        timeStampTime = DateFormat.getTimeInstance(2, loc);
        timeStampTimeNoSeconds = DateFormat.getTimeInstance(3, loc);
        timeStampDate = DateFormat.getDateInstance(3, loc);
        longFormat = DateFormat.getDateTimeInstance(1, 1, loc);
        adaptive = new DurationFormatter(DurationFormat.GLOBAL_TOTAL_ADAPITVE);
        hhmmss = new DurationFormatter(DurationFormat.HH_MM_SS);
        microsFull = new DurationFormatter(DurationFormat.FULL_TO_MICROS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNrOfBytesText(long nrOfBytes, long base) {
        long absValue = Math.abs(base);
        for (int i = 1; i < bytesScale.length; ++i) {
            if (absValue < 1000L * bytesScale[i - 1]) {
                NumberFormat numberFormat = integerFormat;
                synchronized (numberFormat) {
                    return integerFormat.format((double)nrOfBytes / (double)bytesScale[i - 1]) + bytesUnit[i - 1];
                }
            }
            if (absValue < 10L * bytesScale[i]) {
                NumberFormat numberFormat = twoFractionDigits;
                synchronized (numberFormat) {
                    return twoFractionDigits.format((double)nrOfBytes / (double)bytesScale[i]) + bytesUnit[i];
                }
            }
            if (absValue >= 100L * bytesScale[i]) continue;
            NumberFormat numberFormat = oneFractionDigit;
            synchronized (numberFormat) {
                return oneFractionDigit.format((double)nrOfBytes / (double)bytesScale[i]) + bytesUnit[i];
            }
        }
        NumberFormat numberFormat = integerFormat;
        synchronized (numberFormat) {
            return integerFormat.format((double)nrOfBytes / (double)bytesScale[bytesScale.length - 1]) + bytesUnit[bytesScale.length - 1];
        }
    }

    public static String getNrOfBytesText(long nrOfBytes) {
        return DataFormatter.getNrOfBytesText(nrOfBytes, nrOfBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNrOfBytesPerSecondText(long nrOfBytes) {
        long absValue = Math.abs(nrOfBytes);
        for (int i = 1; i < bytesScale.length; ++i) {
            if (absValue < 1000L * bytesScale[i - 1]) {
                NumberFormat numberFormat = integerFormat;
                synchronized (numberFormat) {
                    return integerFormat.format((double)nrOfBytes / (double)bytesScale[i - 1]) + bytesPerSecondUnit[i - 1];
                }
            }
            if (absValue < 10L * bytesScale[i]) {
                NumberFormat numberFormat = twoFractionDigits;
                synchronized (numberFormat) {
                    return twoFractionDigits.format((double)nrOfBytes / (double)bytesScale[i]) + bytesPerSecondUnit[i];
                }
            }
            if (absValue >= 100L * bytesScale[i]) continue;
            NumberFormat numberFormat = oneFractionDigit;
            synchronized (numberFormat) {
                return oneFractionDigit.format((double)nrOfBytes / (double)bytesScale[i]) + bytesPerSecondUnit[i];
            }
        }
        NumberFormat numberFormat = integerFormat;
        synchronized (numberFormat) {
            return integerFormat.format((double)nrOfBytes / (double)bytesScale[bytesScale.length - 1]) + bytesPerSecondUnit[bytesScale.length - 1];
        }
    }

    public static String getFrequencyText(long frequency) {
        return DataFormatter.getNumberText(frequency, hzUnit);
    }

    public static String getNumberText(long value, String[] unitNames) {
        return DataFormatter.getNumberText(value, value, unitNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNumberText(long value, long base, String[] unitNames) {
        long absValue = Math.abs(base);
        for (int i = 1; i < normalScale.length; ++i) {
            if (absValue < 1000L * normalScale[i - 1]) {
                NumberFormat numberFormat = integerFormat;
                synchronized (numberFormat) {
                    return integerFormat.format((double)value / (double)normalScale[i - 1]) + " " + unitNames[i - 1];
                }
            }
            if (absValue < 10L * bytesScale[i]) {
                NumberFormat numberFormat = twoFractionDigits;
                synchronized (numberFormat) {
                    return twoFractionDigits.format((double)value / (double)normalScale[i]) + " " + unitNames[i];
                }
            }
            if (absValue >= 100L * bytesScale[i]) continue;
            NumberFormat numberFormat = oneFractionDigit;
            synchronized (numberFormat) {
                return oneFractionDigit.format((double)value / (double)normalScale[i]) + " " + unitNames[i];
            }
        }
        NumberFormat numberFormat = integerFormat;
        synchronized (numberFormat) {
            return integerFormat.format((double)value / (double)normalScale[normalScale.length - 1]) + " " + unitNames[normalScale.length - 1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNumberText(long number) {
        NumberFormat numberFormat = integerFormat;
        synchronized (numberFormat) {
            return integerFormat.format(number);
        }
    }

    public static String getNumberText(double number) {
        double abs = Math.abs(number);
        if (abs >= 100.0) {
            return DataFormatter.getNumberText(number, 0);
        }
        if (abs >= 10.0) {
            return DataFormatter.getNumberText(number, 1);
        }
        return DataFormatter.getNumberText(number, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNumberText(double number, int fractionDigits) {
        NumberFormat numberFormat = nFractionDigits;
        synchronized (numberFormat) {
            nFractionDigits.setMaximumFractionDigits(fractionDigits);
            nFractionDigits.setMinimumFractionDigits(fractionDigits);
            return nFractionDigits.format(number);
        }
    }

    public static String getUnitText(long number, String unit) {
        if (unit.length() == 0) {
            return DataFormatter.getNumberText(number);
        }
        return DataFormatter.getNumberText(number) + UNIT_SEP + unit;
    }

    public static String getUnitText(double number, int fractionDigits, String unit) {
        if (unit.length() == 0) {
            return DataFormatter.getNumberText(number, fractionDigits);
        }
        return DataFormatter.getNumberText(number, fractionDigits) + UNIT_SEP + unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPercentage(double percentage) {
        String pAsString;
        double p;
        boolean isNegative = false;
        if (percentage < 0.0) {
            isNegative = true;
            p = 100.0 * -percentage;
        } else {
            p = 100.0 * percentage;
        }
        if (p < 10.0) {
            NumberFormat numberFormat = twoFractionDigits;
            synchronized (numberFormat) {
                pAsString = twoFractionDigits.format(p);
            }
        }
        if (p < 100.0) {
            NumberFormat numberFormat = oneFractionDigit;
            synchronized (numberFormat) {
                pAsString = oneFractionDigit.format(p);
            }
        }
        NumberFormat numberFormat = integerFormat;
        synchronized (numberFormat) {
            pAsString = integerFormat.format(p);
        }
        if (isNegative) {
            return I18n._s("- {0}{1}%", pAsString, UNIT_SEP);
        }
        return I18n._s("{0}{1}%", pAsString, UNIT_SEP);
    }

    public static String getPercentage(double percentage, int nrOfDigits) {
        double p;
        boolean isNegative = false;
        if (percentage < 0.0) {
            isNegative = true;
            p = 100.0 * -percentage;
        } else {
            p = 100.0 * percentage;
        }
        String pAsString = DataFormatter.getNumberText(p, nrOfDigits);
        if (isNegative) {
            return I18n._s("- {0}{1}%", pAsString, UNIT_SEP);
        }
        return I18n._s("{0}{1}%", pAsString, UNIT_SEP);
    }

    private static void updateTimeZone(TimeZone tz) {
        if (tz != lastTimeZone) {
            timeStampFormat.setTimeZone(tz);
            timeStampTime.setTimeZone(tz);
            timeStampTimeNoSeconds.setTimeZone(tz);
            timeStampDate.setTimeZone(tz);
            longFormat.setTimeZone(tz);
            lastTimeZone = tz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimeStamp(long ts, TimeZone tz) {
        Object object = timeZoneLock;
        synchronized (object) {
            DataFormatter.updateTimeZone(tz);
            return timeStampFormat.format(new Date(ts));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimeStampSeconds(long ts, TimeZone tz) {
        StringBuilder result = new StringBuilder();
        Date date = new Date(ts);
        Object object = timeZoneLock;
        synchronized (object) {
            DataFormatter.updateTimeZone(tz);
            result.append(timeStampDate.format(date));
            result.append(" ");
            result.append(timeStampTime.format(date));
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimeStampTime(long ts, TimeZone tz) {
        Object object = timeZoneLock;
        synchronized (object) {
            DataFormatter.updateTimeZone(tz);
            return timeStampTime.format(new Date(ts));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimeStampTimeNoSeconds(long ts, TimeZone tz) {
        Object object = timeZoneLock;
        synchronized (object) {
            DataFormatter.updateTimeZone(tz);
            return timeStampTimeNoSeconds.format(new Date(ts));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimeStampDate(long ts, TimeZone tz) {
        Object object = timeZoneLock;
        synchronized (object) {
            DataFormatter.updateTimeZone(tz);
            return timeStampDate.format(new Date(ts));
        }
    }

    public static String getTimeStampDetailed(long ts, TimeZone tz) {
        return DataFormatter.getTimeStampDate(ts, tz) + " " + DataFormatter.getTimeStampTimeDetailed(ts, tz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimeStampLong(long ts, TimeZone tz) {
        Object object = timeZoneLock;
        synchronized (object) {
            DataFormatter.updateTimeZone(tz);
            return longFormat.format(new Date(ts));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimeStampTimeDetailed(long ts, TimeZone tz) {
        StringBuffer result = new StringBuffer();
        Object object = timeZoneLock;
        synchronized (object) {
            DataFormatter.updateTimeZone(tz);
            timeStampTime.format(new Date(ts), result, fieldSeconds);
            result.insert(fieldSeconds.getEndIndex(), millisFormat.format(ts));
        }
        return result.toString();
    }

    public static String getMillisDurationTextHMS(long durationMs) {
        return hhmmss.getDurationAsString(durationMs * 1000L * 1000L);
    }

    public static String getSecondsDurationAsTwoUnits(long durationInSeconds) {
        if (durationInSeconds < 3600L) {
            long minutes = durationInSeconds / 60L;
            long seconds = durationInSeconds - minutes * 60L;
            return I18n.formatText(DurationFormatter.mPattern, "", minutes, seconds);
        }
        long durationMinutes = durationInSeconds / 60L;
        if (durationMinutes < 1440L) {
            long hours = durationMinutes / 60L;
            long minutes = durationMinutes - hours * 60L;
            return I18n.formatText(DurationFormatter.hPattern, "", hours, minutes);
        }
        long durationHours = durationMinutes / 60L;
        long days = durationHours / 24L;
        long hours = durationHours - days * 24L;
        return I18n.formatText(DurationFormatter.dPattern, "", days, hours);
    }

    public static String[] getSecondsDurationAsTwoSplitUnits(long durationInSeconds, long base) {
        if (base < 3600L) {
            long minutes = durationInSeconds / 60L;
            long seconds = durationInSeconds - minutes * 60L;
            return new String[]{minutes + UNIT_SEP_THIN + DurationFormatter.mUnit, seconds + UNIT_SEP_THIN + DurationFormatter.sUnit};
        }
        long durationMinutes = durationInSeconds / 60L;
        if (base < 86400L) {
            long hours = durationMinutes / 60L;
            long minutes = durationMinutes - hours * 60L;
            return new String[]{hours + UNIT_SEP_THIN + DurationFormatter.hUnit, minutes + UNIT_SEP_THIN + DurationFormatter.mUnit};
        }
        long durationHours = durationMinutes / 60L;
        long days = durationHours / 24L;
        long hours = durationHours - days * 24L;
        return new String[]{days + UNIT_SEP_THIN + DurationFormatter.dUnit, hours + UNIT_SEP_THIN + DurationFormatter.hUnit};
    }

    public static String getMillisDurationText(long milliseconds) {
        return adaptive.getDurationAsString(milliseconds * 1000000L);
    }

    public static String getMicrosDurationText(long microseconds) {
        return adaptive.getDurationAsString(microseconds * 1000L);
    }

    public static String getMicrosDurationTextFull(long microseconds) {
        return microsFull.getDurationAsString(microseconds * 1000L);
    }

    public static String getMicrosDurationText(long microseconds, long base) {
        return adaptive.getDurationAsString(microseconds * 1000L, base * 1000L);
    }

    public static String getNanosDurationText(long nanoseconds) {
        return adaptive.getDurationAsString(nanoseconds, nanoseconds);
    }

    public static void main(String[] args) {
        Date date = new Date();
        long ts = date.getTime();
        TimeZone tz = TimeZone.getDefault();
        DataFormatter.initFormatters(Locale.GERMAN);
        System.out.println("Time stamp formats (german locale):");
        System.out.println("===================================");
        System.out.println("\njust time:");
        System.out.println("  getTimeStampTimeNoSeconds (short, no seconds):     " + DataFormatter.getTimeStampTimeNoSeconds(ts, tz));
        System.out.println("  getTimeStampTime (normal):                         " + DataFormatter.getTimeStampTime(ts, tz));
        System.out.println("  getTimeStampTimeDetailed (including millis):       " + DataFormatter.getTimeStampTimeDetailed(ts, tz));
        System.out.println("\njust date:");
        System.out.println("  getTimeStampDate (short date):                     " + DataFormatter.getTimeStampDate(ts, tz));
        System.out.println("\nfull time stamp:");
        System.out.println("  getTimeStamp (short date, short time):             " + DataFormatter.getTimeStamp(ts, tz));
        System.out.println("  getTimeStampSeconds (short date, normal time):     " + DataFormatter.getTimeStampSeconds(ts, tz));
        System.out.println("  getTimeStampDetailed (normal date, detailed time): " + DataFormatter.getTimeStampDetailed(ts, tz));
        System.out.println("  getTimeStampLong (long date and time):             " + DataFormatter.getTimeStampLong(ts, tz));
        DataFormatter.initFormatters(Locale.US);
        System.out.println("\nTime stamp formats (US locale):");
        System.out.println("===================================");
        System.out.println("\njust time:");
        System.out.println("  getTimeStampTimeNoSeconds (short, no seconds):     " + DataFormatter.getTimeStampTimeNoSeconds(ts, tz));
        System.out.println("  getTimeStampTime (normal):                         " + DataFormatter.getTimeStampTime(ts, tz));
        System.out.println("  getTimeStampTimeDetailed (including millis):       " + DataFormatter.getTimeStampTimeDetailed(ts, tz));
        System.out.println("\njust date:");
        System.out.println("  getTimeStampDate (short date):                     " + DataFormatter.getTimeStampDate(ts, tz));
        System.out.println("\nfull time stamp:");
        System.out.println("  getTimeStamp (short date, short time):             " + DataFormatter.getTimeStamp(ts, tz));
        System.out.println("  getTimeStampSeconds (short date, normal time):     " + DataFormatter.getTimeStampSeconds(ts, tz));
        System.out.println("  getTimeStampDetailed (normal date, detailed time): " + DataFormatter.getTimeStampDetailed(ts, tz));
        System.out.println("  getTimeStampLong (long date and time):             " + DataFormatter.getTimeStampLong(ts, tz));
    }

    static {
        millisFormat = new SimpleDateFormat(".SSS");
        fieldSeconds = new FieldPosition(7);
        lastTimeZone = null;
        timeZoneLock = new Object();
        Locale loc = I18n.getLocale();
        DataFormatter.initFormatters(loc);
    }
}

