/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.i18n;

import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.i18n.DurationFormat;
import com.sap.jvm.profiling.i18n.I18n;
import java.text.NumberFormat;

public class DurationFormatter {
    private static final long NANO_SCALE = 1L;
    private static final long MICRO_SCALE = 1000L;
    private static final long MILLI_SCALE = 1000000L;
    private static final long SECOND_SCALE = 1000000000L;
    private static final long MINUTE_SCALE = 60000000000L;
    private static final long HOUR_SCALE = 3600000000000L;
    private static final long DAY_SCALE = 86400000000000L;
    private static final long YEAR_SCALE = 31536000000000000L;
    private static final int DAY = 86400000;
    private static final int HOUR = 3600000;
    private static final int MINUTE = 60000;
    private static final int SECONDS = 1000;
    private static final int NANOS_PER_MILLI = 1000000;
    private final NumberFormat integerFormat;
    private final NumberFormat percentageFormat;
    private final NumberFormat durationFormat1;
    private final NumberFormat durationFormat2;
    private final DurationFormat format;
    static final String nsUnit = I18n._ss("Unit|nanoseconds", "ns");
    static final String usUnit = I18n._ss("Unit|microseconds", "\u00b5s");
    static final String msUnit = I18n._ss("Unit|milliseconds", "ms");
    static final String sUnit = I18n._ss("Unit|seconds", "s");
    static final String mUnit = I18n._ss("Unit|minutes", "m");
    static final String hUnit = I18n._ss("Unit|hours", "h");
    static final String dUnit = I18n._ss("Unit|days", "d");
    static final String yUnit = I18n._ss("Unit|years", "y");
    static final String sPattern = I18n._ss("DurationFormat|sign_sec_ms", "{0}{1,number}\u200as\u2002{2,number}\u200ams");
    static final String sPattern_zero = I18n._ss("DurationFormat|sign_ms", "{0}{1,number}\u200ams");
    static final String mPattern = I18n._ss("DurationFormat|sign_min_sec", "{0}{1,number}\u200am\u2002{2,number}\u200as");
    static final String mPattern_zero = I18n._ss("DurationFormat|sign_sec", "{0}{1,number}\u200as");
    static final String hPattern = I18n._ss("DurationFormat|sign_hr_min", "{0}{1,number}\u200ah\u2002{2,number}\u200am");
    static final String hPattern_zero = I18n._ss("DurationFormat|sign_min", "{0}{1,number}\u200am");
    static final String dPattern = I18n._ss("DurationFormat|sign_day_hr", "{0}{1,number}\u200ad\u2002{2,number}\u200ah");
    static final String dPattern_zero = I18n._ss("DurationFormat|sign_hr", "{0}{1,number}\u200ah");
    static final String dhhmmPattern = I18n._ss("DurationFormat|sign_day_hr_min", "{0}{1,number}\u200ad\u2002{2,number,00}:{3,number,00}");
    static final String hhmmssPattern = I18n._ss("DurationFormat|sign_hr:min:sec", "{0}{1,number,00}:{2,number,00}:{3,number,00}");

    public DurationFormatter(DurationFormat format) {
        this.format = format;
        this.integerFormat = NumberFormat.getInstance(I18n.getLocale());
        this.percentageFormat = NumberFormat.getPercentInstance(I18n.getLocale());
        this.percentageFormat.setMinimumFractionDigits(2);
        this.percentageFormat.setMaximumFractionDigits(2);
        this.durationFormat1 = NumberFormat.getInstance(I18n.getLocale());
        this.durationFormat1.setMinimumFractionDigits(1);
        this.durationFormat1.setMaximumFractionDigits(1);
        this.durationFormat2 = NumberFormat.getInstance(I18n.getLocale());
        this.durationFormat2.setMinimumFractionDigits(2);
        this.durationFormat2.setMaximumFractionDigits(2);
    }

    public final String getDurationAsString(long duration) {
        return this.getDurationAsString(duration, duration);
    }

    public final String getDurationAsString(long duration, long maxDuration) {
        if (this.format == DurationFormat.TOTAL_ADAPITVE || this.format == DurationFormat.GLOBAL_TOTAL_ADAPITVE || this.format == DurationFormat.BEST_UNIT || this.format == DurationFormat.GLOBAL_BEST_UNIT) {
            long baseDuration;
            long l = baseDuration = this.format == DurationFormat.GLOBAL_BEST_UNIT || this.format == DurationFormat.GLOBAL_TOTAL_ADAPITVE ? maxDuration : duration;
            if (baseDuration <= 0L) {
                baseDuration = Math.abs(duration);
            }
            if ((this.format == DurationFormat.TOTAL_ADAPITVE || this.format == DurationFormat.GLOBAL_TOTAL_ADAPITVE) && baseDuration > 60000000000L) {
                return this.getDurationAdaptive(duration, baseDuration);
            }
            if (baseDuration >= 1000000000L) {
                return this.getDurationAsSeconds(duration, baseDuration, false);
            }
            if (baseDuration >= 1000000L) {
                return this.getDurationAsMilliseconds(duration, baseDuration, false);
            }
            if (baseDuration >= 1000L) {
                return this.getDurationAsMicroseconds(duration, baseDuration, false);
            }
            return this.getDurationAsNanoseconds(duration, baseDuration);
        }
        if (this.format == DurationFormat.HH_MM_SS) {
            return this.getDurationHHMMSS(duration);
        }
        if (this.format == DurationFormat.ALWAYS_YEARS) {
            return this.getDurationAsYears(duration, duration, true);
        }
        if (this.format == DurationFormat.ALWAYS_DAYS) {
            return this.getDurationAsDays(duration, duration, true);
        }
        if (this.format == DurationFormat.ALWAYS_HOURS) {
            return this.getDurationAsHours(duration, duration, true);
        }
        if (this.format == DurationFormat.ALWAYS_MINUTES) {
            return this.getDurationAsMinutes(duration, duration, true);
        }
        if (this.format == DurationFormat.ALWAYS_SECONDS) {
            return this.getDurationAsSeconds(duration, duration, true);
        }
        if (this.format == DurationFormat.ALWAYS_MILLISECONDS) {
            return this.getDurationAsMilliseconds(duration, duration, true);
        }
        if (this.format == DurationFormat.ALWAYS_MICROSECONDS) {
            return this.getDurationAsMicroseconds(duration, duration, true);
        }
        if (this.format == DurationFormat.FULL_TO_MILLIS) {
            return this.getDurationFull(duration, 1000000L);
        }
        if (this.format == DurationFormat.FULL_TO_MICROS) {
            return this.getDurationFull(duration, 1000L);
        }
        if (this.format == DurationFormat.FULL_TO_NANOS) {
            return this.getDurationFull(duration, 1L);
        }
        return this.getDurationAsNanoseconds(duration, duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDurationAsString(long duration, long maxDuration, String unit, boolean onlyWholeNumbers) {
        if (onlyWholeNumbers || maxDuration >= 10000L) {
            NumberFormat numberFormat = this.integerFormat;
            synchronized (numberFormat) {
                return this.integerFormat.format(duration / 100L) + DataFormatter.UNIT_SEP + unit;
            }
        }
        if (maxDuration < 1000L) {
            if (maxDuration % 100L != 0L && maxDuration % 10L != 0L) {
                NumberFormat numberFormat = this.durationFormat2;
                synchronized (numberFormat) {
                    return this.durationFormat2.format((double)duration / 100.0) + DataFormatter.UNIT_SEP + unit;
                }
            }
            if (maxDuration % 100L != 0L) {
                NumberFormat numberFormat = this.durationFormat1;
                synchronized (numberFormat) {
                    return this.durationFormat1.format((double)duration / 100.0) + DataFormatter.UNIT_SEP + unit;
                }
            }
            NumberFormat numberFormat = this.integerFormat;
            synchronized (numberFormat) {
                return this.integerFormat.format(duration / 100L) + DataFormatter.UNIT_SEP + unit;
            }
        }
        if (maxDuration % 100L != 0L) {
            NumberFormat numberFormat = this.durationFormat1;
            synchronized (numberFormat) {
                return this.durationFormat1.format((double)duration / 100.0) + DataFormatter.UNIT_SEP + unit;
            }
        }
        NumberFormat numberFormat = this.integerFormat;
        synchronized (numberFormat) {
            return this.integerFormat.format(duration / 100L) + DataFormatter.UNIT_SEP + unit;
        }
    }

    private String getDurationAsYears(long duration, long maxDuration, boolean onlyWholeNumbers) {
        return this.getDurationAsString(duration * 100L / 31536000000000000L, maxDuration * 100L / 31536000000000000L, yUnit, onlyWholeNumbers);
    }

    private String getDurationAsDays(long duration, long maxDuration, boolean onlyWholeNumbers) {
        return this.getDurationAsString(duration * 100L / 86400000000000L, maxDuration * 100L / 86400000000000L, dUnit, onlyWholeNumbers);
    }

    private String getDurationAsHours(long duration, long maxDuration, boolean onlyWholeNumbers) {
        return this.getDurationAsString(duration * 100L / 3600000000000L, maxDuration * 100L / 3600000000000L, hUnit, onlyWholeNumbers);
    }

    private String getDurationAsMinutes(long duration, long maxDuration, boolean onlyWholeNumbers) {
        return this.getDurationAsString(duration * 100L / 60000000000L, maxDuration * 100L / 60000000000L, mUnit, onlyWholeNumbers);
    }

    private String getDurationAsSeconds(long duration, long maxDuration, boolean onlyWholeNumbers) {
        return this.getDurationAsString(duration * 100L / 1000000000L, maxDuration * 100L / 1000000000L, sUnit, onlyWholeNumbers);
    }

    private String getDurationAsMilliseconds(long duration, long maxDuration, boolean onlyWholeNumbers) {
        return this.getDurationAsString(duration * 100L / 1000000L, maxDuration * 100L / 1000000L, msUnit, onlyWholeNumbers);
    }

    private String getDurationAsMicroseconds(long duration, long maxDuration, boolean onlyWholeNumbers) {
        return this.getDurationAsString(duration * 100L / 1000L, maxDuration * 100L / 1000L, usUnit, onlyWholeNumbers);
    }

    private String getDurationAsNanoseconds(long duration, long maxDuration) {
        return this.getDurationAsString(duration * 100L / 1L, maxDuration * 100L / 1L, nsUnit, true);
    }

    private String getDurationAdaptive(long duration, long baseDuration) {
        String sign = duration < 0L ? "-" : "";
        long durationMillis = Math.abs(duration / 1000000L);
        long baseMillis = Math.abs(baseDuration / 1000000L);
        long days = durationMillis / 86400000L;
        long baseDays = baseMillis / 86400000L;
        long hours = (durationMillis -= days * 86400000L) / 3600000L;
        long baseHours = (baseMillis -= baseDays * 86400000L) / 3600000L;
        long minutes = (durationMillis -= hours * 3600000L) / 60000L;
        long baseMinutes = (baseMillis -= baseHours * 3600000L) / 60000L;
        baseMillis -= baseMinutes * 60000L;
        long seconds = (durationMillis -= minutes * 60000L) / 1000L;
        String result = null;
        result = baseDays > 0L ? (days == 0L ? I18n.formatText(dPattern_zero, sign, hours) : I18n.formatText(dPattern, sign, days, hours)) : (baseHours > 0L ? (hours == 0L ? I18n.formatText(hPattern_zero, sign, minutes) : I18n.formatText(hPattern, sign, hours, minutes)) : (baseMinutes > 0L ? (minutes == 0L ? I18n.formatText(mPattern_zero, sign, seconds) : I18n.formatText(mPattern, sign, minutes, seconds)) : (seconds == 0L ? I18n.formatText(sPattern_zero, sign, durationMillis) : I18n.formatText(sPattern, sign, seconds, durationMillis -= seconds * 1000L))));
        return result;
    }

    private String getDurationFull(long duration, long precision) {
        long absDuration;
        String sign = duration < 0L ? "-" : "";
        long nanos = absDuration = Math.abs(duration);
        long years = duration / 31536000000000000L;
        long days = (nanos -= years * 31536000000000000L) / 86400000000000L;
        long hours = (nanos -= days * 86400000000000L) / 3600000000000L;
        long minutes = (nanos -= hours * 3600000000000L) / 60000000000L;
        long seconds = (nanos -= minutes * 60000000000L) / 1000000000L;
        long millis = (nanos -= seconds * 1000000000L) / 1000000L;
        long micros = (nanos -= millis * 1000000L) / 1000L;
        nanos -= micros * 1000L;
        StringBuilder result = new StringBuilder(sign);
        if (absDuration < precision) {
            result.append("0\u200a");
            if (precision >= 31536000000000000L) {
                result.append(yUnit);
            } else if (precision >= 86400000000000L) {
                result.append(dUnit);
            } else if (precision >= 3600000000000L) {
                result.append(hUnit);
            } else if (precision >= 60000000000L) {
                result.append(mUnit);
            } else if (precision >= 1000000000L) {
                result.append(sUnit);
            } else if (precision >= 1000000L) {
                result.append(msUnit);
            } else if (precision >= 1000L) {
                result.append(usUnit);
            } else if (precision >= 1L) {
                result.append(nsUnit);
            }
        } else {
            if (absDuration > 31536000000000000L) {
                result.append(years).append('\u200a').append(yUnit);
                result.append('\u2002');
            }
            if (absDuration > 86400000000000L && precision <= 86400000000000L) {
                result.append(days).append('\u200a').append(dUnit);
                result.append('\u2002');
            }
            if (absDuration > 3600000000000L && precision <= 3600000000000L) {
                result.append(hours).append('\u200a').append(hUnit);
                result.append('\u2002');
            }
            if (absDuration > 60000000000L && precision <= 60000000000L) {
                result.append(minutes).append('\u200a').append(mUnit);
                result.append('\u2002');
            }
            if (absDuration > 1000000000L && precision <= 1000000000L) {
                result.append(seconds).append('\u200a').append(sUnit);
                result.append('\u2002');
            }
            if (absDuration > 1000000L && precision <= 1000000L) {
                result.append(millis).append('\u200a').append(msUnit);
                result.append('\u2002');
            }
            if (absDuration > 1000L && precision <= 1000L) {
                result.append(micros).append('\u200a').append(usUnit);
                result.append('\u2002');
            }
            if (precision <= 1L) {
                result.append(nanos).append('\u200a').append(nsUnit);
            }
        }
        return I18n.sanitize(result.toString());
    }

    private String getDurationHHMMSS(long duration) {
        String sign = duration < 0L ? "-" : "";
        long durationMillis = Math.abs(duration / 1000000L);
        long days = durationMillis / 86400000L;
        long hours = (durationMillis -= days * 86400000L) / 3600000L;
        long minutes = (durationMillis -= hours * 3600000L) / 60000L;
        long seconds = (durationMillis -= minutes * 60000L) / 1000L;
        durationMillis -= seconds * 1000L;
        String result = null;
        result = days > 0L ? I18n.formatText(dhhmmPattern, sign, days, hours, minutes, seconds) : I18n.formatText(hhmmssPattern, sign, hours, minutes, seconds);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getToolTipString(long duration, long overallDuration) {
        String text;
        String result;
        String bestText = this.getDurationAsString(duration, duration);
        String string = result = bestText.equals(text = this.getDurationAsNanoseconds(duration, duration)) ? text : bestText + " (" + text + ")";
        if (overallDuration <= 0L) {
            return result;
        }
        NumberFormat numberFormat = this.percentageFormat;
        synchronized (numberFormat) {
            return result + " " + this.percentageFormat.format(1.0 * (double)duration / (double)overallDuration);
        }
    }
}

