/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.i18n;

import com.sap.jvm.tracing.Trace;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18n {
    private static final boolean WARN_ON_MISSING_TRANSLATIONS = false;
    private static final boolean MARK_TRANSLATABLE_TEXT = false;
    private static final String MARKER_STRING_START = "\u203a";
    private static final String MARKER_STRING_END = "\u2039";
    public static final boolean onlyAscii = "true".equals(System.getProperty("com.sap.jvm.profiling.i18n.onlyAscii"));
    public static final String BUNDLE_NAME = "com.sap.jvm.profiling.i18n.messages";
    public static final String IMPORT_SEQUENCE = "import static com.sap.jvm.profiling.i18n.I18n.";
    private static final String emptyContext = "";
    private static Locale currentLocale = null;
    private static ResourceBundle bundle = null;
    private static ArrayList<MessageFormat> formatters = new ArrayList();
    private static ArrayList<MessageDigest> messageDigests = new ArrayList();
    private static HashMap<String, String> textToKeyMap = new HashMap();
    private static HashMap<ContextAndText, String> contexToKeyMap = new HashMap();
    private static HashMap<ContextAndText, String> singularToKeyMap = new HashMap();
    private static HashMap<ContextAndText, String> pluralToKeyMap = new HashMap();

    private I18n() {
    }

    public static final void init() {
        currentLocale = Locale.US;
        try {
            bundle = ResourceBundle.getBundle(BUNDLE_NAME, currentLocale);
        }
        catch (MissingResourceException e) {
            Trace.error((Throwable)e, () -> "Could not find resource bundle com.sap.jvm.profiling.i18n.messages");
            bundle = null;
        }
    }

    public static final Locale getLocale() {
        return currentLocale;
    }

    public static final String _s(String text) {
        return I18n.gettext(I18n.textToKey(text), text);
    }

    public static final String _s(String text, Object ... args) {
        return I18n.gettext(I18n.textToKey(text), text, args);
    }

    public static final String _ss(String context, String text) {
        return I18n.gettext(I18n.textToKey(null, context, text), text);
    }

    public static final String _ss(String context, String text, Object ... args) {
        return I18n.gettext(I18n.textToKey(null, context, text), text, args);
    }

    public static final String _ssn(String message1, String message2, int n) {
        if (n == 1) {
            return I18n.gettext(I18n.textToKey(null, message1, message2, 0), message1);
        }
        return I18n.gettext(I18n.textToKey(null, message1, message2, 1), message2);
    }

    public static final String _ssn(String message1, String message2, int n, Object ... args) {
        if (n == 1) {
            return I18n.gettext(I18n.textToKey(null, message1, message2, 0), message1, args);
        }
        return I18n.gettext(I18n.textToKey(null, message1, message2, 1), message2, args);
    }

    public static final String _ts(TextType type, String text) {
        return I18n.gettext(I18n.textToKey(type, emptyContext, text), text);
    }

    public static final String _ts(TextType type, String text, Object ... args) {
        return I18n.gettext(I18n.textToKey(type, emptyContext, text), text, args);
    }

    public static final String _tss(TextType type, String context, String text) {
        return I18n.gettext(I18n.textToKey(type, context, text), text);
    }

    public static final String _tss(TextType type, String context, String text, Object ... args) {
        return I18n.gettext(I18n.textToKey(type, context, text), text, args);
    }

    public static final String formatText(String pattern, Object ... args) {
        return I18n.formatText(currentLocale, pattern, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String formatText(Locale locale, String pattern, Object ... args) {
        MessageFormat formatter = null;
        Class<I18n> clazz = I18n.class;
        synchronized (I18n.class) {
            if (formatters.size() > 0) {
                formatter = formatters.remove(formatters.size() - 1);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (formatter == null) {
                formatter = new MessageFormat(emptyContext, locale);
            }
            formatter.setLocale(locale);
            formatter.applyPattern(I18n.duplicateSingleQuotes(pattern));
            String result = formatter.format(args);
            Class<I18n> clazz2 = I18n.class;
            synchronized (I18n.class) {
                formatters.add(formatter);
                // ** MonitorExit[var5_6] (shouldn't be in output)
                return I18n.sanitize(result);
            }
        }
    }

    public static final String formatText_n(String pattern1, String pattern2, int n, Object ... args) {
        if (n == 1) {
            return I18n.formatText(pattern1, args);
        }
        return I18n.formatText(pattern2, args);
    }

    private static final String gettext(String key, String defaultText) {
        if (bundle == null) {
            return I18n.sanitize(defaultText);
        }
        String msg = null;
        try {
            msg = bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return I18n.sanitize(msg != null ? msg : defaultText);
    }

    private static final String gettext(String key, String defaultText, Object ... args) {
        String pattern = null;
        if (bundle != null) {
            try {
                pattern = bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (pattern == null) {
            if (defaultText == null) {
                throw new NullPointerException("No pattern found in resource bundle and defaultText==null");
            }
            pattern = defaultText;
        }
        return I18n.sanitize(I18n.formatText(pattern, args));
    }

    private static final String getMarkedText(String text) {
        return MARKER_STRING_START + text + MARKER_STRING_END;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String textToKey(String text) {
        String result;
        HashMap<String, String> hashMap = textToKeyMap;
        synchronized (hashMap) {
            result = textToKeyMap.get(text);
        }
        if (result != null) {
            return result;
        }
        result = I18n.getMd5Hash(text);
        hashMap = textToKeyMap;
        synchronized (hashMap) {
            textToKeyMap.put(text, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String textToKey(TextType type, String singular, String plural, int index) {
        String result;
        HashMap<ContextAndText, String> hashMap;
        ContextAndText key = new ContextAndText(type, singular, plural);
        if (index == 0) {
            hashMap = singularToKeyMap;
            synchronized (hashMap) {
                result = singularToKeyMap.get(key);
            }
        }
        assert (index == 1);
        hashMap = pluralToKeyMap;
        synchronized (hashMap) {
            result = pluralToKeyMap.get(key);
        }
        if (result != null) {
            return result;
        }
        String string = result = type == null ? I18n.getMd5Hash(singular, plural) + "[" + index + "]" : type.name() + "_" + I18n.getMd5Hash(singular, plural) + "[" + index + "]";
        if (index == 0) {
            hashMap = singularToKeyMap;
            synchronized (hashMap) {
                singularToKeyMap.put(key, result);
            }
        }
        assert (index == 1);
        hashMap = pluralToKeyMap;
        synchronized (hashMap) {
            pluralToKeyMap.put(key, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String textToKey(TextType type, String context, String text) {
        String result;
        if (type == null && context == null) {
            return I18n.textToKey(text);
        }
        ContextAndText key = new ContextAndText(type, context, text);
        HashMap<ContextAndText, String> hashMap = contexToKeyMap;
        synchronized (hashMap) {
            result = contexToKeyMap.get(key);
        }
        if (result != null) {
            return result;
        }
        result = type == null ? I18n.getMd5Hash(context, text) : type.name() + "_" + I18n.getMd5Hash(context, text);
        hashMap = contexToKeyMap;
        synchronized (hashMap) {
            contexToKeyMap.put(key, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getMd5Hash(String ... texts) {
        MessageDigest digest = null;
        Class<I18n> clazz = I18n.class;
        synchronized (I18n.class) {
            if (messageDigests.size() > 0) {
                digest = messageDigests.remove(messageDigests.size() - 1);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (digest == null) {
                try {
                    digest = MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException e) {
                    Trace.error((Throwable)e, "Could not get MD5 digest");
                    return null;
                }
            }
            digest.reset();
            byte[] md5hash = null;
            try {
                for (int i = 0; i < texts.length; ++i) {
                    if (texts[i] == null) continue;
                    digest.update(texts[i].getBytes("UTF-8"));
                }
                md5hash = digest.digest();
            }
            catch (UnsupportedEncodingException e) {
                Trace.error("Cannot convert to UTF-8");
                String string = null;
                return string;
            }
            finally {
                Class<I18n> clazz2 = I18n.class;
                synchronized (I18n.class) {
                    messageDigests.add(digest);
                    // ** MonitorExit[var5_11] (shouldn't be in output)
                }
            }
            StringBuilder result = new StringBuilder(32);
            for (byte b : md5hash) {
                result.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
            }
            return result.toString();
        }
    }

    private static String duplicateSingleQuotes(String pattern) {
        if (pattern.indexOf(39) == -1) {
            return pattern;
        }
        StringBuilder result = new StringBuilder(pattern.length() + 10);
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            result.append(c);
            if (c != '\'') continue;
            result.append(c);
        }
        return result.toString();
    }

    public static String sanitize(String str) {
        if (onlyAscii) {
            return I18n.forceSanitize(str);
        }
        return str;
    }

    public static String forceSanitize(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            int c = str.charAt(i);
            if (c > 126) {
                if (c == 8201 || c == 8202 || c == 8194) {
                    c = 32;
                } else if (c == 181) {
                    c = 117;
                } else if (c == 215) {
                    c = 120;
                } else if (c == 8594) {
                    result.append("->");
                    continue;
                }
            }
            result.append((char)c);
        }
        return result.toString();
    }

    private static /* synthetic */ String lambda$gettext$2(String key, String defaultText) {
        StringBuilder warning = new StringBuilder();
        warning.append("  WARNING: Missing resource for text key \"");
        warning.append(key + "\"");
        if (defaultText != null) {
            warning.append(", default=\"");
            warning.append(defaultText);
            warning.append("\"");
        }
        return warning.toString();
    }

    private static /* synthetic */ String lambda$gettext$1(String key, String defaultText) {
        StringBuilder warning = new StringBuilder();
        warning.append("  WARNING: Missing resource for text key \"");
        warning.append(key + "\"");
        if (defaultText != null) {
            warning.append(", default=\"");
            warning.append(defaultText);
            warning.append("\"");
        }
        return warning.toString();
    }

    static {
        I18n.init();
    }

    private static class ContextAndText {
        private final TextType type;
        private final String context;
        private final String text;
        private final int hashCode;

        public ContextAndText(TextType type, String context, String text) {
            this.type = type;
            this.context = context == null ? I18n.emptyContext : context;
            this.text = text;
            this.hashCode = type == null ? this.context.hashCode() ^ text.hashCode() : type.hashCode() ^ this.context.hashCode() ^ text.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ContextAndText) {
                ContextAndText other = (ContextAndText)obj;
                return this.type == other.type && this.context.equals(other.context) && this.text.equals(other.text);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    public static enum TextType {
        XBUT,
        XCKL,
        XCOL,
        XFLD,
        XGRP,
        XLNK,
        XLST,
        XMEN,
        XMIT,
        XMSG,
        XRBL,
        XTBS,
        XTIT,
        XTND,
        XTOL,
        YMSG;

    }
}

