/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.i18n.tools;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.i18n.tools.PropertiesFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GenerateProperties {
    public static final File DEFAULT_BASE_DIR = new File("P:/bas2/sapjvm/dev/common/java/src");
    public static final String VERSION_PATTERN = "VERSION";
    public static final String[] PROFILER_PROJECT_SRC_DIRS = new String[]{"profiling_VERSION_controller", "profiling_VERSION_core", "profiling_VERSION_frontend", "profiling_VERSION_frontend_rcp", "profiling_VERSION_i18n", "profiling_VERSION_presentation", "profiling_VERSION_snapshot", "profiling_VERSION_ui_library", "profiling_VERSION_ui_library_swt", "profiling_VERSION_ui_sap_internal_widgets", "profiling_VERSION_ui_widgets", "profiling_VERSION_ui_workbench", "debugging_VERSION_ui_eclipse", "debugging_VERSION_ui_eclipse_sap_internal"};
    private static int currentLine = 0;
    private static String currentFile = null;
    private static int foundCount = 0;
    private static int foundNewCount = 0;
    private static int typedCount = 0;
    private static boolean debugParsing = false;
    private static ArrayList<String> warnings = new ArrayList();
    private static State currentState = State.IN_CODE;

    static List<File> findJavaSources(File baseDir, String[] subDirs) {
        ArrayList<File> foundFiles = new ArrayList<File>();
        for (String subDir : subDirs) {
            File startDir = new File(baseDir, subDir);
            foundFiles.addAll(GenerateProperties.findJavaSources(startDir));
        }
        return foundFiles;
    }

    static List<File> findJavaSources(File startDir) {
        File[] filesInDir;
        if (!startDir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + startDir);
        }
        ArrayList<File> foundFiles = new ArrayList<File>();
        for (File file : filesInDir = startDir.listFiles()) {
            if (file.isDirectory()) {
                foundFiles.addAll(GenerateProperties.findJavaSources(file));
                continue;
            }
            if (!file.canRead() || !file.getName().toLowerCase().endsWith(".java")) continue;
            foundFiles.add(file);
        }
        return foundFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean containsI18nImport(File srcFile) throws IOException {
        boolean result = false;
        FileInputStream in = null;
        try {
            in = new FileInputStream(srcFile);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String line = reader.readLine();
            while (line != null) {
                if (line.contains("import static com.sap.jvm.profiling.i18n.I18n.")) {
                    result = true;
                    break;
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void findStrings(File srcFile, PropertiesFile props) {
        FileInputStream in = null;
        currentLine = 1;
        currentState = State.IN_CODE;
        try {
            if (debugParsing) {
                System.out.println("\n\nParsing " + srcFile);
            }
            in = new FileInputStream(srcFile);
            PushbackInputStream stream = new PushbackInputStream(in);
            Character read = null;
            char lastChar = ' ';
            char c = ' ';
            while ((read = GenerateProperties.readChar(stream)) != null) {
                lastChar = c;
                c = read.charValue();
                if (debugParsing) {
                    if (lastChar == '\n') {
                        System.out.print((Object)((Object)currentState) + ": ");
                        int spaces = State.IN_BLOCK_COMMENT.toString().length() - currentState.toString().length();
                        for (int i = 0; i < spaces; ++i) {
                            System.out.print(' ');
                        }
                    }
                    System.out.print(c);
                }
                if (currentState == State.IN_LINE_COMMENT) {
                    if (c != 10) continue;
                    currentState = State.IN_CODE;
                    continue;
                }
                if (currentState == State.IN_BLOCK_COMMENT) {
                    if (c != 47 || lastChar != 42) continue;
                    currentState = State.IN_CODE;
                    continue;
                }
                if (currentState == State.IN_STRING) {
                    if (c == '\\') {
                        currentState = State.IN_STRING_QUOTE;
                        c = ' ';
                        continue;
                    }
                    if (c != 34 || lastChar == 92) continue;
                    currentState = State.IN_CODE;
                    continue;
                }
                if (currentState == State.IN_STRING_QUOTE) {
                    c = ' ';
                    currentState = State.IN_STRING;
                    continue;
                }
                if (c == '\"') {
                    currentState = State.IN_STRING;
                    continue;
                }
                if (c == '/') {
                    Character next = GenerateProperties.peekChar(stream);
                    if (next == null) break;
                    if (next.charValue() == '/') {
                        currentState = State.IN_LINE_COMMENT;
                        continue;
                    }
                    if (next.charValue() == '*') {
                        currentState = State.IN_BLOCK_COMMENT;
                        continue;
                    }
                }
                if (c != 95) continue;
                if (debugParsing) {
                    System.out.println("\n######## Found _, last = '" + lastChar + (Character.isJavaIdentifierPart(lastChar) ? " (JavaIdentifierPart)" : "") + "' , state = " + (Object)((Object)currentState));
                }
                if (Character.isJavaIdentifierPart(lastChar)) continue;
                boolean hasContext = GenerateProperties.expect(stream, '_');
                boolean hasType = GenerateProperties.expect(stream, 't');
                boolean ngettext = false;
                if (!hasContext && !hasType) {
                    ngettext = GenerateProperties.expect(stream, 'n');
                }
                if (debugParsing) {
                    System.out.println("\n######## hasContext = " + hasContext + ", hasType = " + hasType + ", ngettext = " + ngettext);
                }
                if (!GenerateProperties.skipBlanksAndExpect(stream, '(')) continue;
                I18n.TextType type = null;
                if (hasType && (type = GenerateProperties.readTextType(stream)) == null) continue;
                String context = null;
                if (hasContext) {
                    context = GenerateProperties.readStringLiteral(stream);
                    if (context == null) {
                        GenerateProperties.logWarning("Expected context string in file " + currentFile + " (line " + currentLine + ")");
                        continue;
                    }
                    if (!GenerateProperties.skipBlanksAndExpect(stream, ',')) {
                        GenerateProperties.logWarning("Expected message string in file " + currentFile + " (line " + currentLine + ")");
                        continue;
                    }
                }
                if (ngettext) {
                    String singular = null;
                    String plural = null;
                    singular = GenerateProperties.readStringLiteral(stream);
                    if (singular == null) {
                        GenerateProperties.logWarning("Expected singular message string in file " + currentFile + " (line " + currentLine + ")");
                        continue;
                    }
                    if (!GenerateProperties.skipBlanksAndExpect(stream, ',')) continue;
                    plural = GenerateProperties.readStringLiteral(stream);
                    if (plural == null) {
                        GenerateProperties.logWarning("Expected plural message string in file " + currentFile + " (line " + currentLine + ")");
                        continue;
                    }
                    foundCount += 2;
                    GenerateProperties.updatePropsNgettext(type, singular, plural, props);
                    continue;
                }
                String msg = null;
                msg = GenerateProperties.readStringLiteral(stream);
                if (msg == null) {
                    GenerateProperties.logWarning("Expected message string in file " + currentFile + " (line " + currentLine + ")");
                    continue;
                }
                ++foundCount;
                if (type != null) {
                    ++typedCount;
                }
                GenerateProperties.updateProps(type, context, msg, props);
            }
            stream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static Character readChar(InputStream in) throws IOException {
        int read = in.read();
        if (read == -1) {
            return null;
        }
        char c = (char)read;
        if (c == '\n') {
            ++currentLine;
        }
        return Character.valueOf(c);
    }

    private static Character peekChar(PushbackInputStream in) throws IOException {
        int read = in.read();
        if (read == -1) {
            return null;
        }
        in.unread(read);
        return Character.valueOf((char)read);
    }

    private static String readString(PushbackInputStream in) throws IOException {
        StringBuilder result = new StringBuilder();
        boolean inQuote = false;
        Character read = null;
        while ((read = GenerateProperties.readChar(in)) != null) {
            char c = read.charValue();
            if (inQuote) {
                switch (c) {
                    case 'b': {
                        result.append('\b');
                        break;
                    }
                    case 'f': {
                        result.append('\f');
                        break;
                    }
                    case 'n': {
                        result.append('\n');
                        break;
                    }
                    case 'r': {
                        result.append('\r');
                        break;
                    }
                    case 't': {
                        result.append('\t');
                        break;
                    }
                    case 'u': {
                        result.append(GenerateProperties.readUnicode(in));
                        break;
                    }
                    default: {
                        result.append(c);
                    }
                }
                inQuote = false;
                continue;
            }
            if (c == '\\') {
                inQuote = true;
                continue;
            }
            if (c == '\"') {
                if (!GenerateProperties.skipBlanksAndExpect(in, '+')) break;
                if (GenerateProperties.skipBlanksAndExpect(in, '\"')) continue;
                byte[] buf = new byte[50];
                in.read(buf);
                throw new IllegalStateException("Expected new String literal after \"+ but found \"" + new String(buf) + "\" ...");
            }
            result.append(c);
        }
        System.out.println("  (line " + currentLine + "): " + result);
        return result.toString();
    }

    private static String readStringLiteral(PushbackInputStream in) throws IOException {
        if (!GenerateProperties.skipBlanksAndExpect(in, '\"')) {
            return null;
        }
        return GenerateProperties.readString(in);
    }

    private static I18n.TextType readTextType(PushbackInputStream in) throws IOException {
        StringBuilder readCharacters = new StringBuilder();
        Character read = null;
        boolean foundNonWhitespace = false;
        boolean foundDots = false;
        boolean foundClassName = false;
        I18n.TextType foundType = null;
        while ((read = GenerateProperties.readChar(in)) != null) {
            char c = read.charValue();
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
                if (!foundNonWhitespace || foundType != null) continue;
                return null;
            }
            foundNonWhitespace = true;
            if (c == ',') {
                return foundType;
            }
            if (foundType != null) {
                GenerateProperties.logWarning("Found char '" + c + "' after message text type " + foundType + " in file " + currentFile + " (line " + currentLine + ")");
                foundType = null;
            }
            if (c == '.') {
                foundClassName = readCharacters.toString().equals("TextType");
                foundDots = true;
                readCharacters.setLength(0);
                continue;
            }
            if (Character.isJavaIdentifierPart(c)) {
                readCharacters.append(c);
                if (readCharacters.length() != 4 || foundDots && !foundClassName) continue;
                try {
                    foundType = I18n.TextType.valueOf(readCharacters.toString());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            return null;
        }
        return null;
    }

    private static char readUnicode(PushbackInputStream in) throws IOException {
        int value = 0;
        block5: for (int i = 0; i < 4; ++i) {
            char aChar = GenerateProperties.readChar(in).charValue();
            switch (aChar) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    value = (value << 4) + aChar - 48;
                    continue block5;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    value = (value << 4) + 10 + aChar - 97;
                    continue block5;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    value = (value << 4) + 10 + aChar - 65;
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                }
            }
        }
        return (char)value;
    }

    private static boolean skipBlanksAndExpect(PushbackInputStream in, char expected) throws IOException {
        Character read = null;
        while ((read = GenerateProperties.readChar(in)) != null) {
            char c = read.charValue();
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
            if (c == expected) {
                return true;
            }
            in.unread(read.charValue());
            break;
        }
        return false;
    }

    private static boolean expect(PushbackInputStream in, char expected) throws IOException {
        block1: {
            Character read = null;
            read = GenerateProperties.readChar(in);
            if (read == null) break block1;
            char c = read.charValue();
            if (c == expected) {
                return true;
            }
            in.unread(read.charValue());
        }
        return false;
    }

    private static void updateProps(I18n.TextType type, String context, String message, PropertiesFile props) {
        String key = I18n.textToKey(type, context, message);
        GenerateProperties.addMessage(key, message, context, currentFile + " (line " + currentLine + ")", props);
    }

    private static void updatePropsNgettext(I18n.TextType type, String singular, String plural, PropertiesFile props) {
        String key = I18n.textToKey(type, singular, plural, 0);
        GenerateProperties.addMessage(key, singular, "singular form of \"" + plural + "\"", currentFile + " (line " + currentLine + ")", props);
        key = I18n.textToKey(type, singular, plural, 1);
        GenerateProperties.addMessage(key, plural, "plural form of \"" + singular + "\"", null, props);
    }

    private static void addMessage(String key, String message, String context, String comment, PropertiesFile props) {
        String oldContext;
        String old = props.getProperty(key);
        if (old != null) {
            if (!old.equals(message)) {
                System.err.println("\nFound conflict for message key " + key);
                System.err.println("  in file \"" + currentFile);
                System.err.println("  at line " + currentLine);
                System.err.println("  old: " + old);
                System.err.println("  new: " + message + "\n");
            }
        } else {
            ++foundNewCount;
            props.setProperty(key, message);
        }
        if (comment != null) {
            props.addComment(key, comment);
        }
        if ((oldContext = props.getContext(key)) != null && !oldContext.equals(context)) {
            System.err.println("\nFound context conflict for message key " + key);
            System.err.println("  in file \"" + currentFile);
            System.err.println("  at line " + currentLine);
            System.err.println("  message: " + message);
            System.err.println("  old context: " + oldContext);
            System.err.println("  new context: " + context + "\n");
        }
        props.setContext(key, context);
    }

    private static void setCurrentFile(File file, File baseDir) throws IOException {
        String basePath;
        String filePath = file.getCanonicalPath();
        if (!filePath.startsWith(basePath = baseDir.getCanonicalPath())) {
            throw new IllegalStateException("File " + file + " is not in " + baseDir + " or a sub-directory!");
        }
        currentFile = filePath.substring(basePath.length() + 1);
    }

    private static void logWarning(String msg) {
        warnings.add(msg);
        System.err.println("\nWARNING: " + msg);
    }

    public static void main(String[] args) throws Exception {
        File baseDir = null;
        File propsFile = null;
        File srcDir = null;
        String version = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--basedir") && i < args.length - 1) {
                if ((baseDir = new File(args[++i])).isDirectory()) continue;
                throw new IllegalArgumentException(baseDir + " is not a directory!");
            }
            if (args[i].equals("--srcdir") && i < args.length - 1) {
                if ((srcDir = new File(args[++i])).isDirectory()) continue;
                throw new IllegalArgumentException(srcDir + " is not a directory!");
            }
            if (args[i].equals("--properties") && i < args.length - 1) {
                propsFile = new File(args[++i]);
                continue;
            }
            if (args[i].equals("--version") && i < args.length - 1) {
                version = args[++i];
                continue;
            }
            System.out.println("Unknown option: " + args[i]);
            GenerateProperties.showUsageAndExit();
        }
        if (srcDir != null && baseDir != null) {
            System.out.print("Source dir and base dir are given! Please specify only one");
            GenerateProperties.showUsageAndExit();
        }
        if (propsFile == null) {
            String propFileName = "com.sap.jvm.profiling.i18n.messages".replace('.', '/') + ".properties";
            propsFile = new File("java", propFileName);
            System.out.println("Using properties file " + propsFile);
        }
        PropertiesFile props = new PropertiesFile();
        props.loadIgnoringComments(propsFile);
        foundCount = 0;
        foundNewCount = 0;
        typedCount = 0;
        long time = System.currentTimeMillis();
        List<File> files = null;
        if (srcDir == null) {
            if (baseDir == null && !(baseDir = DEFAULT_BASE_DIR).isDirectory()) {
                GenerateProperties.showUsageAndExit();
            }
            System.out.println("Searching for Java source files in " + baseDir);
            if (version == null) {
                version = GenerateProperties.findVersionFromPath(new File(".").getCanonicalPath());
            }
            if (version == null) {
                System.out.println("Version could not be retrieved from current working directory.");
                GenerateProperties.showUsageAndExit();
            }
            String[] srcDirsWithVersion = GenerateProperties.substituteVersion(version, PROFILER_PROJECT_SRC_DIRS);
            files = GenerateProperties.findJavaSources(baseDir, srcDirsWithVersion);
        } else {
            baseDir = srcDir;
            System.out.println("Searching for Java source files in " + srcDir);
            files = GenerateProperties.findJavaSources(srcDir, new String[]{"."});
        }
        System.out.println("Found " + files.size() + " files.\n");
        for (File file : files) {
            GenerateProperties.setCurrentFile(file, baseDir);
            System.out.print('.');
            if (!GenerateProperties.containsI18nImport(file)) continue;
            System.out.println("\nFound I18n import in " + file);
            int oldCount = foundCount;
            GenerateProperties.findStrings(file, props);
            if (foundCount != oldCount) continue;
            GenerateProperties.logWarning("found I18n import but no message in file " + file);
        }
        time = System.currentTimeMillis() - time;
        System.out.println("\nTotal: " + foundCount + " (" + typedCount + " typed, " + props.size() + " unique, " + foundNewCount + " new) messages in " + files.size() + " files, parsed in " + time + "ms.");
        props.saveToFile(propsFile);
        if (warnings.size() != 0) {
            System.err.println("\nThere were warnings!\n");
            for (String msg : warnings) {
                System.err.println("\n" + msg);
            }
        }
    }

    private static String findVersionFromPath(String path) {
        Pattern pattern;
        Matcher matcher;
        int lastSlashIndex;
        String dir = path;
        if (dir.endsWith(File.separator)) {
            dir = dir.substring(0, dir.length() - 1);
        }
        if ((lastSlashIndex = dir.lastIndexOf(File.separator)) >= 0) {
            dir = dir.substring(lastSlashIndex + 1);
        }
        if ((matcher = (pattern = Pattern.compile("profiling_(\\d\\.\\d)_i18n")).matcher(dir)).matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private static String[] substituteVersion(String version, String ... versionedStrings) {
        String[] result = new String[versionedStrings.length];
        for (int i = 0; i < versionedStrings.length; ++i) {
            result[i] = versionedStrings[i].replace(VERSION_PATTERN, version);
        }
        return result;
    }

    private static void showUsageAndExit() {
        System.out.println("\nGenerateProperties: tool to genereate properties file from the SAP JVM\nProfiler Java sources. This tool expects the profiler sources to be found\nin sub-directories like 'profiling_2.2_frontend' under the given base\ndirectory, so specify the '.../common/java/src' dir: \n\nGenerateProperties --basedir <base-dir>\n\nOther possible options:\n   --basedir <base-dir>  :  specify base directory of the profiler projects\n   --srcdir <source-dir> :  directly specify a source dir to scan\n                            (don't use basedir and profiler projects)\n   --properties <output-file> : specify output properties file\n   --version <version>   :  specify the version of the profiler projects\n");
        System.exit(0);
    }

    private static enum State {
        IN_CODE,
        IN_LINE_COMMENT,
        IN_BLOCK_COMMENT,
        IN_STRING,
        IN_STRING_QUOTE;

    }
}

