/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.i18n.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropertiesFile {
    public static final String[] FILE_HEADER = new String[]{"# Copyright (c) 2001-2017 by SAP SE, Walldorf, Germany.", "# All rights reserved. Confidential and proprietary.", "#"};
    private HashMap<String, String> entries = new HashMap();
    private HashMap<String, List<String>> comments = new HashMap();
    private HashMap<String, MessageInfo> msgInfo = new HashMap();
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public PropertiesFile() {
        this.entries = new HashMap();
        this.comments = new HashMap();
        this.msgInfo = new HashMap();
    }

    public PropertiesFile(File file) throws IOException {
        this();
        this.loadFromFile(file);
    }

    public void addComment(String key, String comment) {
        List<String> commentsList = this.comments.get(key);
        if (commentsList == null) {
            commentsList = new ArrayList<String>();
            this.comments.put(key, commentsList);
        }
        commentsList.add(comment);
    }

    public Set<String> getKeys() {
        return Collections.unmodifiableSet(this.entries.keySet());
    }

    public List<String> getComments(String key) {
        ArrayList<String> result = new ArrayList<String>();
        List<String> commentsList = this.comments.get(key);
        if (commentsList != null) {
            result.addAll(commentsList);
        }
        return result;
    }

    public boolean hasComments(String key) {
        List<String> commentsList = this.comments.get(key);
        return commentsList != null && commentsList.size() > 0;
    }

    public String getProperty(String key) {
        return this.entries.get(key);
    }

    public void setProperty(String key, String value) {
        this.entries.put(key, value);
    }

    public void setContext(String key, String context) {
        MessageInfo info = this.msgInfo.get(key);
        if (info == null) {
            info = new MessageInfo();
            this.msgInfo.put(key, info);
        }
        info.setContext(context);
    }

    public String getContext(String key) {
        MessageInfo info = this.msgInfo.get(key);
        if (info == null) {
            return null;
        }
        return info.getContext();
    }

    public void setMessageInfo(String key, MessageInfo info) {
        this.msgInfo.put(key, info);
    }

    public MessageInfo getMessageInfo(String key) {
        return this.msgInfo.get(key);
    }

    public int size() {
        return this.entries.size();
    }

    public void loadIgnoringComments(File propertiesFile) throws IOException {
        Properties props = new Properties();
        if (propertiesFile.isFile()) {
            FileInputStream propsFile = new FileInputStream(propertiesFile);
            props.load(propsFile);
            propsFile.close();
        }
        for (Map.Entry entry : props.entrySet()) {
            this.entries.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromFile(File propertiesFile) throws IOException {
        FileInputStream propsFile = new FileInputStream(propertiesFile);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(propsFile));){
            String readLine = null;
            ArrayList<String> commentLines = new ArrayList<String>();
            MessageInfo info = new MessageInfo();
            while ((readLine = in.readLine()) != null) {
                if (readLine.trim().length() == 0) {
                    commentLines.clear();
                    if (info.isEmpty()) continue;
                    System.err.println("Discarding non-empty message info " + info);
                    info = new MessageInfo();
                    continue;
                }
                if (readLine.startsWith("#")) {
                    String comment = PropertiesFile.trimLeadingWhitespace(readLine.substring(1));
                    if (comment.length() == 0 || info.getFromCommentLine(comment)) continue;
                    commentLines.add(PropertiesFile.unquoteComment(comment));
                    continue;
                }
                String key = this.loadPropertyLine(readLine);
                if (!info.isEmpty()) {
                    this.msgInfo.put(key, info);
                    info = new MessageInfo();
                }
                if (commentLines.isEmpty()) continue;
                this.comments.put(key, commentLines);
                commentLines = new ArrayList();
            }
        }
    }

    public void saveToFile(File propertiesFile) throws IOException {
        FileOutputStream out = new FileOutputStream(propertiesFile);
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "8859_1"));
        this.writeHeader(awriter);
        ArrayList<String> keys = new ArrayList<String>(this.entries.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            MessageInfo info;
            awriter.newLine();
            List<String> commentsList = this.comments.get(key);
            if (commentsList != null) {
                for (String comment : commentsList) {
                    this.writeCommentLine(awriter, comment, true);
                }
            }
            if ((info = this.msgInfo.get(key)) != null) {
                this.writeMessageInfo(awriter, info);
            }
            String keyEscaped = PropertiesFile.saveConvert(key, true);
            String value = PropertiesFile.saveConvert(this.entries.get(key), false);
            PropertiesFile.writeln(awriter, keyEscaped + " = " + value);
        }
        awriter.flush();
        awriter.close();
    }

    private void writeHeader(BufferedWriter writer) throws IOException {
        for (String line : FILE_HEADER) {
            PropertiesFile.writeln(writer, line);
        }
        PropertiesFile.writeln(writer, "# generated: " + new Date().toString());
        PropertiesFile.writeln(writer, "# number of unique messages: " + this.entries.size());
    }

    private void writeCommentLine(BufferedWriter writer, String line, boolean quote) throws IOException {
        writer.write("# ");
        if (quote) {
            writer.write(PropertiesFile.quoteComment(line));
        } else {
            writer.write(line);
        }
        writer.newLine();
    }

    private void writeMessageInfo(BufferedWriter writer, MessageInfo info) throws IOException {
        if (info == null) {
            return;
        }
        if (info.getContext() != null) {
            this.writeCommentLine(writer, info.getContextTag(), true);
        }
        if (info.getMsgType() != null) {
            this.writeCommentLine(writer, info.getMsgType(), true);
        }
        if (info.getNeedsTranslation()) {
            this.writeCommentLine(writer, info.getNeedsTranslationTag(), false);
        }
        if (info.getFuzzy()) {
            this.writeCommentLine(writer, info.getFuzzyTag(), false);
        }
        if (info.getQuotedSrcMsg() != null) {
            this.writeCommentLine(writer, info.getQuotedSrcTag(), false);
        }
    }

    private static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }

    private static String quoteComment(String comment) {
        int len = comment.length();
        StringBuffer outBuffer = new StringBuffer(len + 10);
        block6: for (int x = 0; x < len; ++x) {
            char aChar = comment.charAt(x);
            switch (aChar) {
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block6;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block6;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block6;
                }
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block6;
                }
                default: {
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static String unquoteComment(String comment) {
        int len = comment.length();
        StringBuffer outBuffer = new StringBuffer(len);
        boolean lastWasQuote = false;
        for (int x = 0; x < len; ++x) {
            block9: {
                char aChar;
                block8: {
                    aChar = comment.charAt(x);
                    if (aChar == '\\') {
                        if (lastWasQuote) {
                            outBuffer.append('\\');
                        }
                        lastWasQuote = !lastWasQuote;
                        continue;
                    }
                    if (!lastWasQuote) break block8;
                    switch (aChar) {
                        case 'n': {
                            outBuffer.append('\n');
                            break block9;
                        }
                        case 'r': {
                            outBuffer.append('\r');
                            break block9;
                        }
                        case 'f': {
                            outBuffer.append('\f');
                            break block9;
                        }
                        default: {
                            throw new IllegalStateException("Found illegal quoting in " + comment);
                        }
                    }
                }
                outBuffer.append(aChar);
            }
            lastWasQuote = false;
        }
        return outBuffer.toString();
    }

    private String loadPropertyLine(String line) {
        int keyLen;
        int limit = line.length();
        int valueStart = limit;
        char c = '\u0000';
        boolean hasSep = false;
        boolean precedingBackslash = false;
        for (keyLen = 0; keyLen < limit; ++keyLen) {
            c = line.charAt(keyLen);
            if (!(c != '=' && c != ':' || precedingBackslash)) {
                valueStart = keyLen + 1;
                hasSep = true;
                break;
            }
            if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                valueStart = keyLen + 1;
                break;
            }
            precedingBackslash = c == '\\' ? !precedingBackslash : false;
        }
        while (valueStart < limit) {
            c = line.charAt(valueStart);
            if (c != ' ' && c != '\t' && c != '\f') {
                if (hasSep || c != '=' && c != ':') break;
                hasSep = true;
            }
            ++valueStart;
        }
        char[] lineBuf = line.toCharArray();
        String key = PropertiesFile.loadConvert(lineBuf, 0, keyLen);
        String value = PropertiesFile.loadConvert(lineBuf, valueStart, limit - valueStart);
        this.entries.put(key, value);
        return key;
    }

    private static String loadConvert(char[] in, int offset, int len) {
        StringBuilder out = new StringBuilder(len);
        int off = offset;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out.append((char)aChar);
                continue;
            }
            out.append((char)aChar);
        }
        return out.toString();
    }

    private static String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || x == len - 1 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(PropertiesFile.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(PropertiesFile.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(PropertiesFile.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(PropertiesFile.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    private static String trimLeadingWhitespace(String text) {
        for (int idx = 0; idx < text.length(); ++idx) {
            char c = text.charAt(idx);
            if (c == ' ' || c == '\t') continue;
            return text.substring(idx);
        }
        return "";
    }

    public static class MessageInfo {
        public static final String TAG_MSG_CONTEXT = "msg_context = ";
        public static final String TAG_MSG_TYPE = "msg_type = ";
        public static final String TAG_SRC_MSG = "src_msg = ";
        public static final String TAG_NEEDS_TRANSLATION = "NEEDS TRANSLATION";
        public static final String TAG_FUZZY = "FUZZY";
        private String context;
        private String msgType;
        private String srcMsg;
        private boolean needsTranslation = false;
        private boolean fuzzy = false;

        public String getContext() {
            return this.context;
        }

        public String getContextTag() {
            return TAG_MSG_CONTEXT + this.context;
        }

        public void setContext(String context) {
            this.context = context;
        }

        public String getMsgType() {
            return this.msgType;
        }

        public String getMsgTypeTag() {
            return TAG_MSG_TYPE + this.msgType;
        }

        public void setMsgType(String msgType) {
            this.msgType = msgType;
        }

        public String getQuotedSrcMsg() {
            return this.srcMsg;
        }

        public String getQuotedSrcTag() {
            return TAG_SRC_MSG + this.srcMsg;
        }

        public void setSrcMsg(String srcMsg) {
            this.srcMsg = PropertiesFile.saveConvert(srcMsg, false);
        }

        public boolean getNeedsTranslation() {
            return this.needsTranslation;
        }

        public String getNeedsTranslationTag() {
            return TAG_NEEDS_TRANSLATION;
        }

        public void setNeedsTranslation(boolean flag) {
            this.needsTranslation = flag;
        }

        public boolean getFuzzy() {
            return this.fuzzy;
        }

        public String getFuzzyTag() {
            return TAG_FUZZY;
        }

        public void setFuzzy(boolean flag) {
            this.fuzzy = flag;
        }

        public boolean getFromCommentLine(String comment) {
            if (comment.startsWith(TAG_SRC_MSG)) {
                this.srcMsg = comment.substring(TAG_SRC_MSG.length());
                return true;
            }
            if (comment.startsWith(TAG_MSG_TYPE)) {
                this.msgType = PropertiesFile.unquoteComment(comment.substring(TAG_MSG_TYPE.length()));
                return true;
            }
            if (comment.startsWith(TAG_MSG_CONTEXT)) {
                this.context = PropertiesFile.unquoteComment(comment.substring(TAG_MSG_CONTEXT.length()));
                return true;
            }
            if (comment.startsWith(TAG_NEEDS_TRANSLATION)) {
                this.needsTranslation = true;
                return true;
            }
            if (comment.startsWith(TAG_FUZZY)) {
                this.fuzzy = true;
                return true;
            }
            return false;
        }

        public boolean isEmpty() {
            return this.context == null && this.msgType == null && this.srcMsg == null && !this.needsTranslation && !this.fuzzy;
        }

        public String toString() {
            String flags;
            String string = flags = this.needsTranslation ? this.getNeedsTranslationTag() : null;
            if (this.fuzzy) {
                flags = flags == null ? this.getFuzzyTag() : flags + ", " + this.getFuzzyTag();
            }
            return this.getContextTag() + "\n" + this.getMsgTypeTag() + "\n" + this.getQuotedSrcTag() + (flags != null ? "\n" + flags : "");
        }
    }
}

