/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.i18n.tools;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.i18n.tools.PropertiesFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class UpdateTranslations {
    private static ArrayList<String> warnings = new ArrayList();

    public static void main(String[] args) throws IOException {
        String propFileName = "com.sap.jvm.profiling.i18n.messages".replace('.', '/') + ".properties";
        File propsFile = new File("java", propFileName);
        System.out.println("Using properties file " + propsFile);
        File mergeFile = null;
        if (args.length > 0) {
            if (args.length != 2 || !args[0].equals("-merge")) {
                UpdateTranslations.showUsageExit();
            }
            if (!(mergeFile = new File(args[1])).isFile()) {
                System.out.println("Could not find file to merge: " + args[1]);
                return;
            }
        }
        String translationFileName = "com.sap.jvm.profiling.i18n.messages".replace('.', '/') + "_de.properties.disabled";
        File translationFile = new File("java", translationFileName);
        System.out.println("Updating translation file " + translationFile);
        File backupFile = new File("java", translationFileName + ".bak");
        File backupFile2 = new File("java", translationFileName + ".bak2");
        if (backupFile2.exists()) {
            backupFile2.delete();
        }
        if (backupFile.exists()) {
            backupFile.renameTo(backupFile2);
        }
        if (!translationFile.renameTo(backupFile)) {
            System.err.println("Could not rename old translation file " + translationFile + " to create the backup file!");
            System.exit(0);
        }
        PropertiesFile translation = new PropertiesFile(backupFile);
        if (mergeFile != null) {
            PropertiesFile toMerge = new PropertiesFile(mergeFile);
            UpdateTranslations.merge(translation, toMerge, translationFile);
        } else {
            PropertiesFile src = new PropertiesFile(propsFile);
            UpdateTranslations.update(translation, src, translationFile);
        }
    }

    private static void merge(PropertiesFile translation, PropertiesFile toMerge, File destinationFile) throws IOException {
        int notMergedCount = 0;
        int conflictsCount = 0;
        int matchesCount = 0;
        int mergedCount = 0;
        for (String key : toMerge.getKeys()) {
            boolean fuzzy;
            boolean haveInfo;
            String toMergeMessage = toMerge.getProperty(key);
            PropertiesFile.MessageInfo toMergeInfo = toMerge.getMessageInfo(key);
            if (toMergeInfo == null || toMergeInfo.getNeedsTranslation() || toMergeInfo.getFuzzy()) continue;
            String oldKey = UpdateTranslations.findKey(key, translation);
            if (oldKey == null) {
                ++notMergedCount;
                continue;
            }
            PropertiesFile.MessageInfo translationInfo = translation.getMessageInfo(oldKey);
            String translatedMessage = translation.getProperty(oldKey);
            boolean exactMatch = key.equals(oldKey);
            boolean bl = haveInfo = translationInfo != null;
            if (!haveInfo) {
                UpdateTranslations.logWarning(key + " = " + translatedMessage + "\n  Found translated message, but no message info!");
            }
            boolean needsTranslation = !haveInfo || haveInfo && translationInfo.getNeedsTranslation();
            boolean bl2 = fuzzy = !exactMatch || haveInfo && translationInfo.getFuzzy();
            if (!needsTranslation) {
                if (!translatedMessage.equals(toMergeMessage)) {
                    UpdateTranslations.logWarning(key + ":: Found different message to merge:\n  translation: " + translatedMessage + "\n     to merge: " + toMergeMessage);
                    ++conflictsCount;
                }
                ++matchesCount;
                continue;
            }
            translation.setProperty(key, toMergeMessage);
            translationInfo.setNeedsTranslation(false);
            translationInfo.setFuzzy(fuzzy);
            translation.setMessageInfo(key, translationInfo);
            ++mergedCount;
        }
        System.out.println("\n\nMerged " + mergedCount + " messages and skipped " + notMergedCount + " messages without key in the destination file.");
        System.out.println("There were " + matchesCount + " messages with equal translations and " + conflictsCount + " messages with different translations.");
        if (warnings.size() != 0) {
            System.err.println("\nThere were warnings!\n");
            for (String msg : warnings) {
                System.err.println("\n" + msg);
            }
        }
        translation.saveToFile(destinationFile);
    }

    private static void update(PropertiesFile translation, PropertiesFile src, File destinationFile) throws IOException {
        int newMessages = 0;
        int translatedCount = 0;
        int fuzzyCount = 0;
        int untranslatedCount = 0;
        System.out.println("\nLegend:\n+ = new message\nN = found in old translation but needs translation\nE = there is a problem with that message\n");
        PropertiesFile updatedTranslation = new PropertiesFile();
        for (String key : src.getKeys()) {
            String message = src.getProperty(key);
            PropertiesFile.MessageInfo srcInfo = src.getMessageInfo(key);
            PropertiesFile.MessageInfo destInfo = new PropertiesFile.MessageInfo();
            String oldKey = UpdateTranslations.findKey(key, translation);
            if (oldKey == null) {
                System.out.println("+ " + key + " = " + message);
                updatedTranslation.setProperty(key, message);
                destInfo.setNeedsTranslation(true);
                ++newMessages;
                ++untranslatedCount;
            } else {
                boolean fuzzy;
                boolean haveInfo;
                PropertiesFile.MessageInfo translationInfo = translation.getMessageInfo(oldKey);
                String translatedMessage = translation.getProperty(oldKey);
                boolean exactMatch = key.equals(oldKey);
                boolean bl = haveInfo = translationInfo != null;
                if (!haveInfo) {
                    UpdateTranslations.logWarning(key + " = " + translatedMessage + "\n  Found translated message, but no message info!");
                }
                boolean needsTranslation = !haveInfo || haveInfo && translationInfo.getNeedsTranslation();
                boolean bl2 = fuzzy = !exactMatch || haveInfo && translationInfo.getFuzzy();
                if (!needsTranslation) {
                    updatedTranslation.setProperty(key, translatedMessage);
                    destInfo.setNeedsTranslation(false);
                    destInfo.setFuzzy(fuzzy);
                    if (fuzzy) {
                        System.out.println("F " + key + " = " + message);
                        ++fuzzyCount;
                    } else {
                        System.out.println("  " + key + " = " + message);
                        ++translatedCount;
                    }
                } else {
                    if (!translatedMessage.equals(message)) {
                        UpdateTranslations.logWarning(key + " = " + message + "\n  NEEDS TRANSLATION is set, but has translation " + translatedMessage);
                    } else {
                        System.out.println("N " + key + " = " + message);
                        ++untranslatedCount;
                    }
                    updatedTranslation.setProperty(key, translatedMessage);
                    destInfo.setNeedsTranslation(true);
                }
            }
            if (srcInfo != null) {
                destInfo.setContext(srcInfo.getContext());
                destInfo.setMsgType(srcInfo.getMsgType());
            }
            destInfo.setSrcMsg(message);
            updatedTranslation.setMessageInfo(key, destInfo);
            List<String> comments = src.getComments(key);
            if (comments.size() <= 0) continue;
            for (String comment : comments) {
                updatedTranslation.addComment(key, comment);
            }
        }
        System.out.println("\n\nFound " + newMessages + " new and " + (translatedCount + untranslatedCount) + " old (" + translatedCount + " translated, " + fuzzyCount + " fuzzy, " + untranslatedCount + " untranslated) messages.");
        if (warnings.size() != 0) {
            System.err.println("\nThere were warnings!\n");
            for (String msg : warnings) {
                System.err.println("\n" + msg);
            }
        }
        updatedTranslation.saveToFile(destinationFile);
    }

    private static void showUsageExit() {
        System.out.println("UpdateTranslations: update translation files from generated messages.properties\nfile. This will create a backup of the old translation file and then put the\nnew messages into the translation, marking them as NEEDS TRANSLATION, or as\nFUZZY, if a translation with the same message but a different text type was\nfound.\n\nUsage:\n   checkout messages_de.properties and run without arguments.\n\nMerging translations from other releases:\n   run with argument  \"-merge <other file>\"");
        System.exit(0);
    }

    private static String findKey(String key, PropertiesFile properties) {
        PropertiesFile.MessageInfo info = properties.getMessageInfo(key);
        if (info != null && !info.getNeedsTranslation()) {
            return key;
        }
        if (key.length() > 4 && key.charAt(4) == '_') {
            String unclassified = key.substring(5);
            PropertiesFile.MessageInfo fuzzyInfo = properties.getMessageInfo(unclassified);
            if (fuzzyInfo != null && !fuzzyInfo.getNeedsTranslation()) {
                return unclassified;
            }
            for (I18n.TextType type : I18n.TextType.values()) {
                String otherClassKey = type.name() + "_" + unclassified;
                fuzzyInfo = properties.getMessageInfo(otherClassKey);
                if (fuzzyInfo == null || fuzzyInfo.getNeedsTranslation()) continue;
                return otherClassKey;
            }
        } else {
            for (I18n.TextType type : I18n.TextType.values()) {
                String otherClassKey = type.name() + "_" + key;
                PropertiesFile.MessageInfo fuzzyInfo = properties.getMessageInfo(otherClassKey);
                if (fuzzyInfo == null || fuzzyInfo.getNeedsTranslation()) continue;
                return otherClassKey;
            }
        }
        return info == null ? null : key;
    }

    private static void logWarning(String msg) {
        warnings.add(msg);
        System.err.println("\nWARNING: " + msg);
    }
}

