/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.i18n.tools;

import com.sap.jvm.profiling.i18n.tools.PropertiesFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeSet;

public class XliffExport {
    public static final String INDENT = "  ";
    public static final String DEFAULT_TEXT_TYPE = "XMSG";

    public static final void export(File propertiesFile, File outputFile) throws IOException {
        PropertiesFile props = new PropertiesFile(propertiesFile);
        FileOutputStream fileOut = new FileOutputStream(outputFile);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)fileOut, "UTF-8");
        XliffExport.writeXliffHeader(out);
        XliffExport.writeFileHeader(out, propertiesFile.getCanonicalPath(), "en");
        XliffExport.writeMetaData(out);
        XliffExport.writeBody(out, props);
        XliffExport.writeFileFooter(out);
        XliffExport.writeXliffFooter(out);
        out.flush();
        out.close();
    }

    private static void writeMetaData(OutputStreamWriter out) throws IOException {
        String objectName = "SAP JVM Profiler Frontend Messages";
        String collection = "SAP JVM Profiler";
        String domain = "BC";
        String developer = "D043908";
        String description = "Messages for the SAP JVM Profiler UI";
        String origin = "//bas2/sapjvm/dev/common/java/src/profiling_2.2_i18n/java/com/sap/jvm/profiling/i18n/messages.properties";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
        Date creationTime = new Date();
        String dateText = dateFormat.format(creationTime) + "T" + timeFormat.format(creationTime) + "Z";
        String toolId = "urn:x-sap:sls-mlt:java:properties-converter";
        String toolName = "Java .properties File Converter";
        String toolVersion = "1.0.0";
        int indent = 2;
        XliffExport.writeln(out, indent++, "<header>");
        XliffExport.writeln(out, indent++, "<phase-group>");
        XliffExport.writeln(out, indent, "<phase company-name=\"SAP AG\" date=\"" + dateText + "\" phase-name=\"file-creation\" process-name=\"file-creation\" tool-id=\"" + toolId + "\"/>");
        XliffExport.writeln(out, --indent, "</phase-group>");
        XliffExport.writeln(out, indent, "<tool tool-company=\"SAP AG\" tool-id=\"" + toolId + "\" tool-name=\"" + toolName + "\" tool-version=\"" + toolVersion + "\"/>");
        XliffExport.writeln(out, indent++, "<sxmd:metadata xmlns:sxmd=\"urn:x-sap:mlt:xliff12:metadata:1.0\" xmlns=\"urn:x-sap:mlt:tsmetadata:1.0\">");
        XliffExport.writeln(out, indent, "<object-name>" + objectName + "</object-name>");
        XliffExport.writeln(out, indent, "<collection>" + collection + "</collection>");
        XliffExport.writeln(out, indent, "<domain>" + domain + "</domain>");
        XliffExport.writeln(out, indent, "<developer>" + developer + "</developer>");
        XliffExport.writeln(out, indent, "<description>" + description + "</description>);");
        XliffExport.writeln(out, indent, "<origin>" + origin + "</origin>");
        XliffExport.writeln(out, --indent, "</sxmd:metadata>");
        XliffExport.writeln(out, --indent, "</header>");
    }

    private static void writeBody(OutputStreamWriter out, PropertiesFile props) throws IOException {
        int indent = 2;
        XliffExport.writeln(out, indent, "<body>");
        for (String key : new TreeSet<String>(props.getKeys())) {
            XliffExport.writeTransUnit(out, indent + 1, key, props.getProperty(key), props.getMessageInfo(key));
        }
        XliffExport.writeln(out, indent, "</body>");
    }

    private static void writeTransUnit(OutputStreamWriter out, int indent, String key, String sourceMsg, PropertiesFile.MessageInfo messageInfo) throws IOException {
        String context;
        String textType = XliffExport.getTextType(key);
        boolean isMessageFormat = XliffExport.isMessageFormat(sourceMsg);
        String convertedMessage = XliffExport.convertMessage(sourceMsg, isMessageFormat);
        XliffExport.writeln(out, indent, "<trans-unit xmlns:sap=\"urn:x-sap:sls-mlt\" id=\"" + key + "\"");
        if (isMessageFormat) {
            XliffExport.writeln(out, indent, "            datatype=\"x-urn:x-sap:sls-mlt:java:messageformat\"");
        }
        XliffExport.writeln(out, indent, "            resname=\"" + key + "\" sap:sc=\"" + textType + "\">");
        XliffExport.writeln(out, indent + 1, "<source>" + convertedMessage + "</source>");
        if (messageInfo != null && (context = messageInfo.getContext()) != null) {
            XliffExport.writeln(out, indent + 1, "<note>Context info: " + XliffExport.escapeSpecialChars(context) + "</note>");
        }
        XliffExport.writeln(out, indent, "</trans-unit>");
    }

    private static String convertMessage(String sourceMsg, boolean isMessageFormat) {
        String msg = XliffExport.escapeSpecialChars(sourceMsg);
        if (!isMessageFormat) {
            return msg;
        }
        StringBuilder result = new StringBuilder(sourceMsg.length() * 2);
        StringBuilder braceContent = new StringBuilder();
        boolean inBraces = false;
        for (int i = 0; i < sourceMsg.length(); ++i) {
            char c = sourceMsg.charAt(i);
            if (c == '{') {
                if (inBraces) {
                    throw new IllegalStateException("Nested {-braces not supported yet!");
                }
                inBraces = true;
                braceContent.append(c);
                continue;
            }
            if (c == '}') {
                if (!inBraces) {
                    throw new IllegalStateException("Closing }-brace without matching {");
                }
                inBraces = false;
                braceContent.append(c);
                result.append(XliffExport.convertPlaceholder(braceContent.toString()));
                braceContent.setLength(0);
                continue;
            }
            if (inBraces) {
                braceContent.append(c);
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private static Object convertPlaceholder(String placeholder) {
        char c;
        StringBuilder indexText = new StringBuilder();
        for (int i = 1; i < placeholder.length() - 1 && (c = placeholder.charAt(i)) >= '0' && c <= '9'; ++i) {
            indexText.append(c);
        }
        if (indexText.length() > 0) {
            int index = 1 + Integer.parseInt(indexText.toString());
            return "<ph id=\"" + index + "\">" + placeholder + "</ph>";
        }
        System.err.println("Malformed placeholder text " + placeholder + " found!");
        return placeholder;
    }

    private static boolean isMessageFormat(String msg) {
        int idx = 0;
        while ((idx = msg.indexOf(123, idx)) >= 0) {
            char c = msg.charAt(idx + 1);
            if ('0' > c || '9' < c) continue;
            return true;
        }
        return false;
    }

    private static String getTextType(String key) {
        if (key.length() > 4 && key.charAt(4) == '_') {
            return key.substring(0, 4);
        }
        return DEFAULT_TEXT_TYPE;
    }

    private static void writeFileHeader(OutputStreamWriter out, String original, String sourceLang) throws IOException {
        XliffExport.writeln(out, 1, "<file datatype=\"javapropertyresourcebundle\"");
        XliffExport.writeln(out, 1, "      original=\"" + original + "\"");
        XliffExport.writeln(out, 1, "      source-language=\"" + sourceLang + "\">");
    }

    private static void writeFileFooter(OutputStreamWriter out) throws IOException {
        XliffExport.writeln(out, 1, "</file>");
    }

    private static void writeXliffHeader(OutputStreamWriter out) throws IOException {
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        out.write("<xliff xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" version=\"1.2\">)\n");
    }

    private static void writeXliffFooter(OutputStreamWriter out) throws IOException {
        out.write("</xliff>");
    }

    private static void writeln(OutputStreamWriter out, int indent, String line) throws IOException {
        for (int i = 0; i < indent; ++i) {
            out.write(INDENT);
        }
        out.write(line);
        out.write("\n");
    }

    private static String escapeSpecialChars(String input) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '<') {
                result.append("&lt;");
                continue;
            }
            if (c == '>') {
                result.append("&gt;");
                continue;
            }
            if (c == '&') {
                result.append("&amp;");
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static void main(String[] args) throws IOException {
        String propFileName = "com.sap.jvm.profiling.i18n.messages".replace('.', '/') + ".properties";
        File propsFile = new File("java", propFileName);
        String xliffFileName = "com.sap.jvm.profiling.i18n.messages".replace('.', '/') + ".xlf";
        File xliffFile = new File("java", xliffFileName);
        XliffExport.export(propsFile, xliffFile);
    }
}

