/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl;

import com.sap.jvm.profiling.api.AllocationTraceSpec;
import com.sap.jvm.profiling.api.MethodParameterSpec;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.impl.ProfilingTraceSpecImpl;
import com.sap.jvm.profiling.memory.command.AllocationTraceConfiguration;
import com.sap.jvm.profiling.memory.command.AllocationTraceType;
import java.util.List;

public class AllocationTraceSpecImpl
extends ProfilingTraceSpecImpl {
    private AllocationTraceSpec spec;

    public AllocationTraceSpecImpl(AllocationTraceSpec spec) {
        this.spec = spec;
    }

    @Override
    Command getEnableCommand() {
        AllocationTraceConfiguration config = new AllocationTraceConfiguration(AllocationTraceType.NO_OBJECT_IDS);
        config.setAllocatedObjectThreadFilter(this.createThreadFilter());
        List<MethodParameterSpec> parameters = this.spec.getMethodParameters();
        if (this.spec.getAdaptive()) {
            if (parameters != null && !parameters.isEmpty()) {
                return memCmdFactory.createEnableAdaptiveAllocationMptTraceCommand(config, AllocationTraceSpecImpl.convertParameters(parameters), true, true, true, false);
            }
            return memCmdFactory.createEnableAdaptiveAllocationTraceCommand(config);
        }
        if (parameters != null && !parameters.isEmpty()) {
            return memCmdFactory.createEnableAllocationMptTraceCommand(config, AllocationTraceSpecImpl.convertParameters(parameters), true, true, true, false);
        }
        return memCmdFactory.createEnableAllocationTraceCommand(config);
    }

    @Override
    Command getDisableCommand() {
        List<MethodParameterSpec> parameters = this.spec.getMethodParameters();
        if (parameters == null || parameters.isEmpty()) {
            return memCmdFactory.createDisableAllocationTraceCommand();
        }
        return memCmdFactory.createDisableAllocationMptTraceCommand();
    }
}

