/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl;

import com.sap.jvm.profiling.ConnectionListener;
import com.sap.jvm.profiling.DebuggingConnection;
import com.sap.jvm.profiling.core.ProfilingVersion;
import com.sap.jvm.profiling.exception.UnsupportedVersionException;
import com.sap.jvm.profiling.exception.WriteFailedException;
import com.sap.jvm.profiling.impl.CommandHandlerImpl;
import com.sap.jvm.profiling.impl.DebuggingConnectionInputStream;
import com.sap.jvm.profiling.impl.control.command.FlushCommandImpl;
import com.sap.jvm.profiling.impl.control.command.StartProfilingCommandImpl;
import com.sap.jvm.tracing.Trace;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.net.Socket;
import java.net.SocketException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public final class DebuggingConnectionImpl
implements DebuggingConnection {
    public static final int JDWP_PROFILING_COMMAND_SET = 128;
    private static final int JDWP_HEADER_LENGTH = 11;
    private static final int JDWP_PROFILING_COMMAND = 1;
    private static final byte[] END_OF_STREAM = new byte[]{-1};
    private static final int SUPPORTED_VM_YEAR = 2007;
    private static final int SUPPORTED_VM_MONTH = 5;
    private static final int SUPPORTED_VM_DAY = 16;
    public static final byte[] JDWP_HANDSHAKE = new byte[]{74, 68, 87, 80, 45, 72, 97, 110, 100, 115, 104, 97, 107, 101};
    private static final byte[] VERSION_INFO_PACKET = new byte[]{0, 0, 0, 11, 88, 88, 88, 88, 0, 1, 1};
    private static final Map<String, Integer> MONTH_MAP = new HashMap<String, Integer>();
    private static final long JDWP_HANDSHAKE_TIMEOUT_DEFAULT = 10000L;
    private static final long JDWP_HANDSHAKE_TIMEOUT;
    private static final int PLAIN_FILE_ENCODING = 2;
    private static final int PLAIN_FILE_WITH_HEADER_ENCODING = 3;
    private static final int PLAIN_FILE_WITH_HEADER_MAGIC = -1091581234;
    private final List<ConnectionListener> listeners = new ArrayList<ConnectionListener>();
    private Socket socket;
    private boolean isOpen = true;
    private InputStream inputStream;
    private OutputStream outputStream;
    private List<byte[]> profilingPacketList = new ArrayList<byte[]>();
    private List<byte[]> debuggingPacketList = new ArrayList<byte[]>();
    private OutputStream backupOutputStream;
    private long writtenBackupBytes;
    private final String backupFileName;
    private ProfilingVersion version;
    private Thread readerThread;
    private boolean stopWritingBackupFile = false;
    private boolean isSupportedVM = true;
    private byte[] failedBytes = null;
    private byte[] failedPacket = null;
    private byte[] firstProfilingPacket;

    public DebuggingConnectionImpl(String hostname, int port, boolean withDebugging, String backupFileName) throws IOException {
        this.socket = new Socket(hostname, port);
        this.inputStream = this.socket.getInputStream();
        this.outputStream = this.socket.getOutputStream();
        this.backupFileName = backupFileName;
        if (backupFileName != null) {
            this.backupOutputStream = new BufferedOutputStream(new FileOutputStream(backupFileName));
        }
        this.performHandshake();
        this.startProfiling();
    }

    public DebuggingConnectionImpl(InputStream in, OutputStream out, boolean withDebugging, String backupFileName) throws IOException {
        this.inputStream = in;
        this.outputStream = out;
        this.backupFileName = backupFileName;
        if (backupFileName != null) {
            this.backupOutputStream = new BufferedOutputStream(new FileOutputStream(backupFileName));
        }
        this.startProfiling();
    }

    private void closeAndRemove() {
        File f;
        try {
            this.close();
        }
        catch (IOException e) {
            Trace.warn((Throwable)e, "Could not close the connection");
        }
        if (this.backupOutputStream != null && !(f = new File(this.backupFileName)).delete()) {
            f.deleteOnExit();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.isOpen) {
            return;
        }
        try {
            for (ConnectionListener listener : this.listeners) {
                listener.closing();
            }
            this.inputStream.close();
            this.outputStream.close();
            if (this.socket != null) {
                this.socket.close();
            }
        }
        finally {
            this.isOpen = false;
        }
        try {
            this.readerThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.backupOutputStream != null) {
            this.backupOutputStream.close();
        }
        for (ConnectionListener listener : this.listeners) {
            listener.closed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readDebuggingPacket() throws IOException {
        List<byte[]> list = this.debuggingPacketList;
        synchronized (list) {
            while (this.debuggingPacketList.isEmpty()) {
                try {
                    this.debuggingPacketList.wait();
                }
                catch (InterruptedException ex) {
                    Trace.error((Throwable)ex, "Interrupted waiting on debugging packet list");
                }
            }
            byte[] packet = this.debuggingPacketList.remove(0);
            if (packet == END_OF_STREAM) {
                throw new EOFException();
            }
            return packet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readProfilingPacket() throws IOException {
        byte[] packet = null;
        if (this.firstProfilingPacket != null) {
            packet = this.firstProfilingPacket;
            this.firstProfilingPacket = null;
            return packet;
        }
        if (this.failedBytes != null) {
            try {
                this.backupOutputStream.write(this.failedBytes);
                this.failedBytes = null;
            }
            catch (IOException ex) {
                throw new WriteFailedException("Write operation to profiling backup file failed.", ex);
            }
            if (this.failedPacket != null) {
                packet = this.failedPacket;
                this.failedPacket = null;
                return packet;
            }
        }
        List<byte[]> ex = this.profilingPacketList;
        synchronized (ex) {
            while (this.profilingPacketList.isEmpty()) {
                try {
                    this.profilingPacketList.wait();
                }
                catch (InterruptedException ex2) {
                    Trace.error((Throwable)ex2, "Interrupted waiting on profiling packet list");
                }
            }
            packet = this.profilingPacketList.remove(0);
        }
        if (packet == END_OF_STREAM) {
            return null;
        }
        int packetLength = packet.length;
        if (packet[9] == 0 && packet[10] == 0) {
            if (!this.isSupportedVM) {
                this.version = new ProfilingVersion(0, 0, 0);
            }
            return this.readProfilingPacket();
        }
        if ((packet[9] & 0xFF) == 128 && (packet[10] & 0xFF) == 1) {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(packet, 11, packetLength - 11));
            int majorVersion = dis.readUnsignedShort();
            int minorVersion = dis.readUnsignedShort();
            int microVersion = dis.readUnsignedShort();
            if (this.version == null) {
                this.version = new ProfilingVersion(majorVersion, minorVersion, microVersion);
            }
            if (this.backupOutputStream != null) {
                if (this.writtenBackupBytes != 0L) {
                    this.stopWritingBackupFile = true;
                    return this.readProfilingPacket();
                }
                ByteArrayOutputStream tmpBackupDataStream = new ByteArrayOutputStream();
                DataOutputStream tmpDos = new DataOutputStream(tmpBackupDataStream);
                tmpDos.write(3);
                tmpDos.writeInt(-1091581234);
                tmpDos.writeShort(packetLength - 11 + 7);
                tmpDos.write(packet, 11, packetLength - 11);
                byte[] backupData = tmpBackupDataStream.toByteArray();
                try {
                    this.backupOutputStream.write(backupData);
                    this.writtenBackupBytes += (long)backupData.length;
                }
                catch (IOException ex3) {
                    this.failedBytes = backupData;
                    throw new WriteFailedException("Write operation to profiling backup file failed.", ex3);
                }
            }
            return this.readProfilingPacket();
        }
        if (!this.stopWritingBackupFile && this.backupOutputStream != null && (packet[9] & 0xFF) == 128) {
            if (this.writtenBackupBytes == 0L) {
                try {
                    this.backupOutputStream.write(2);
                    ++this.writtenBackupBytes;
                }
                catch (IOException ex4) {
                    this.failedBytes = new byte[1 + packetLength - 11];
                    this.failedBytes[0] = 2;
                    System.arraycopy(packet, 11, this.failedBytes, 1, packetLength - 11);
                    this.failedPacket = packet;
                    throw new WriteFailedException("Write operation to profiling backup file failed.", ex4);
                }
            }
            try {
                this.backupOutputStream.write(packet, 11, packetLength - 11);
                this.writtenBackupBytes += (long)(packetLength - 11);
            }
            catch (IOException ex5) {
                this.failedBytes = new byte[packetLength - 11];
                System.arraycopy(packet, 11, this.failedBytes, 0, packetLength - 11);
                this.failedPacket = packet;
                throw new WriteFailedException("Write operation to profiling backup file failed.", ex5);
            }
        }
        return packet;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] packet) throws IOException {
        OutputStream outputStream = this.outputStream;
        synchronized (outputStream) {
            this.outputStream.write(packet);
            this.outputStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeProfilingPacket(byte[] profilingPacket) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        byteStream.write(new byte[11]);
        byteStream.write(profilingPacket);
        byte[] jdwpBytes = byteStream.toByteArray();
        int packetLength = jdwpBytes.length;
        jdwpBytes[0] = (byte)(packetLength >>> 24 & 0xFF);
        jdwpBytes[1] = (byte)(packetLength >>> 16 & 0xFF);
        jdwpBytes[2] = (byte)(packetLength >>> 8 & 0xFF);
        jdwpBytes[3] = (byte)(packetLength >>> 0 & 0xFF);
        jdwpBytes[9] = -128;
        jdwpBytes[10] = 1;
        try {
            OutputStream outputStream = this.outputStream;
            synchronized (outputStream) {
                this.outputStream.write(jdwpBytes);
                this.outputStream.flush();
            }
        }
        catch (SocketException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void addListener(ConnectionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void flushBackupFile() throws IOException {
        if (this.backupOutputStream != null) {
            this.backupOutputStream.flush();
        }
    }

    @Override
    public long getBackupFileLength() {
        if (this.backupOutputStream == null) {
            return 0L;
        }
        return this.writtenBackupBytes;
    }

    @Override
    public String getBackupFileName() {
        return this.backupFileName;
    }

    @Override
    public ProfilingVersion getVersion() {
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertPacket(byte[] packet) {
        List<byte[]> list = this.profilingPacketList;
        synchronized (list) {
            this.profilingPacketList.add(packet);
            this.profilingPacketList.notifyAll();
        }
    }

    private void performHandshake() throws IOException {
        HandshakePerformer hp = new HandshakePerformer();
        Thread t = new Thread((Runnable)hp, "JDWP-Handshake");
        t.setDaemon(true);
        t.start();
        try {
            t.join(JDWP_HANDSHAKE_TIMEOUT);
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupt during handshake", e);
        }
        if (!hp.finished()) {
            t.interrupt();
            throw new IOException("Handshake timed out");
        }
        if (hp.getException() != null) {
            throw hp.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProfiling() throws IOException {
        OutputStream outputStream = this.outputStream;
        synchronized (outputStream) {
            this.outputStream.write(VERSION_INFO_PACKET);
            CommandHandlerImpl commandHandler = new CommandHandlerImpl(this);
            StartProfilingCommandImpl startCommand = new StartProfilingCommandImpl();
            commandHandler.sendCommand(startCommand);
            FlushCommandImpl flushCommand = new FlushCommandImpl();
            commandHandler.sendCommand(flushCommand);
        }
        this.readerThread = new ConnectionReaderThread("ProfilingPacketReaderThread");
        this.readerThread.start();
        this.firstProfilingPacket = this.readProfilingPacket();
        if (this.version == null) {
            this.closeAndRemove();
            throw new IOException("No version information available.");
        }
        if (!this.version.isCompatible(1, 6, 0)) {
            this.closeAndRemove();
            throw new UnsupportedVersionException("Version is not supported: " + this.version.toString(), this.version);
        }
    }

    private byte[] readPacket() throws IOException {
        DataInputStream stream = new DataInputStream(this.inputStream);
        int packetLength = stream.readInt();
        if (packetLength < 11) {
            throw new IOException("JDWP Packet under 11 bytes");
        }
        byte[] packet = new byte[packetLength];
        packet[0] = (byte)(packetLength >>> 24 & 0xFF);
        packet[1] = (byte)(packetLength >>> 16 & 0xFF);
        packet[2] = (byte)(packetLength >>> 8 & 0xFF);
        packet[3] = (byte)(packetLength >>> 0 & 0xFF);
        stream.readFully(packet, 4, packetLength - 4);
        return packet;
    }

    private static boolean checkVersion(String vmDescription) {
        try {
            StringTokenizer tok = new StringTokenizer(vmDescription, "\n");
            tok.nextToken();
            tok.nextToken();
            String versionInfo = tok.nextToken();
            tok = new StringTokenizer(versionInfo, "(");
            tok.nextToken();
            String buildInfo = tok.nextToken();
            tok = new StringTokenizer(buildInfo, ",");
            tok.nextToken();
            String dateInfo = tok.nextToken();
            tok = new StringTokenizer(dateInfo);
            String monthStr = tok.nextToken();
            String dayStr = tok.nextToken();
            String yearStr = tok.nextToken();
            int day = Integer.parseInt(dayStr);
            int year = Integer.parseInt(yearStr);
            int month = MONTH_MAP.get(monthStr);
            if (year < 2007) {
                return false;
            }
            if (year > 2007) {
                return true;
            }
            if (month < 5) {
                return false;
            }
            if (month > 5) {
                return true;
            }
            if (day < 16) {
                return false;
            }
        }
        catch (NumberFormatException | NoSuchElementException ex) {
            Trace.error((Throwable)ex, "Could not check version");
        }
        return true;
    }

    private static String readUTF(DataInputStream inputStream) throws IOException {
        int c;
        int count;
        int utflen = inputStream.readInt();
        byte[] bytearr = null;
        char[] chararr = null;
        bytearr = new byte[utflen * 2];
        chararr = new char[utflen * 2];
        int chararr_count = 0;
        inputStream.readFully(bytearr, 0, utflen);
        for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararr_count++] = (char)c;
        }
        block6: while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count + " (" + new String(chararr, 0, chararr_count) + ")");
        }
        return new String(chararr, 0, chararr_count);
    }

    @Override
    public InputStream getProfilingInputStream() {
        return new DebuggingConnectionInputStream(this);
    }

    static {
        MONTH_MAP.put("Jan", 1);
        MONTH_MAP.put("Feb", 2);
        MONTH_MAP.put("Mar", 3);
        MONTH_MAP.put("Apr", 4);
        MONTH_MAP.put("May", 5);
        MONTH_MAP.put("Jun", 6);
        MONTH_MAP.put("Jul", 7);
        MONTH_MAP.put("Aug", 8);
        MONTH_MAP.put("Sep", 9);
        MONTH_MAP.put("Oct", 10);
        MONTH_MAP.put("Nov", 11);
        MONTH_MAP.put("Dec", 12);
        String jdwpTimeoutProp = AccessController.doPrivileged(() -> System.getProperty("com.sap.jvm.JDWPHandshakeTimeout"));
        long handshakeTimeout = 10000L;
        try {
            handshakeTimeout = Long.parseLong(jdwpTimeoutProp);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        JDWP_HANDSHAKE_TIMEOUT = handshakeTimeout;
    }

    private class ConnectionReaderThread
    extends Thread {
        ConnectionReaderThread(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    List packetList;
                    byte[] packet;
                    if ((packet = DebuggingConnectionImpl.this.readPacket()) == null) {
                        return;
                    }
                    List list = packetList = (packet[9] & 0xFF) == 128 ? DebuggingConnectionImpl.this.profilingPacketList : DebuggingConnectionImpl.this.debuggingPacketList;
                    if (packet[4] == 88 && packet[5] == 88 && packet[6] == 88 && packet[7] == 88) {
                        DataInputStream tmpStream = new DataInputStream(new ByteArrayInputStream(packet, 11, packet.length - 11));
                        String description = DebuggingConnectionImpl.readUTF(tmpStream);
                        DebuggingConnectionImpl.this.isSupportedVM = DebuggingConnectionImpl.checkVersion(description);
                        packetList = DebuggingConnectionImpl.this.profilingPacketList;
                    }
                    List list2 = packetList;
                    synchronized (list2) {
                        packetList.add(packet);
                        packetList.notify();
                    }
                }
            }
            catch (IOException ex) {
                List list = DebuggingConnectionImpl.this.profilingPacketList;
                synchronized (list) {
                    DebuggingConnectionImpl.this.profilingPacketList.add(END_OF_STREAM);
                    DebuggingConnectionImpl.this.profilingPacketList.notify();
                }
                list = DebuggingConnectionImpl.this.debuggingPacketList;
                synchronized (list) {
                    DebuggingConnectionImpl.this.debuggingPacketList.add(END_OF_STREAM);
                    DebuggingConnectionImpl.this.debuggingPacketList.notify();
                    return;
                }
            }
        }
    }

    private class HandshakePerformer
    implements Runnable {
        private IOException ex = null;
        private volatile boolean isFinished = false;

        private HandshakePerformer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int bytesRead;
                byte[] handshakeFromBackend = new byte[JDWP_HANDSHAKE.length];
                DebuggingConnectionImpl.this.outputStream.write(JDWP_HANDSHAKE);
                DebuggingConnectionImpl.this.outputStream.flush();
                for (int offset = 0; offset < handshakeFromBackend.length; offset += bytesRead) {
                    bytesRead = DebuggingConnectionImpl.this.inputStream.read(handshakeFromBackend);
                    if (bytesRead >= 0) continue;
                    throw new IOException("Error reading JDWP handshake.");
                }
                if (!Arrays.equals(handshakeFromBackend, JDWP_HANDSHAKE)) {
                    DebuggingConnectionImpl.this.outputStream.close();
                    DebuggingConnectionImpl.this.inputStream.close();
                    throw new IOException("Illegal handshake received.");
                }
            }
            catch (IOException e) {
                this.ex = e;
            }
            finally {
                this.isFinished = true;
            }
        }

        public boolean finished() {
            return this.isFinished;
        }

        public IOException getException() {
            return this.ex;
        }
    }
}

