/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl;

import com.sap.jvm.profiling.DebuggingConnection;
import java.io.IOException;
import java.io.InputStream;

public class DebuggingConnectionInputStream
extends InputStream {
    private static final int JDWP_HEADER_SIZE = 11;
    private int availableBytesInPacket = 0;
    private int offset = 0;
    private byte[] packet;
    private final DebuggingConnection connection;

    public DebuggingConnectionInputStream(DebuggingConnection connection) {
        this.connection = connection;
    }

    @Override
    public int read() throws IOException {
        int retValue = -1;
        if (this.availableBytesInPacket <= 0) {
            this.packet = this.connection.readProfilingPacket();
            if (this.packet == null) {
                return -1;
            }
            this.availableBytesInPacket = this.packet.length - 11;
            this.offset = 11;
        }
        assert (this.availableBytesInPacket > 0);
        retValue = this.packet[this.offset] & 0xFF;
        --this.availableBytesInPacket;
        ++this.offset;
        return retValue;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int currentRead;
        for (currentRead = 0; currentRead < len; ++currentRead) {
            if (currentRead > 0 && this.availableBytesInPacket == 0) {
                return currentRead;
            }
            int nextByte = this.read();
            if (nextByte == -1) break;
            b[off + currentRead] = (byte)nextByte;
        }
        return currentRead == 0 ? -1 : currentRead;
    }
}

