/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl;

import com.sap.jvm.profiling.CommandHandler;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.api.ProfilingOperationSpec;
import com.sap.jvm.profiling.api.ProfilingOperationSpecImplInterface;
import com.sap.jvm.profiling.api.ProfilingRun;
import com.sap.jvm.profiling.api.ProfilingTraceSpec;
import com.sap.jvm.profiling.api.ProfilingTraceSpecImplInterface;
import com.sap.jvm.profiling.api.Response;
import com.sap.jvm.profiling.api.VmProfiling;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.core.command.CoreCommandFactory;
import com.sap.jvm.profiling.core.command.SnapshotMarkerCommand;
import com.sap.jvm.profiling.impl.ProfilingOperationSpecImpl;
import com.sap.jvm.profiling.impl.ProfilingTraceSpecImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;

public final class ProfilingRunImpl
extends ProfilingRun {
    private static final CoreCommandFactory coreCmdFactory = ProfilingFactory.createCoreCommandFactory();
    private OutputStream outputStream;
    private CommandHandler commandHandler;
    private final String filename;
    private int maxRuntime = 3600;
    private Command disableCmdForActiveTrace;
    private boolean stopped;
    private boolean started;
    private Timer timer;

    @Override
    public synchronized int getMaxRuntime() {
        return this.maxRuntime;
    }

    @Override
    public synchronized boolean isStopped() {
        return this.stopped;
    }

    @Override
    public synchronized void setMaxRuntime(int maxRuntime) {
        if (this.started) {
            throw new IllegalStateException("The profiling run has been already started.");
        }
        if (maxRuntime <= 0) {
            throw new IllegalArgumentException("The parameter \"maxRuntime\" must be greater than 0.");
        }
        this.maxRuntime = maxRuntime;
    }

    @Override
    public synchronized Response start() {
        if (this.started) {
            throw new IllegalStateException("The profiling run has been already started.");
        }
        return this.init(null);
    }

    private ProfilingTraceSpecImpl checkExtractTraceParam(ProfilingTraceSpec trace) throws IllegalArgumentException {
        if (trace == null) {
            throw new IllegalArgumentException("The parameter \"trace\" is null.");
        }
        ProfilingTraceSpecImplInterface traceImpl = trace.getImpl();
        if (traceImpl == null) {
            throw new IllegalArgumentException("The associated implementation object of parameter \"trace\" is null.");
        }
        if (!(traceImpl instanceof ProfilingTraceSpecImpl)) {
            throw new IllegalArgumentException("The asociated implementation object of parameter \"trace\" is not of type ProfilingTraceSpecImpl.");
        }
        return (ProfilingTraceSpecImpl)traceImpl;
    }

    @Override
    public synchronized Response start(ProfilingTraceSpec trace) {
        if (this.started) {
            throw new IllegalStateException("The profiling run has been already started.");
        }
        ProfilingTraceSpecImpl traceImpl = this.checkExtractTraceParam(trace);
        Response retValue = this.init(traceImpl.getEnableCommand());
        if (retValue.isSuccess()) {
            this.disableCmdForActiveTrace = traceImpl.getDisableCommand();
        }
        return retValue;
    }

    @Override
    public synchronized Response enableTrace(ProfilingTraceSpec trace) {
        if (this.stopped) {
            throw new IllegalStateException("The profiling run has been already stopped.");
        }
        if (!this.started) {
            throw new IllegalStateException("The profiling run has not been started yet.");
        }
        if (this.disableCmdForActiveTrace != null) {
            throw new IllegalStateException("There is a currently active trace.");
        }
        ProfilingTraceSpecImpl traceImpl = this.checkExtractTraceParam(trace);
        try {
            this.commandHandler.sendCommand(traceImpl.getEnableCommand());
        }
        catch (IOException ex) {
            return new ResponseImpl(false);
        }
        this.disableCmdForActiveTrace = traceImpl.getDisableCommand();
        return new ResponseImpl(true);
    }

    private ProfilingOperationSpecImpl checkExtractOperationParam(ProfilingOperationSpec op) throws IllegalArgumentException {
        if (op == null) {
            throw new IllegalArgumentException("The parameter \"op\" is null.");
        }
        ProfilingOperationSpecImplInterface opImpl = op.getImpl();
        if (opImpl == null) {
            throw new IllegalArgumentException("The associated implementation object of parameter \"op\" is null.");
        }
        if (!(opImpl instanceof ProfilingOperationSpecImpl)) {
            throw new IllegalArgumentException("The asociated implementation object of parameter \"op\" is not of type ProfilingOperationSpecImpl.");
        }
        return (ProfilingOperationSpecImpl)opImpl;
    }

    @Override
    public synchronized Response perform(ProfilingOperationSpec op) {
        if (this.stopped) {
            throw new IllegalStateException("The profiling run has been already stopped.");
        }
        if (!this.started) {
            throw new IllegalStateException("The profiling run has not been started yet.");
        }
        ProfilingOperationSpecImpl opImpl = this.checkExtractOperationParam(op);
        try {
            this.commandHandler.sendCommand(opImpl.getCommand());
        }
        catch (IOException ex) {
            return new ResponseImpl(false);
        }
        return new ResponseImpl(true);
    }

    @Override
    public synchronized Response disableTrace() {
        if (this.stopped) {
            throw new IllegalStateException("The profiling run has already been stopped.");
        }
        if (!this.started) {
            throw new IllegalStateException("The profiling run has not been started yet.");
        }
        if (this.disableCmdForActiveTrace == null) {
            return new ResponseImpl(true);
        }
        try {
            this.commandHandler.sendCommand(this.disableCmdForActiveTrace);
            this.disableCmdForActiveTrace = null;
        }
        catch (IOException ex) {
            return new ResponseImpl(false);
        }
        return new ResponseImpl(true);
    }

    @Override
    public synchronized Response createSnapshot(String name) {
        if (this.stopped) {
            throw new IllegalStateException("The profiling run has been already stopped.");
        }
        if (!this.started) {
            throw new IllegalStateException("The profiling run has not been started yet.");
        }
        if (this.disableCmdForActiveTrace == null) {
            return new ResponseImpl(false);
        }
        String snapshotName = name == null ? "New Snapshot" : name;
        SnapshotMarkerCommand cmd = coreCmdFactory.createSnapshotMarkerCommand(ProfilingTraceType.ALL_TRACES, snapshotName, true);
        try {
            this.commandHandler.sendCommand(cmd);
        }
        catch (IOException ex) {
            return new ResponseImpl(false);
        }
        return new ResponseImpl(true);
    }

    @Override
    public synchronized Response stop() {
        if (this.stopped) {
            throw new IllegalStateException("The profiling run has been already stopped.");
        }
        if (!this.started) {
            throw new IllegalStateException("The profiling run has not been started yet.");
        }
        try {
            this.outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.outputStream = null;
        this.commandHandler = null;
        this.stopped = true;
        this.disableCmdForActiveTrace = null;
        this.timer.cancel();
        return new ResponseImpl(true);
    }

    ProfilingRunImpl(String filename) {
        assert (filename != null);
        this.filename = filename;
    }

    private Response init(Command command) {
        this.outputStream = VmProfiling.startProfiling(this.filename);
        this.commandHandler = ProfilingFactory.createCommandHandler(this.outputStream);
        this.started = true;
        if (this.outputStream == null) {
            return new ResponseImpl(false);
        }
        try {
            this.commandHandler.sendCommand(coreCmdFactory.createEnableHeartBeatCommand());
            if (command != null) {
                this.commandHandler.sendCommand(command);
            }
        }
        catch (IOException ex) {
            return new ResponseImpl(false);
        }
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new ProfilingTimerTask(), this.maxRuntime * 1000);
        return new ResponseImpl(true);
    }

    private class ProfilingTimerTask
    extends TimerTask {
        private ProfilingTimerTask() {
        }

        @Override
        public void run() {
            try {
                ProfilingRunImpl.this.stop();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private static class ResponseImpl
    implements Response {
        private boolean success;

        public ResponseImpl(boolean success) {
            this.success = success;
        }

        @Override
        public boolean isSuccess() {
            return this.success;
        }
    }
}

