/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl;

import com.sap.jvm.monitor.vm.ThreadAnnotationKey;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.api.IncludeType;
import com.sap.jvm.profiling.api.MethodParameterSpec;
import com.sap.jvm.profiling.api.ProfilingTraceSpecImplInterface;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.io.command.IOCommandFactory;
import com.sap.jvm.profiling.memory.command.MemoryCommandFactory;
import com.sap.jvm.profiling.method.command.MethodCommandFactory;
import com.sap.jvm.profiling.method.command.RequestedMethodParameter;
import com.sap.jvm.profiling.method.response.MethodParameterIncludeType;
import com.sap.jvm.profiling.net.command.NetworkCommandFactory;
import com.sap.jvm.profiling.sync.command.SynchronizationCommandFactory;
import com.sap.jvm.profiling.thread.command.ThreadCommandFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ProfilingTraceSpecImpl
implements ProfilingTraceSpecImplInterface {
    protected static final MemoryCommandFactory memCmdFactory = ProfilingFactory.createMemoryCommandFactory();
    protected static final MethodCommandFactory methodCmdFactory = ProfilingFactory.createMethodCommandFactory();
    protected static final SynchronizationCommandFactory syncCmdFactory = ProfilingFactory.createSynchronizationCommandFactory();
    protected static final IOCommandFactory ioCmdFactory = ProfilingFactory.createIOCommandFactory();
    protected static final NetworkCommandFactory netCmdFactory = ProfilingFactory.createNetworkCommandFactory();
    protected static final ThreadCommandFactory threadCmdFactory = ProfilingFactory.createThreadCommandFactory();
    protected final Map<ThreadAnnotationKey, String> annotationFilters = new HashMap<ThreadAnnotationKey, String>();

    @Override
    public String getAnnotationFilter(ThreadAnnotationKey key) {
        if (key == null) {
            throw new IllegalArgumentException("The parameter \"key\" is null.");
        }
        return this.annotationFilters.get(key);
    }

    @Override
    public void setAnnotationFilter(ThreadAnnotationKey key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("The parameter \"key\" is null.");
        }
        this.annotationFilters.remove(key);
        if (value == null || value.equals("*") || value.equals("**")) {
            return;
        }
        this.annotationFilters.put(key, value);
    }

    @Override
    public boolean hasAnnotationFilters() {
        return this.annotationFilters != null && !this.annotationFilters.isEmpty();
    }

    ProfilingTraceSpecImpl() {
    }

    ThreadFilter createThreadFilter() {
        if (this.annotationFilters == null || this.annotationFilters.isEmpty()) {
            return null;
        }
        ThreadFilter retValue = new ThreadFilter();
        for (Map.Entry<ThreadAnnotationKey, String> entry : this.annotationFilters.entrySet()) {
            retValue.filterAnnotation(entry.getKey().getKey(), entry.getValue());
        }
        return retValue;
    }

    static List<RequestedMethodParameter> convertParameters(List<MethodParameterSpec> params) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        ArrayList<RequestedMethodParameter> retValue = new ArrayList<RequestedMethodParameter>(params.size());
        for (MethodParameterSpec param : params) {
            retValue.add(ProfilingTraceSpecImpl.convertParameter(param));
        }
        return retValue;
    }

    private static RequestedMethodParameter convertParameter(MethodParameterSpec param) {
        return new RequestedMethodParameter(param.getName(), param.getDescription(), param.getMethod(), param.getIndex(), ProfilingTraceSpecImpl.convertIncludeType(param.getIncludeType()), param.getModifiers());
    }

    private static MethodParameterIncludeType convertIncludeType(IncludeType type) {
        switch (type) {
            case INCLUDE_OVERWRITTEN: {
                return MethodParameterIncludeType.INCLUDE_OVERWRITTEN;
            }
            case NOT_OVERWRITTEN: {
                return MethodParameterIncludeType.NOT_OVERWRITTEN;
            }
            case ONLY_DECLARED_CLASS: {
                return MethodParameterIncludeType.ONLY_DECLARED_CLASS;
            }
        }
        assert (false);
        return null;
    }

    abstract Command getEnableCommand();

    abstract Command getDisableCommand();
}

